/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import java.util.NoSuchElementException;

public class IntervalIterators {
    public static final EmptyIntervalIterator EMPTY_ITERATOR = new EmptyIntervalIterator();
    public static final IntervalIterator TRUE = new FakeIterator(true);
    public static final IntervalIterator FALSE = new FakeIterator(false);

    public static final double clarkeCormackScore(IntervalIterator it, double alpha, int h) {
        double result = 0.0;
        while (it.hasNext()) {
            int lt = it.nextInterval().length();
            if (lt < h) {
                result += 1.0;
                continue;
            }
            result += Math.pow((double)h / (double)lt, alpha);
        }
        return result;
    }

    public static final double clarkeCormackScore(IntervalIterator it) {
        return IntervalIterators.clarkeCormackScore(it, 1.0, 16);
    }

    private IntervalIterators() {
    }

    public static class EmptyIntervalIterator
    extends Iterators.EmptyIterator
    implements IntervalIterator {
        public Interval nextInterval() {
            throw new NoSuchElementException();
        }

        public int extent() {
            return -1;
        }

        public void reset() {
        }

        protected EmptyIntervalIterator() {
        }
    }

    public static class FakeIterator
    extends AbstractObjectIterator
    implements IntervalIterator {
        final boolean hasNext;

        public boolean hasNext() {
            return this.hasNext;
        }

        public Interval nextInterval() {
            throw new UnsupportedOperationException();
        }

        public void reset() {
        }

        public Object next() {
            throw new UnsupportedOperationException();
        }

        public int extent() {
            return -1;
        }

        public String toString() {
            return this.getClass().getName() + '(' + Boolean.toString(this.hasNext) + ')';
        }

        private FakeIterator(boolean hasNext) {
            this.hasNext = hasNext;
        }
    }
}

