/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import java.io.Serializable;

public final class Interval
implements Serializable {
    private static final int MAX_SINGLE_POINT = 1024;
    private static final Interval[] POINT_INTERVAL = new Interval[1024];
    public final int left;
    public final int right;

    public static final Interval getInstance(int left, int right) {
        if (left == right) {
            return Interval.getInstance(left);
        }
        return new Interval(left, right);
    }

    public static final Interval getInstance(int point) {
        if (point >= 0 && point < 1024) {
            return POINT_INTERVAL[point];
        }
        return new Interval(point, point);
    }

    public final int length() {
        return this.right - this.left + 1;
    }

    public final String toString() {
        return "[" + this.left + ',' + this.right + ']';
    }

    public final int hashCode() {
        return this.left ^ this.right;
    }

    public final boolean equals(Object o) {
        if (o instanceof Interval) {
            boolean bl = false;
            if (((Interval)o).left == this.left && ((Interval)o).right == this.right) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private Interval(int left, int right) {
        if (left > right) {
            throw new IllegalArgumentException("The left extreme (" + left + ") is greater than the right extreme (" + right + ')');
        }
        this.left = left;
        this.right = right;
    }

    static {
        int i = 1024;
        while (i-- != 0) {
            Interval.POINT_INTERVAL[i] = new Interval(i, i);
        }
    }
}

