/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeapSesquiIndirectDoublePriorityQueue;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractIntersectionDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.MutableString;
import java.util.NoSuchElementException;

public class AndDocumentIterator
extends AbstractIntersectionDocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = true;

    protected IntervalIterator getComposedIntervalIterator(Index index) {
        return new AndIntervalIterator(index);
    }

    public AndDocumentIterator(DocumentIterator[] it) {
        super(it);
    }

    private class AndIntervalIterator
    extends AbstractObjectIterator
    implements IntervalIterator {
        final Index index;
        private final IntervalIterator[] it;
        private final int n;
        private final Interval[] curr;
        private final ObjectHeapSesquiIndirectDoublePriorityQueue queue;
        private boolean endOfProcess;
        private boolean nextIsLoaded;
        private int nextLeft;
        private int nextRight;
        private static final /* synthetic */ boolean $noassert;

        public void reset() {
            this.nextIsLoaded = false;
            ObjectArrays.fill((Object[])this.curr, null);
            this.queue.clear();
            int i = 0;
            while (i < this.n) {
                this.it[i] = AndDocumentIterator.this.it[i].intervalIterator(this.index);
                if (this.it[i] != IntervalIterators.TRUE && this.it[i].hasNext()) {
                    this.curr[i] = this.it[i].nextInterval();
                    this.queue.enqueue(i);
                }
                ++i;
            }
            this.endOfProcess = this.queue.isEmpty();
        }

        public boolean hasNext() {
            if (this.nextIsLoaded) {
                return true;
            }
            if (this.endOfProcess) {
                return false;
            }
            this.nextIsLoaded = true;
            do {
                this.nextLeft = this.curr[this.queue.first()].left;
                this.nextRight = this.curr[this.queue.secondaryFirst()].right;
                if (!this.it[this.queue.first()].hasNext()) {
                    this.endOfProcess = true;
                    return true;
                }
                this.curr[this.queue.first()] = this.it[this.queue.first()].nextInterval();
                this.queue.changed();
                if (!$noassert && this.curr[this.queue.secondaryFirst()].right < this.nextRight) {
                    throw new AssertionError();
                }
            } while (this.curr[this.queue.secondaryFirst()].right == this.nextRight);
            while (this.curr[this.queue.first()].left == this.nextLeft && !this.endOfProcess) {
                if (!this.it[this.queue.first()].hasNext()) {
                    this.endOfProcess = true;
                    return true;
                }
                this.curr[this.queue.first()] = this.it[this.queue.first()].nextInterval();
                this.queue.changed();
            }
            return true;
        }

        public Interval nextInterval() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextIsLoaded = false;
            return Interval.getInstance(this.nextLeft, this.nextRight);
        }

        public int extent() {
            int s = 0;
            int i = 0;
            while (i < this.n) {
                int e;
                int n = 0;
                if (this.it[i] != IntervalIterators.TRUE) {
                    n = this.it[i].extent();
                }
                if ((e = n) > 0) {
                    s += e;
                }
                ++i;
            }
            return s;
        }

        public Object next() {
            return this.nextInterval();
        }

        public String toString() {
            MutableString res = new MutableString();
            res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
            int i = 0;
            while (i < this.n) {
                res.append(i > 0 ? "," : "").append(this.it[i]);
                ++i;
            }
            return res.append(")").toString();
        }

        public AndIntervalIterator(Index index) {
            this.index = index;
            this.n = AndDocumentIterator.this.it.length;
            this.curr = new Interval[this.n];
            this.it = new IntervalIterator[this.n];
            this.queue = new ObjectHeapSesquiIndirectDoublePriorityQueue((Object[])this.curr, Intervals.LEFT_INTERVAL_COMPARATOR, Intervals.RIGHT_INTERVAL_COMPARATOR);
        }

        static {
            $noassert = Class.forName("[Lit.unimi.dsi.mg4j.search.AndDocumentIterator;").getComponentType().desiredAssertionStatus() ^ true;
        }
    }
}

