/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.query.parser.QueryParser;
import it.unimi.dsi.mg4j.query.parser.TokenMgrError;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.score.ScoredDocumentIterator;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import it.unimi.dsi.mg4j.util.ScoredDocumentBoundedSizeQueue;
import java.io.EOFException;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineLibrary;

public class Query {
    private static final String THIS_CLASS_NAME = new Query().getClass().getName();
    private static final int DISPLAY_MODE = 0;
    private static final int SCORE_MODE = 1;
    private static int mode = 0;
    private static Class scorerClass = null;
    private static int maxOutput = 50;
    private static boolean output = true;
    private static Map indexMap = new LinkedHashMap();
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$search$score$Scorer;

    private static final void printlnIfOutput(String s) {
        if (output) {
            System.out.println(s);
        }
    }

    private static final void printlnIfOutput() {
        if (output) {
            System.out.println();
        }
    }

    private static final void printIfOutput(String s) {
        if (output) {
            System.out.print(s);
        }
    }

    public static void interpretCommand(String command) {
        block10: {
            try {
                String[] parts = command.substring(1).split(" ");
                if (parts[0].equals("display")) {
                    mode = 0;
                    break block10;
                }
                if (parts[0].equals("output")) {
                    output = "off".equals(parts[1]) ^ true;
                    if (output) {
                        int out = Integer.parseInt(parts[1]);
                        maxOutput = out == 0 ? Integer.MAX_VALUE : out;
                    }
                    break block10;
                }
                if (parts[0].equals("score")) {
                    Class<?> c = Class.forName("it.unimi.dsi.mg4j.search.score." + parts[1]);
                    Class clazz = class$it$unimi$dsi$mg4j$search$score$Scorer;
                    if (clazz == null) {
                        clazz = class$it$unimi$dsi$mg4j$search$score$Scorer = Query.class$("[Lit.unimi.dsi.mg4j.search.score.Scorer;", false);
                    }
                    if (!clazz.isAssignableFrom(c)) {
                        throw new IllegalStateException("Class " + c + " is not an implementation of Scorer");
                    }
                    scorerClass = c;
                    mode = 1;
                    break block10;
                }
                if (parts[0].equals("quit")) {
                    System.exit(0);
                    break block10;
                }
                if (parts[0].equals("help")) {
                    System.err.println("!help\tprints this help");
                    System.err.println("!display\tdisplay intervals");
                    System.err.println("!output <max>\toutput at most <max> results per query");
                    System.err.println("!output off\tturns off output");
                    System.err.println("!quit\tquits the program");
                    System.err.println("!score <ScorerClass>\tdisplay scores according to <ScorerClass>");
                    break block10;
                }
                throw new IllegalStateException("Invalid command " + command);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static final void scoreModeOutput(DocumentIterator docIt, List titles) {
        Scorer s;
        try {
            s = (Scorer)scorerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        ScoredDocumentIterator sdi = s.scoredDocumentIterator(docIt);
        ScoredDocumentBoundedSizeQueue top = new ScoredDocumentBoundedSizeQueue(maxOutput);
        while (sdi.hasNext()) {
            top.enqueue(sdi.nextDocument(), sdi.score());
        }
        int i = 0;
        while (i < maxOutput && !top.isEmpty()) {
            int index = top.dequeue();
            Query.printlnIfOutput("Document #" + top.document[index] + " score " + top.score[index] + (titles != null ? " " + titles.get(top.document[index]) : ""));
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void displayModeOutput(DocumentIterator result, List titles) {
        i = 0;
        while (i < Query.maxOutput && result.hasNext()) {
            document = result.nextInt();
            Query.printlnIfOutput("Document #" + document + (titles != null ? " " + titles.get(document) : ""));
            keyIterator = Query.indexMap.keySet().iterator();
            while (keyIterator.hasNext()) {
                block4: {
                    index = (Index)Query.indexMap.get(keyIterator.next());
                    if (!result.indices().contains(index)) continue;
                    if (!index.hasPositions) break block4;
                    intIt = result.intervalIterator(index);
                    Query.printlnIfOutput("\t" + index + '[' + intIt.extent() + "]:");
                    if (intIt == IntervalIterators.TRUE) {
                        Query.printlnIfOutput("TRUE");
                        continue;
                    }
                    if (intIt != IntervalIterators.FALSE) ** GOTO lbl19
                    Query.printlnIfOutput("FALSE");
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        Query.printIfOutput("" + intIt.next() + ' ');
lbl19:
                        // 2 sources

                        ** while (intIt.hasNext())
                    }
lbl20:
                    // 1 sources

                    Query.printlnIfOutput();
                    continue;
                }
                if (!index.hasCounts || !(result instanceof IndexIterator)) continue;
                Query.printlnIfOutput("\t" + ((IndexIterator)result).count() + " occurrences");
            }
            ++i;
        }
    }

    public static void main(String[] arg) throws ParseException, TokenMgrError, IOException, ClassNotFoundException {
        List titles;
        int ch;
        String charset = "UTF-8";
        String titleFilename = null;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("titles", 1, null, 116), new LongOpt("charset", 1, null, 99)};
        Getopt g = new Getopt(THIS_CLASS_NAME, arg, "c:t:h", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            switch (ch) {
                case 104: {
                    System.err.println("Usage: " + THIS_CLASS_NAME + " [OPTIONS] INDEX...");
                    System.err.println("Reads queries from the command lines, and interrogates the given indices.");
                    System.err.println("");
                    System.err.println("Mandatory arguments:");
                    System.err.println("  INDEX      the basename of one or more indices");
                    System.err.println("");
                    System.err.println("Optional arguments:");
                    System.err.println("  -c, --charset             the input charset encoding (default: " + charset + ')');
                    System.err.println("  -t, --titles              a Java List stored object containing titles for the documents");
                    System.err.println("");
                    System.err.println("Help:");
                    System.err.println("  -h, --help        print this help screen");
                    System.err.println("");
                    return;
                }
                case 116: {
                    titleFilename = g.getOptarg();
                    break;
                }
                case 99: {
                    charset = g.getOptarg();
                    break;
                }
                case 63: {
                    return;
                }
            }
        }
        if (arg.length - g.getOptind() == 0) {
            System.err.println("You must provide one or more index basenames");
            return;
        }
        ProgressMeter pm = new ProgressMeter(1000000);
        int i = g.getOptind();
        while (i < arg.length) {
            indexMap.put(arg[i], Index.getInstance(arg[i], pm));
            ++i;
        }
        QueryParser parser = new QueryParser(indexMap, arg[g.getOptind()]);
        if (titleFilename != null) {
            System.err.print("Loading titles...");
            titles = (List)Fast.loadObject(titleFilename);
            System.err.println(" done.");
        } else {
            titles = null;
        }
        try {
            Readline.load((ReadlineLibrary)ReadlineLibrary.GnuReadline);
        }
        catch (UnsatisfiedLinkError noNativeLibrary) {
            System.err.println("Couldn't load readline native lib. Using pure-Java implementation.");
            Readline.load((ReadlineLibrary)ReadlineLibrary.PureJava);
        }
        Readline.initReadline((String)"Query");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public final void run() {
                Readline.cleanup();
            }
        });
        try {
            while (true) {
                DocumentIterator result;
                String query;
                if ((query = Readline.readline((String)"[!help]>")) == null) {
                    continue;
                }
                if (query.charAt(0) == '!') {
                    Query.interpretCommand(query);
                    continue;
                }
                try {
                    result = parser.parse(query);
                }
                catch (Throwable t) {
                    System.err.println(t);
                    continue;
                }
                long start = System.currentTimeMillis();
                switch (mode) {
                    case 0: {
                        Query.displayModeOutput(result, titles);
                        break;
                    }
                    case 1: {
                        Query.scoreModeOutput(result, titles);
                        break;
                    }
                }
                System.err.println(System.currentTimeMillis() - start + " ms");
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Query() {
    }
}

