/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.io.RepositionableStream;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OutputBitStream {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final boolean DEBUG = false;
    static final int TEMP_BUFFER_SIZE = 128;
    private OutputStream os;
    private long writtenBits;
    private int current;
    private byte[] buffer;
    private int free;
    private int pos;
    private int avail;
    private byte[] tempBuffer;
    private FileChannel fileChannel;
    private RepositionableStream rs;
    private boolean wrapping;

    public void flush() throws IOException {
        this.align();
        if (this.os != null) {
            if (this.buffer != null) {
                this.os.write(this.buffer, 0, this.pos);
                this.pos = 0;
                this.avail = this.buffer.length;
            }
            this.os.flush();
        }
    }

    public void close() throws IOException {
        if (this.os == null) {
            return;
        }
        this.flush();
        if (this.os != System.out && this.os != System.err) {
            this.os.close();
        }
        this.os = null;
        this.buffer = null;
        this.tempBuffer = null;
    }

    public long writtenBits() {
        return this.writtenBits;
    }

    public void writtenBits(long writtenBits) {
        this.writtenBits = writtenBits;
    }

    private final void write(int b) throws IOException {
        if (this.avail-- == 0) {
            if (this.os == null) {
                this.avail = 0;
                throw new IOException("Array full");
            }
            if (this.buffer == null) {
                this.os.write(b);
                this.avail = 0;
                return;
            }
            this.os.write(this.buffer);
            this.avail = this.buffer.length - 1;
            this.pos = 0;
        }
        this.buffer[this.pos++] = (byte)b;
    }

    private final int writeInCurrent(int b, int len) throws IOException {
        this.current |= (b & (1 << len) - 1) << (this.free -= len);
        if (this.free == 0) {
            this.write(this.current);
            this.free = 8;
            this.current = 0;
        }
        this.writtenBits += (long)len;
        return len;
    }

    public int align() throws IOException {
        if (this.free != 8) {
            return this.writeInCurrent(0, this.free);
        }
        return 0;
    }

    public void position(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Illegal position: " + position);
        }
        if ((position & 7L) != 0L) {
            throw new IllegalArgumentException("Not a byte-aligned position: " + position);
        }
        if (this.wrapping) {
            if (position > (long)this.buffer.length) {
                throw new IllegalArgumentException("Illegal position: " + position);
            }
            this.flush();
            this.free = 8;
            this.pos = (int)position;
            this.avail = this.buffer.length - this.pos;
        } else if (this.rs != null) {
            this.flush();
            this.rs.position(position >> 3);
        } else if (this.fileChannel != null) {
            this.flush();
            this.fileChannel.position(position >> 3);
        } else {
            throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
        }
    }

    public int write(byte[] bits, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len <= this.free) {
            return this.writeInCurrent(bits[0] >>> 8 - len, len);
        }
        int shift = this.free;
        this.writeInCurrent(bits[0] >>> 8 - shift, shift);
        int j = 0;
        int i = (len -= shift) >> 3;
        while (i-- != 0) {
            this.write(bits[j] << shift | (bits[j + 1] & 0xFF) >>> 8 - shift);
            this.writtenBits += 8L;
            ++j;
        }
        int queue = len & 7;
        if (queue != 0) {
            if (queue <= 8 - shift) {
                this.writeInCurrent(bits[j] >>> 8 - shift - queue, queue);
            } else {
                this.writeInCurrent(bits[j], 8 - shift);
                this.writeInCurrent(bits[j + 1] >>> 16 - queue - shift, queue + shift - 8);
            }
        }
        return len + shift;
    }

    public int writeBit(boolean bit) throws IOException {
        return this.writeInCurrent(bit ? 1 : 0, 1);
    }

    public int writeBit(int bit) throws IOException {
        if (bit < 0 || bit > 1) {
            throw new IllegalArgumentException("The argument " + bit + " is not a bit.");
        }
        return this.writeInCurrent(bit, 1);
    }

    public int writeInt(int x, int len) throws IOException {
        int blocks;
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot write " + len + " bits to an integer.");
        }
        if (len <= this.free) {
            return this.writeInCurrent(x, len);
        }
        int queue = len - this.free & 7;
        int i = blocks = len - this.free >> 3;
        int j = 0;
        if (queue != 0) {
            this.tempBuffer[blocks] = (byte)x;
            x >>= queue;
        }
        while (i-- != 0) {
            this.tempBuffer[i] = (byte)x;
            x >>>= 8;
        }
        this.writeInCurrent(x, this.free);
        i = blocks;
        while (i-- != 0) {
            this.write(this.tempBuffer[j++]);
        }
        this.writtenBits += (long)(blocks << 3);
        if (queue != 0) {
            this.writeInCurrent(this.tempBuffer[blocks], queue);
        }
        return len;
    }

    public int writeLong(long x, int len) throws IOException {
        int blocks;
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot write " + len + " bits to a long.");
        }
        if (len <= this.free) {
            return this.writeInCurrent((int)x, len);
        }
        int queue = len - this.free & 7;
        int i = blocks = len - this.free >> 3;
        int j = 0;
        if (queue != 0) {
            this.tempBuffer[blocks] = (byte)x;
            x >>= queue;
        }
        while (i-- != 0) {
            this.tempBuffer[i] = (byte)x;
            x >>>= 8;
        }
        this.writeInCurrent((int)x, this.free);
        i = blocks;
        while (i-- != 0) {
            this.write(this.tempBuffer[j++]);
        }
        this.writtenBits += (long)(blocks << 3);
        if (queue != 0) {
            this.writeInCurrent(this.tempBuffer[blocks], queue);
        }
        return len;
    }

    public int writeUnary(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < this.free) {
            return this.writeInCurrent(1, x + 1);
        }
        int shift = this.free;
        this.writtenBits += (long)shift;
        this.write(this.current);
        this.free = 8;
        this.current = 0;
        int i = (x -= shift) >> 3;
        this.writtenBits += (long)(x & 0x7FFFFFF8);
        while (i-- != 0) {
            this.write(0);
        }
        this.writeInCurrent(1, (x & 7) + 1);
        return x + shift + 1;
    }

    public long writeLongUnary(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < (long)this.free) {
            return this.writeInCurrent(1, (int)x + 1);
        }
        int shift = this.free;
        this.writtenBits += (long)shift;
        this.write(this.current);
        this.free = 8;
        this.current = 0;
        long i = (x -= (long)shift) >> 3;
        this.writtenBits += x & 0x7FFFFFFFFFFFFFF8L;
        while (i-- != 0L) {
            this.write(0);
        }
        this.writeInCurrent(1, (int)(x & 7L) + 1);
        return x + (long)shift + 1L;
    }

    public int writeGamma(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeUnary(msb);
        int n = 0;
        if (msb != 0) {
            n = this.writeInt(x, msb);
        }
        return l + n;
    }

    public int writeLongGamma(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeUnary(msb);
        int n = 0;
        if (msb != 0) {
            n = this.writeLong(x, msb);
        }
        return l + n;
    }

    public int writeDelta(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeGamma(msb);
        int n = 0;
        if (msb != 0) {
            n = this.writeInt(x, msb);
        }
        return l + n;
    }

    public int writeDelta(long x) throws IOException {
        return this.writeLongDelta(x);
    }

    public int writeLongDelta(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        int msb = Fast.mostSignificantBit(++x);
        int l = this.writeGamma(msb);
        int n = 0;
        if (msb != 0) {
            n = this.writeLong(x, msb);
        }
        return l + n;
    }

    public int writeMinimalBinary(int x, int b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        return this.writeMinimalBinary(x, b, Fast.mostSignificantBit(b));
    }

    public int writeMinimalBinary(int x, int b, int log2b) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        if (x >= b) {
            throw new IllegalArgumentException("The argument " + x + " exceeds the bound " + b);
        }
        int m = (1 << log2b + 1) - b;
        if (x < m) {
            return this.writeInt(x, log2b);
        }
        return this.writeInt(m + x, log2b + 1);
    }

    public int writeLongMinimalBinary(long x, long b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        return this.writeLongMinimalBinary(x, b, Fast.mostSignificantBit(b));
    }

    public int writeLongMinimalBinary(long x, long b, int log2b) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        if (x >= b) {
            throw new IllegalArgumentException("The argument " + x + " exceeds the bound " + b);
        }
        long m = (long)(1 << log2b + 1) - b;
        if (x < m) {
            return this.writeLong(x, log2b);
        }
        return this.writeLong(m + x, log2b + 1);
    }

    public int writeGolomb(int x, int b) throws IOException {
        return this.writeGolomb(x, b, Fast.mostSignificantBit(b));
    }

    public int writeGolomb(int x, int b, int log2b) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            if (x != 0) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0;
        }
        int l = this.writeUnary(x / b);
        return l + this.writeMinimalBinary(x % b, b, log2b);
    }

    public long writeLongGolomb(long x, long b) throws IOException {
        return this.writeLongGolomb(x, b, Fast.mostSignificantBit(b));
    }

    public long writeLongGolomb(long x, long b, int log2b) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 1L) {
            throw new IllegalArgumentException("The modulus " + b + " is not positive");
        }
        if (b == 0L) {
            if (x != 0L) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0L;
        }
        long l = this.writeLongUnary(x / b);
        return l + (long)this.writeLongMinimalBinary(x % b, b, log2b);
    }

    public int writeSkewedGolomb(int x, int b) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            if (x != 0) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0;
        }
        int i = Fast.mostSignificantBit(x / b + 1);
        int l = this.writeUnary(i);
        int M = ((1 << i + 1) - 1) * b;
        int m = M / (2 * b) * b;
        return l + this.writeMinimalBinary(x - m, M - m);
    }

    public long writeLongSkewedGolomb(long x, long b) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (b < 0L) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0L) {
            if (x != 0L) {
                throw new IllegalArgumentException("The modulus is 0, but the argument is " + x);
            }
            return 0L;
        }
        long i = Fast.mostSignificantBit(x / b + 1L);
        long l = this.writeLongUnary(i);
        long M = (long)((1 << (int)(i + 1L)) - 1) * b;
        long m = M / ((long)2 * b) * b;
        return l + (long)this.writeLongMinimalBinary(x - m, M - m);
    }

    public int writeZeta(int x, int k) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        int msb = Fast.mostSignificantBit(++x);
        int h = msb / k;
        int l = this.writeUnary(h);
        int left = 1 << h * k;
        return l + (x - left < left ? this.writeInt(x - left, h * k + k - 1) : this.writeInt(x, h * k + k));
    }

    public long writeLongZeta(long x, int k) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        int msb = Fast.mostSignificantBit(++x);
        int h = msb / k;
        int l = this.writeUnary(h);
        long left = 1 << h * k;
        return l + (x - left < left ? this.writeLong(x - left, h * k + k - 1) : this.writeLong(x, h * k + k));
    }

    public int writeNibble(int x) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x == 0) {
            return this.writeInt(8, 4);
        }
        int msb = Fast.mostSignificantBit(x);
        int h = msb / 3;
        do {
            boolean bl = false;
            if (h == 0) {
                bl = true;
            }
            this.writeBit(bl);
            this.writeInt(x >> h * 3, 3);
        } while (h-- != 0);
        return msb / 3 + 1 << 2;
    }

    public int writeLongNibble(long x) throws IOException {
        if (x < 0L) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x == 0L) {
            return this.writeInt(8, 4);
        }
        int msb = Fast.mostSignificantBit(x);
        int h = msb / 3;
        do {
            boolean bl = false;
            if (h == 0) {
                bl = true;
            }
            this.writeBit(bl);
            this.writeInt((int)(x >> h * 3), 3);
        } while (h-- != 0);
        return msb / 3 + 1 << 2;
    }

    private final /* synthetic */ void this() {
        this.tempBuffer = new byte[128];
    }

    protected OutputBitStream() {
        this.this();
    }

    public OutputBitStream(OutputStream os) {
        this(os, 16384);
    }

    public OutputBitStream(OutputStream os, int bufSize) {
        this.this();
        this.os = os;
        if (bufSize != 0) {
            this.buffer = new byte[bufSize];
            this.avail = bufSize;
        }
        this.free = 8;
        if (os instanceof RepositionableStream) {
            this.rs = (RepositionableStream)((Object)os);
        }
        if (this.rs == null) {
            try {
                this.fileChannel = (FileChannel)os.getClass().getMethod("getChannel", new Class[0]).invoke((Object)os, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public OutputBitStream(byte[] a) {
        this.this();
        this.free = 8;
        this.buffer = a;
        this.avail = a.length;
        this.wrapping = true;
    }

    public OutputBitStream(String name, int bufSize) throws FileNotFoundException {
        this(new FileOutputStream(name), bufSize);
    }

    public OutputBitStream(String name) throws FileNotFoundException {
        this(new FileOutputStream(name), 16384);
    }

    public OutputBitStream(File file, int bufSize) throws FileNotFoundException {
        this(new FileOutputStream(file), bufSize);
    }

    public OutputBitStream(File file) throws FileNotFoundException {
        this(new FileOutputStream(file), 16384);
    }
}

