/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.Reader;

public class FastBufferedReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected char[] buffer;
    protected int pos;
    protected int avail;
    protected Reader r;

    public int read() throws IOException {
        if (this.avail == 0) {
            this.avail = this.r.read(this.buffer);
            if (this.avail <= 0) {
                this.avail = 0;
                return -1;
            }
            this.pos = 0;
        }
        --this.avail;
        return this.buffer[this.pos++] & (char)-1;
    }

    public int read(char[] b, int offset, int length) throws IOException {
        if (length <= this.avail) {
            System.arraycopy(this.buffer, this.pos, b, offset, length);
            this.pos += length;
            this.avail -= length;
            return length;
        }
        int head = this.avail;
        System.arraycopy(this.buffer, this.pos, b, offset, head);
        this.avail = 0;
        int residual = (length -= head) % this.buffer.length;
        int result = this.r.read(b, offset += head, length - residual);
        if (result < length - residual) {
            return result < 0 ? (head != 0 ? head : -1) : result + head;
        }
        this.avail = this.r.read(this.buffer);
        if (this.avail < 0) {
            this.avail = 0;
            return result + head > 0 ? result + head : -1;
        }
        this.pos = Math.min(this.avail, residual);
        System.arraycopy(this.buffer, 0, b, offset + length - residual, this.pos);
        this.avail -= this.pos;
        return result + head + this.pos;
    }

    public MutableString readLine(MutableString s) throws IOException {
        char c = '\u0000';
        s.length(0);
        if (this.avail == 0) {
            this.avail = this.r.read(this.buffer);
            if (this.avail <= 0) {
                this.avail = 0;
                return null;
            }
            this.pos = 0;
        }
        do {
            int i = 0;
            while (i < this.avail && (c = this.buffer[this.pos + i]) != '\n' && c != '\r') {
                ++i;
            }
            s.append(this.buffer, this.pos, i);
            this.pos += i;
            this.avail -= i;
            if (this.avail > 0) {
                if (c == '\n') {
                    ++this.pos;
                    --this.avail;
                } else if (this.avail > 1) {
                    if (this.buffer[this.pos + 1] == '\n') {
                        this.pos += 2;
                        this.avail -= 2;
                    } else {
                        ++this.pos;
                        --this.avail;
                    }
                } else {
                    this.pos = 0;
                    this.avail = this.r.read(this.buffer);
                    if (this.avail <= 0) {
                        this.avail = 0;
                    } else if (this.buffer[0] == '\n') {
                        ++this.pos;
                        --this.avail;
                    }
                }
                return s;
            }
            this.pos = 0;
            this.avail = this.r.read(this.buffer);
        } while (this.avail > 0);
        this.avail = 0;
        return s;
    }

    public int readWord(MutableString s) throws IOException {
        s.length(0);
        if (this.avail == 0) {
            this.avail = this.r.read(this.buffer);
            if (this.avail <= 0) {
                this.avail = 0;
                return -1;
            }
            this.pos = 0;
        }
        do {
            int i = 0;
            while (i < this.avail && Character.isLetterOrDigit(this.buffer[this.pos + i])) {
                ++i;
            }
            s.append(this.buffer, this.pos, i);
            this.pos += i;
            this.avail -= i;
            if (this.avail > 0) {
                ++this.pos;
                --this.avail;
                return this.buffer[this.pos - 1];
            }
            this.pos = 0;
            this.avail = this.r.read(this.buffer);
        } while (this.avail > 0);
        this.avail = 0;
        return -1;
    }

    public long skip(long n) throws IOException {
        int residual;
        long result;
        if (n <= (long)this.avail) {
            int m = (int)n;
            this.pos += m;
            this.avail -= m;
            return n;
        }
        int head = this.avail;
        this.avail = 0;
        if ((result = this.r.skip((n -= (long)head) - (long)(residual = (int)(n % (long)this.buffer.length)))) < n - (long)residual) {
            this.avail = 0;
            return result + (long)head;
        }
        this.avail = Math.max(this.r.read(this.buffer), 0);
        this.pos = Math.min(residual, this.avail);
        this.avail -= this.pos;
        return result + (long)head + (long)this.pos;
    }

    public void close() throws IOException {
        if (this.r == null) {
            return;
        }
        this.r.close();
        this.r = null;
        this.buffer = null;
    }

    public FastBufferedReader(Reader r, int bufSize) {
        this.r = r;
        this.buffer = new char[bufSize];
    }

    public FastBufferedReader(Reader r) {
        this(r, 16384);
    }
}

