/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.io.FastByteArrayOutputStream;
import it.unimi.dsi.mg4j.io.NullOutputStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class SkipIndexWriter
extends IndexWriter {
    private static final int MAX_TRY = 32;
    private static final boolean ASSERTS = true;
    private static final boolean DEBUG = false;
    private static final boolean STATS = false;
    private int h;
    private int q;
    private int w;
    private int cache;
    private double pointerQuantumSigma;
    private int[] skipPointer;
    private OutputBitStream[] cachePointer;
    private FastByteArrayOutputStream[] cachePointerByte;
    private OutputBitStream[] cacheSkip;
    private OutputBitStream[] cacheSkipBitCount;
    private FastByteArrayOutputStream[] cacheSkipByte;
    private OutputBitStream[] cacheData;
    private FastByteArrayOutputStream[] cacheDataByte;
    private OutputBitStream bitCount;
    public TowerData towerData;
    public long bitsForQuantumBitLengths;
    public long bitsForEntryBitLengths;
    public long numberOfBlocks;
    public int prevEntryBitLength;
    public int prevQuantumBitLength;
    private PrintWriter pointerSkipStats;
    private PrintWriter pointerNewSkipStats;
    private PrintWriter amountSkipStats;
    private PrintWriter amountNewSkipStats;
    private PrintWriter amountNewLengthStats;
    private long[] distance;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$SkipIndex;
    private static final /* synthetic */ boolean $noassert;

    public long newInvertedList() throws IOException, IllegalStateException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        return super.newInvertedList();
    }

    public int writeFrequency(int frequency) throws IOException, IllegalStateException {
        int res = super.writeFrequency(frequency);
        this.pointerQuantumSigma = Math.sqrt((double)this.q * (1.0 - this.relativeFrequency)) / this.relativeFrequency;
        this.prevEntryBitLength = -1;
        this.prevQuantumBitLength = -1;
        if (!$noassert && this.pointerQuantumSigma == 0.0 && this.relativeFrequency != 1.0) {
            throw new AssertionError();
        }
        return res;
    }

    public long newInvertedList(int frequency) throws IOException, IllegalStateException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        long res = super.newInvertedList();
        super.writeFrequency(frequency);
        this.pointerQuantumSigma = Math.sqrt((double)this.q * (1.0 - this.relativeFrequency)) / this.relativeFrequency;
        this.prevEntryBitLength = -1;
        this.prevQuantumBitLength = -1;
        if (!$noassert && this.pointerQuantumSigma == 0.0 && this.relativeFrequency != 1.0) {
            throw new AssertionError();
        }
        return res;
    }

    public OutputBitStream newDocumentRecord() throws IOException, IllegalStateException {
        super.newDocumentRecord();
        return this.cacheData[this.cache % this.w / this.q];
    }

    public int writeDocumentPointer(OutputBitStream out, int pointer) throws IOException, IllegalStateException {
        if (this.cache == this.w) {
            this.writeOutCache(pointer);
        }
        if (this.cache % this.q == 0) {
            this.skipPointer[this.cache / this.q] = pointer;
            return super.writeDocumentPointer(this.cachePointer[this.cache++ / this.q], pointer);
        }
        return super.writeDocumentPointer(this.cacheData[this.cache++ / this.q], pointer);
    }

    public OutputBitStream newDocumentRecord(int pointer) throws IOException, IllegalStateException {
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write a new document record without calling newInvertedList");
        }
        if (this.frequency == this.writtenDocuments) {
            throw new IllegalStateException("Document record overflow (written " + this.frequency + " already)");
        }
        super.newDocumentRecord();
        if (this.cache == this.w) {
            this.writeOutCache(pointer);
        }
        if (this.cache % this.q == 0) {
            this.skipPointer[this.cache / this.q] = pointer;
            this.bitsForPointers += (long)super.writeDocumentPointer(this.cachePointer[this.cache / this.q], pointer);
        } else {
            this.bitsForPointers += (long)super.writeDocumentPointer(this.cacheData[this.cache / this.q], pointer);
        }
        return this.cacheData[this.cache++ / this.q];
    }

    private final int writeOutPointer(OutputBitStream out, int pointer) throws IOException {
        if (this.frequency == this.numberOfDocuments) {
            return 0;
        }
        switch (this.pointerCoding) {
            case 2: {
                return out.writeGamma(pointer - this.lastDocument - 1);
            }
            case 1: {
                return out.writeDelta(pointer - this.lastDocument - 1);
            }
            case 3: {
                return out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
            }
        }
        throw new IllegalStateException("The required pointer coding (" + this.pointerCoding + ") is not supported.");
    }

    public void close() throws IOException, IllegalStateException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        super.close();
    }

    private final void tryTower(int quantumBitLength, int entryBitLength, long toTheEnd, OutputBitStream[] skip, TowerData towerData) throws IOException {
        int k = (this.cache - 1) / this.q;
        while (k >= 0) {
            int s;
            toTheEnd += this.cacheData[k].writtenBits();
            int n = s = k == 0 ? this.h : Fast.leastSignificantBit(k);
            if (this.cache < this.w) {
                s = Math.min(s, Fast.mostSignificantBit(this.cache / this.q - k));
            }
            skip[k].writtenBits(0L);
            if (s >= 0) {
                int basePointer = this.skipPointer[k];
                int prevPointerDelta = this.skipPointer[k + (1 << s)] - basePointer;
                towerData.bitsForTopSkipPointers += (long)skip[k].writeGolomb(Fast.int2nat(prevPointerDelta - (int)Math.round((double)(this.q * (1 << s)) / this.relativeFrequency)), Fast.gaussianGolombModulus(this.pointerQuantumSigma * Math.sqrt(1 << s)));
                towerData.bitsForTopSkipAmounts += (long)skip[k].writeDelta(Fast.int2nat((int)(toTheEnd - this.distance[k + (1 << s)] - (long)(quantumBitLength * (1 << s) + entryBitLength * ((1 << s + 1) - s - 2)))));
                int i = s - 1;
                while (i >= 0) {
                    towerData.bitsForLowerSkipPointers += (long)skip[k].writeGolomb(Fast.int2nat(prevPointerDelta / 2 - (this.skipPointer[k + (1 << i)] - basePointer)), Fast.gaussianGolombModulus(this.pointerQuantumSigma * Math.sqrt((double)(1 << i) / (double)2)));
                    prevPointerDelta = this.skipPointer[k + (1 << i)] - basePointer;
                    towerData.bitsForLowerSkipAmounts += (long)skip[k].writeDelta(Fast.int2nat((int)((toTheEnd - this.distance[k + (1 << i + 1)] - (long)(entryBitLength * i)) / (long)2 - (toTheEnd - this.distance[k + (1 << i)]))));
                    --i;
                }
                if (s > 0) {
                    long d = this.bitCount.writeDelta(Fast.int2nat((int)skip[k].writtenBits() - (s + 1) * entryBitLength));
                    towerData.bitsForTowerLengths += d;
                    toTheEnd += d;
                }
                toTheEnd += skip[k].writtenBits();
                towerData.numberOfSkipEntries += (long)(s + 1);
                ++towerData.numberOfSkipTowers;
            }
            this.distance[k] = toTheEnd;
            toTheEnd += this.cachePointer[k].writtenBits();
            --k;
        }
    }

    private final void writeOutCache(int nextPointer) throws IOException {
        long toTheEnd;
        int nextAfter = (this.cache + this.q - 1) / this.q;
        if (nextPointer >= 0) {
            this.skipPointer[nextAfter] = nextPointer;
            toTheEnd = this.writeOutPointer(this.bitCount, nextPointer);
        } else {
            this.skipPointer[nextAfter] = this.currentDocument + 1;
            toTheEnd = 0L;
        }
        this.distance[nextAfter] = 0L;
        int quantumBitLength = 0;
        int entryBitLength = 0;
        int k = 0;
        long d = 0;
        while (k <= (this.cache - 1) / this.q) {
            d += this.cachePointer[k].writtenBits() + this.cacheData[k].writtenBits();
            ++k;
        }
        quantumBitLength = (int)((d * (long)this.q + (long)(this.cache - 1)) / (long)this.cache);
        TowerData td = new TowerData();
        Int2IntRBTreeMap candidates = new Int2IntRBTreeMap();
        this.tryTower(quantumBitLength, 0, toTheEnd, this.cacheSkipBitCount, td);
        if (td.numberOfSkipTowers > 0L) {
            while (candidates.size() < 32 && !candidates.containsValue(entryBitLength = (int)(td.bitsForTowers() / td.numberOfSkipEntries))) {
                td.clear();
                this.tryTower(quantumBitLength, entryBitLength, toTheEnd, this.cacheSkipBitCount, td);
                candidates.put((int)(td.bitsForTowers() / td.numberOfSkipEntries), entryBitLength);
            }
            if (!$noassert && candidates.size() >= 32) {
                throw new AssertionError();
            }
            entryBitLength = candidates.get(candidates.firstIntKey());
            this.tryTower(quantumBitLength, entryBitLength, toTheEnd, this.cacheSkip, this.towerData);
        }
        k = 0;
        while (k <= (this.cache - 1) / this.q) {
            int s;
            int n = s = k == 0 ? this.h : Fast.leastSignificantBit(k);
            if (this.cache < this.w) {
                s = Math.min(s, Fast.mostSignificantBit(this.cache / this.q - k));
            }
            d = this.cachePointer[k].writtenBits();
            this.cachePointer[k].flush();
            this.obs.write(this.cachePointerByte[k].array, (int)d);
            d = this.cacheSkip[k].writtenBits();
            this.cacheSkip[k].flush();
            if (s >= 0) {
                if (k == 0) {
                    if (this.prevQuantumBitLength < 0) {
                        this.bitsForQuantumBitLengths += (long)this.obs.writeLongDelta(quantumBitLength);
                        this.bitsForEntryBitLengths += (long)this.obs.writeLongDelta(entryBitLength);
                    } else {
                        this.bitsForQuantumBitLengths += (long)this.obs.writeLongDelta(Fast.int2nat(quantumBitLength - this.prevQuantumBitLength));
                        this.bitsForEntryBitLengths += (long)this.obs.writeLongDelta(Fast.int2nat(entryBitLength - this.prevEntryBitLength));
                    }
                    this.prevQuantumBitLength = quantumBitLength;
                    this.prevEntryBitLength = entryBitLength;
                    ++this.numberOfBlocks;
                }
                if (s > 0) {
                    this.obs.writeDelta(Fast.int2nat((int)d - entryBitLength * (s + 1)));
                }
            } else if (!$noassert && d != 0L) {
                throw new AssertionError();
            }
            this.obs.write(this.cacheSkipByte[k].array, (int)d);
            d = this.cacheData[k].writtenBits();
            this.cacheData[k].flush();
            this.obs.write(this.cacheDataByte[k].array, (int)d);
            ++k;
        }
        k = 0;
        while (k <= (this.cache - 1) / this.q) {
            this.cachePointerByte[k].reset();
            this.cachePointer[k].writtenBits(0L);
            this.cacheSkipByte[k].reset();
            this.cacheSkip[k].writtenBits(0L);
            this.cacheDataByte[k].reset();
            this.cacheData[k].writtenBits(0L);
            ++k;
        }
        this.cache = 0;
        if (!$noassert && this.obs.writtenBits() != this.writtenBits()) {
            throw new AssertionError();
        }
    }

    public long writtenBits() {
        return super.writtenBits() + this.towerData.bitsForTopSkipPointers + this.towerData.bitsForTopSkipAmounts + this.towerData.bitsForLowerSkipPointers + this.towerData.bitsForLowerSkipAmounts + this.towerData.bitsForTowerLengths + this.bitsForQuantumBitLengths + this.bitsForEntryBitLengths;
    }

    public Properties properties() {
        Properties result = super.properties();
        Class clazz = class$it$unimi$dsi$mg4j$index$SkipIndex;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$index$SkipIndex = SkipIndexWriter.class$("[Lit.unimi.dsi.mg4j.index.SkipIndex;", false);
        }
        result.setProperty("indexclass", clazz.getName());
        result.setProperty("skipquantum", "" + this.q);
        result.setProperty("skipheight", "" + this.h);
        return result;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public SkipIndexWriter(OutputBitStream obs, OutputBitStream offset, int N, int flags, int q, int h) {
        super(obs, offset, N, (long)flags);
        this.h = h;
        this.q = q;
        int two2h = 1 << h;
        this.w = two2h * q;
        this.towerData = new TowerData();
        this.cacheData = new OutputBitStream[two2h];
        this.cacheDataByte = new FastByteArrayOutputStream[two2h];
        this.cachePointer = new OutputBitStream[two2h];
        this.cachePointerByte = new FastByteArrayOutputStream[two2h];
        int i = 0;
        while (i < two2h) {
            this.cacheDataByte[i] = new FastByteArrayOutputStream();
            this.cacheData[i] = new OutputBitStream(this.cacheDataByte[i], 0);
            this.cachePointerByte[i] = new FastByteArrayOutputStream();
            this.cachePointer[i] = new OutputBitStream(this.cachePointerByte[i], 0);
            ++i;
        }
        this.cacheSkip = new OutputBitStream[two2h];
        this.cacheSkipBitCount = new OutputBitStream[two2h];
        this.cacheSkipByte = new FastByteArrayOutputStream[two2h];
        i = 0;
        while (i < two2h) {
            this.cacheSkipByte[i] = new FastByteArrayOutputStream();
            this.cacheSkip[i] = new OutputBitStream(this.cacheSkipByte[i]);
            this.cacheSkipBitCount[i] = new OutputBitStream(NullOutputStream.getInstance(), 0);
            ++i;
        }
        this.skipPointer = new int[two2h + 1];
        this.distance = new long[two2h + 1];
        this.bitCount = new OutputBitStream(NullOutputStream.getInstance(), 0);
    }

    public SkipIndexWriter(OutputBitStream obs, int N, int flags, int q, int h) {
        this(obs, null, N, flags, q, h);
    }

    static {
        $noassert = Class.forName("[Lit.unimi.dsi.mg4j.index.SkipIndexWriter;").getComponentType().desiredAssertionStatus() ^ true;
    }

    public static class TowerData {
        public long bitsForTopSkipAmounts;
        public long bitsForTopSkipPointers;
        public long bitsForLowerSkipAmounts;
        public long bitsForLowerSkipPointers;
        public long bitsForTowerLengths;
        public long numberOfSkipTowers;
        public long numberOfSkipEntries;

        void clear() {
            this.bitsForTopSkipAmounts = 0L;
            this.bitsForTopSkipPointers = 0L;
            this.bitsForLowerSkipAmounts = 0L;
            this.bitsForLowerSkipPointers = 0L;
            this.bitsForTowerLengths = 0L;
            this.numberOfSkipTowers = 0L;
            this.numberOfSkipEntries = 0L;
        }

        public long bitsForSkipPointers() {
            return this.bitsForTopSkipPointers + this.bitsForLowerSkipPointers;
        }

        public long bitsForSkipAmounts() {
            return this.bitsForTopSkipAmounts + this.bitsForLowerSkipAmounts;
        }

        public long bitsForEntries() {
            return this.bitsForSkipPointers() + this.bitsForSkipAmounts();
        }

        public long bitsForTowers() {
            return this.bitsForTowerLengths + this.bitsForEntries();
        }

        public long numberOfLowerEntries() {
            return this.numberOfSkipEntries - this.numberOfSkipTowers;
        }
    }
}

