/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.SkipIndex;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.IOException;

public class SkipIndexReader
extends IndexReader {
    protected static final int BEFORE_TOWER = 4;
    protected static final int FIRST_UNUSED_STATE = 5;
    private static final boolean ASSERTS = true;
    private static final boolean DEBUG = false;
    protected final SkipIndex skipIndex;
    private int maxh;
    private int s;
    private double pointerQuantumSigma;
    private int w;
    private long[] skipAmount;
    private int[] skipPointer;
    private long readBitsAtLastSkipTower;
    private int quantumBitLength;
    private int entryBitLength;
    private static final /* synthetic */ boolean $noassert;

    private final void init() {
        this.w = (1 << this.skipIndex.height) * this.skipIndex.quantum;
        this.skipAmount = new long[this.skipIndex.height + 1];
        this.skipPointer = new int[this.skipIndex.height + 1];
    }

    public int readFrequency() throws IOException, IllegalStateException {
        if (this.state == 4) {
            this.readTower();
        }
        int res = super.readFrequency();
        this.pointerQuantumSigma = Math.sqrt((double)this.skipIndex.quantum * (1.0 - this.relativeFrequency)) / this.relativeFrequency;
        this.entryBitLength = -1;
        this.quantumBitLength = -1;
        return res;
    }

    public int readDocumentPointer() throws IOException {
        if (this.state == 4) {
            this.readTower();
        }
        int pointer = super.readDocumentPointer();
        if (this.numberOfDocumentRecord % this.skipIndex.quantum == 0) {
            this.state = 4;
        }
        return pointer;
    }

    public int readPositionCount() throws IOException {
        if (this.state == 4) {
            this.readTower();
        }
        return super.readPositionCount();
    }

    private final void readTower() throws IOException {
        this.readTower(-1);
    }

    private final void readTower(int pointer) throws IOException {
        int j;
        int towerLength = 0;
        long bitsAtTowerStart = 0L;
        if (!$noassert && this.numberOfDocumentRecord % this.skipIndex.quantum != 0) {
            throw new AssertionError();
        }
        if (this.state != 4) {
            throw new IllegalStateException("readTower() called in state " + this.state);
        }
        int cacheOffset = this.numberOfDocumentRecord % this.w;
        int k = cacheOffset / this.skipIndex.quantum;
        this.s = k == 0 ? this.skipIndex.height : Fast.leastSignificantBit(k);
        int cache = this.frequency - this.w * (this.numberOfDocumentRecord / this.w);
        if (cache < this.w) {
            this.maxh = Fast.mostSignificantBit(cache / this.skipIndex.quantum - k);
            if (this.maxh < this.s) {
                this.s = this.maxh;
            }
        } else {
            this.maxh = this.skipIndex.height;
        }
        int i = this.s;
        if (this.s >= 0) {
            if (k == 0) {
                if (this.quantumBitLength < 0) {
                    this.quantumBitLength = this.ibs.readDelta();
                    this.entryBitLength = this.ibs.readDelta();
                } else {
                    this.quantumBitLength += Fast.nat2int(this.ibs.readDelta());
                    this.entryBitLength += Fast.nat2int(this.ibs.readDelta());
                }
            }
            if (this.s > 0) {
                towerLength = this.entryBitLength * (this.s + 1) + Fast.nat2int(this.ibs.readDelta());
            }
            bitsAtTowerStart = this.ibs.readBits();
            int prevPointerDelta = Fast.nat2int(this.ibs.readGolomb(Fast.gaussianGolombModulus(this.pointerQuantumSigma * Math.sqrt(1 << i)))) + (int)Math.round((double)(this.skipIndex.quantum * (1 << i)) / this.relativeFrequency);
            this.skipPointer[i] = prevPointerDelta + this.currentDocument;
            this.skipAmount[i] = this.quantumBitLength * (1 << this.s) + this.entryBitLength * ((1 << this.s + 1) - this.s - 2) + Fast.nat2int(this.ibs.readDelta());
            if (this.skipPointer[i] > pointer) {
                i = this.s - 1;
                while (i >= 0) {
                    prevPointerDelta = -Fast.nat2int(this.ibs.readGolomb(Fast.gaussianGolombModulus(this.pointerQuantumSigma * Math.sqrt((double)(1 << i) / (double)2)))) + prevPointerDelta / 2;
                    this.skipPointer[i] = prevPointerDelta + this.currentDocument;
                    this.skipAmount[i] = (this.skipAmount[i + 1] - (long)(this.entryBitLength * i)) / (long)2 - (long)Fast.nat2int(this.ibs.readDelta());
                    if (this.skipPointer[i] <= pointer) break;
                    --i;
                }
            }
        }
        if (i > 0) {
            j = this.s;
            while (j >= i) {
                int n = j--;
                this.skipAmount[n] = this.skipAmount[n] + ((long)towerLength - (this.ibs.readBits() - bitsAtTowerStart));
            }
            while (j >= 0) {
                this.skipPointer[j] = Integer.MAX_VALUE;
                --j;
            }
        } else {
            this.state = this.skipIndex.hasCounts + 1;
        }
        long delta = this.ibs.readBits() - this.readBitsAtLastSkipTower;
        j = this.s + 1;
        while (j <= this.maxh) {
            int n = j++;
            this.skipAmount[n] = this.skipAmount[n] - delta;
        }
        this.readBitsAtLastSkipTower = this.ibs.readBits();
    }

    protected boolean justAfterPointer() {
        boolean bl = false;
        if (this.state == 4 || this.numberOfDocumentRecord % this.skipIndex.quantum != 0 && super.justAfterPointer()) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public boolean skipTo(int p) throws IOException {
        if (this.endOfList()) {
            return false;
        }
        if (!this.justAfterPointer()) {
            this.readDocumentPointer();
        }
        if (this.currentDocument >= p) {
            return true;
        }
        if (this.state == 4) {
            this.readTower(p);
        }
        while (true) {
            cacheOffset = this.numberOfDocumentRecord % this.w;
            k = cacheOffset / this.skipIndex.quantum;
            if (this.maxh < 0) ** GOTO lbl41
            j = i = Fast.mostSignificantBit(~k & (1 << this.maxh) - 1) + 1;
            while (j >= 0) {
                if (!SkipIndexReader.$noassert && this.skipPointer[i] == 0x7FFFFFFF) {
                    throw new AssertionError();
                }
                --j;
            }
            while (i >= 0) {
                if (this.skipPointer[i] <= p) break;
                --i;
            }
            if (i < 0) ** GOTO lbl41
            this.ibs.skip(this.skipAmount[i] - (this.ibs.readBits() - this.readBitsAtLastSkipTower));
            this.state = 4;
            this.currentDocument = this.skipPointer[i];
            this.numberOfDocumentRecord += ((k & -(1 << i)) + (1 << i)) * this.skipIndex.quantum - cacheOffset;
            if (this.endOfList()) {
                v0 = false;
                if (this.currentDocument == p) {
                    v0 = true;
                }
                return v0;
            }
            this.readTower(p);
        }
lbl-1000:
        // 1 sources

        {
            if (this.endOfList()) {
                return false;
            }
            this.readDocumentPointer();
lbl41:
            // 3 sources

            ** while (this.currentDocument < p)
        }
lbl42:
        // 1 sources

        return true;
    }

    public String toString() {
        return "SkipIndexReader term=" + this.term + " docNum=" + this.numberOfDocumentRecord;
    }

    public SkipIndexReader(Index index) throws IOException {
        super(index);
        this.skipIndex = (SkipIndex)index;
        this.init();
    }

    public SkipIndexReader(Index index, int bufferSize) throws IOException {
        super(index, bufferSize);
        this.skipIndex = (SkipIndex)index;
        this.init();
    }

    public SkipIndexReader(Index index, InputBitStream ibs) throws IOException {
        super(index, ibs);
        this.skipIndex = (SkipIndex)index;
        this.init();
    }

    public SkipIndexReader(InputBitStream ibs, LongList offsets, IntList sizes, int N, long flags, int q, int h) throws IOException {
        this(new SkipIndex(null, null, null, N, -1, -1, true, flags, null, offsets, sizes, q, h));
        this.ibs = ibs;
        this.frequency = -1;
        this.state = 0;
        this.init();
        if ((long)this.skipIndex.positionCoding == 0x5000000L) {
            ibs.overflow(true);
        }
    }

    public SkipIndexReader(InputBitStream ibs, LongList offsets, int N, long flags, int q, int h) throws IOException {
        this(ibs, offsets, null, N, flags, q, h);
    }

    public SkipIndexReader(InputBitStream ibs, int N, long flags, int q, int h) throws IOException {
        this(ibs, null, N, flags, q, h);
    }

    static {
        $noassert = Class.forName("[Lit.unimi.dsi.mg4j.index.SkipIndexReader;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

