/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.io.ArithmeticDecoder;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.InterpolativeCoding;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IndexReader
implements CompressionFlags {
    protected static final int BEFORE_FREQUENCY = 0;
    protected static final int BEFORE_POINTER = 1;
    protected static final int BEFORE_COUNT = 2;
    protected static final int BEFORE_POSITIONS = 3;
    protected static final int FIRST_UNUSED_STATE = 4;
    private static final boolean ASSERTS = true;
    protected final Index index;
    protected InputBitStream ibs;
    protected int b;
    protected int log2b;
    protected int term;
    protected int frequency;
    protected int count;
    protected double relativeFrequency;
    protected int currentDocument;
    protected int numberOfDocumentRecord;
    protected int state;
    private static final /* synthetic */ boolean $noassert;

    public void position(int term) throws IOException {
        if (this.index.offsets == null) {
            throw new IllegalStateException("You cannot position an index without offsets");
        }
        this.ibs.position(this.index.offsets.getLong(term) << 3);
        this.ibs.readBits(0L);
        this.term = term;
        this.state = 0;
    }

    public boolean endOfList() {
        boolean bl = false;
        if (this.numberOfDocumentRecord >= this.frequency - 1) {
            bl = true;
        }
        return bl;
    }

    public int readFrequency() throws IOException, IllegalStateException {
        if (this.state == 1 && this.endOfList()) {
            if (++this.term >= this.index.numberOfTerms) {
                throw new IllegalStateException("Trying to read beyond last inverted list");
            }
            this.state = 0;
            this.ibs.align();
        }
        if (this.state != 0) {
            throw new IllegalStateException("Trying to read frequency in state " + this.state);
        }
        switch (this.index.frequencyCoding) {
            case 2: {
                this.frequency = this.ibs.readGamma() + 1;
                break;
            }
            case 1: {
                this.frequency = this.ibs.readDelta() + 1;
                break;
            }
            default: {
                throw new IllegalStateException("The required frequency coding (" + this.index.frequencyCoding + ") is not supported.");
            }
        }
        this.relativeFrequency = (double)this.frequency / (double)this.index.numberOfDocuments;
        if (this.index.pointerCoding == 3) {
            this.b = Fast.golombModulus((double)this.frequency / (double)this.index.numberOfDocuments);
            this.log2b = Fast.mostSignificantBit(this.b);
        }
        this.count = -1;
        this.currentDocument = -1;
        this.numberOfDocumentRecord = -1;
        this.state = 1;
        return this.frequency;
    }

    public int readDocumentPointer() throws IOException {
        if (this.state == 0) {
            throw new IllegalStateException("readDocumentPointer() called before having read frequency");
        }
        if (this.endOfList()) {
            throw new NoSuchElementException("readDocumentPointer() called beyond end of list");
        }
        if (this.index.hasCounts && this.state == 2) {
            this.readPositionCount();
        }
        if (this.index.hasPositions && this.state == 3) {
            this.readDocumentPositions(null);
        }
        if (this.state != 1) {
            throw new IllegalStateException("readDocumentPointer() called in unknown state " + this.state);
        }
        if (this.frequency != this.index.numberOfDocuments) {
            switch (this.index.pointerCoding) {
                case 2: {
                    this.currentDocument += this.ibs.readGamma() + 1;
                    break;
                }
                case 1: {
                    this.currentDocument += this.ibs.readDelta() + 1;
                    break;
                }
                case 3: {
                    this.currentDocument += this.ibs.readGolomb(this.b, this.log2b) + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required pointer coding (" + this.index.pointerCoding + ") is not supported.");
                }
            }
        } else {
            ++this.currentDocument;
        }
        ++this.numberOfDocumentRecord;
        if (this.index.hasCounts) {
            this.state = 2;
            this.count = -1;
        } else {
            this.state = 1;
        }
        return this.currentDocument;
    }

    public int currentDocumentPointer() {
        return this.currentDocument;
    }

    protected boolean justAfterPointer() {
        boolean bl = false;
        if (this.index.hasCounts && this.state == 2 || !this.index.hasCounts && this.state == 1) {
            bl = true;
        }
        return bl;
    }

    public int readPositionCount() throws IOException, NoSuchElementException {
        if (this.state != 2) {
            throw new IllegalStateException("Trying to call readPositionCount() in state " + this.state);
        }
        this.state = this.index.hasPositions ? 3 : 1;
        switch (this.index.countCoding) {
            case 2: {
                this.count = this.ibs.readGamma() + 1;
                return this.count;
            }
            case 1: {
                this.count = this.ibs.readDelta() + 1;
                return this.count;
            }
        }
        throw new IllegalStateException("The required count coding (" + this.index.countCoding + ") is not supported.");
    }

    public int readDocumentPositions(int[] occ) throws IOException, NoSuchElementException {
        int docSize;
        if (this.state != 3) {
            throw new IllegalStateException("Trying to call readDocumentPositions() in state " + this.state);
        }
        int n = docSize = this.index.sizes != null ? this.index.sizes.getInt(this.currentDocument) : -1;
        if (occ != null && this.count > occ.length) {
            return -this.count;
        }
        this.state = 1;
        int prev = -1;
        switch (this.index.positionCoding) {
            case 2: {
                if (occ != null) {
                    int i = 0;
                    while (i < this.count) {
                        prev = occ[i] = this.ibs.readGamma() + prev + 1;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.count) {
                        this.ibs.readGamma();
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                if (occ != null) {
                    int i = 0;
                    while (i < this.count) {
                        prev = occ[i] = this.ibs.readDelta() + prev + 1;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.count) {
                        this.ibs.readDelta();
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                if (!$noassert && this.index.sizes == null) {
                    throw new AssertionError();
                }
                if (this.count < 3) {
                    if (occ != null) {
                        int i = 0;
                        while (i < this.count) {
                            occ[i] = this.ibs.readMinimalBinary(docSize);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < this.count) {
                            this.ibs.readMinimalBinary(docSize);
                            ++i;
                        }
                    }
                    return this.count;
                }
                int b = Fast.golombModulus((double)this.count / (double)docSize);
                int log2b = Fast.mostSignificantBit(b);
                if (occ != null) {
                    if (b != 0) {
                        int i = 0;
                        while (i < this.count) {
                            prev = occ[i] = this.ibs.readGolomb(b, log2b) + prev + 1;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < this.count) {
                            occ[i] = i;
                            ++i;
                        }
                    }
                } else {
                    if (b == 0) break;
                    int i = 0;
                    while (i < this.count) {
                        this.ibs.readGolomb(b, log2b);
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                if (this.count < 3) {
                    if (occ != null) {
                        int i = 0;
                        while (i < this.count) {
                            occ[i] = this.ibs.readMinimalBinary(docSize);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < this.count) {
                            this.ibs.readMinimalBinary(docSize);
                            ++i;
                        }
                    }
                    return this.count;
                }
                int sb = this.ibs.readMinimalBinary(docSize) + 1;
                if (occ != null) {
                    int i = 0;
                    while (i < this.count) {
                        prev = occ[i] = this.ibs.readSkewedGolomb(sb) + prev + 1;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.count) {
                        this.ibs.readSkewedGolomb(sb);
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                if (occ != null) {
                    prev = occ[0] = this.ibs.readMinimalBinary(docSize);
                } else {
                    this.ibs.readMinimalBinary(docSize);
                }
                if (this.count <= 1) break;
                ArithmeticDecoder decoder = new ArithmeticDecoder(this.ibs.readMinimalBinary(docSize));
                if (occ != null) {
                    int i = 1;
                    while (i < this.count) {
                        prev = occ[i] = decoder.decode(this.ibs) + prev + 1;
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i < this.count) {
                        decoder.decode(this.ibs);
                        ++i;
                    }
                }
                decoder.flush(this.ibs);
                this.ibs.ungetLong(decoder.getWindow(), 63);
                break;
            }
            case 6: {
                InterpolativeCoding.read(this.ibs, occ, 0, this.count, 0, docSize - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required position coding (" + this.index.positionCoding + ") is not supported.");
            }
        }
        return this.count;
    }

    public boolean skipTo(int p) throws IOException {
        if (this.endOfList()) {
            return false;
        }
        if (!this.justAfterPointer()) {
            this.readDocumentPointer();
        }
        while (this.currentDocument < p) {
            if (this.endOfList()) {
                return false;
            }
            this.readDocumentPointer();
        }
        return true;
    }

    public long readBits() {
        return this.ibs.readBits();
    }

    public void close() throws IOException, IllegalStateException {
        this.ibs.close();
    }

    public DocumentIterator documents(int term) throws IOException {
        return new IndexReaderDocumentIterator(term);
    }

    public DocumentIterator documents(CharSequence term) throws IOException {
        if (this.index.termMap != null) {
            int termIndex = this.index.termMap.get(this.index.isCaseSensitive ? term : new MutableString(term).toLowerCase());
            return termIndex == -1 ? this.index.emptyDocumentIterator : this.documents(termIndex);
        }
        throw new UnsupportedOperationException("Index " + this.index + " has no term map");
    }

    public IndexReader(Index index) throws IOException {
        this(index, 16384);
    }

    public IndexReader(Index index, int bufferSize) throws IOException {
        this(index, new InputBitStream(index.indexFile, bufferSize));
    }

    public IndexReader(Index index, InputBitStream ibs) throws IOException {
        this.index = index;
        this.ibs = ibs;
    }

    public IndexReader(InputBitStream ibs, LongList offsets, IntList sizes, int N, long flags) throws IOException {
        this(new Index(null, null, null, N, -1, -1, true, flags, null, offsets, sizes));
        this.ibs = ibs;
        this.frequency = -1;
        this.state = 0;
        if ((long)this.index.positionCoding == 0x5000000L) {
            ibs.overflow(true);
        }
    }

    public IndexReader(InputBitStream ibs, LongList offsets, int N, long flags) throws IOException {
        this(ibs, offsets, null, N, flags);
    }

    public IndexReader(InputBitStream ibs, int N, long flags) throws IOException {
        this(ibs, null, null, N, flags);
    }

    static {
        $noassert = Class.forName("[Lit.unimi.dsi.mg4j.index.IndexReader;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IndexReaderDocumentIterator
    extends AbstractIntIterator
    implements IndexIterator {
        private static final boolean DEBUG = false;
        private final IndexIntervalIterator intervalIterator;
        private final Map singletonIntervalIterator;

        public int frequency() {
            return IndexReader.this.frequency;
        }

        public int document() {
            if (IndexReader.this.currentDocument < 0) {
                throw new IllegalStateException();
            }
            return IndexReader.this.currentDocument;
        }

        public int count() {
            if (!IndexReader.this.index.hasCounts) {
                throw new UnsupportedOperationException("This index does not contain counts");
            }
            try {
                if (IndexReader.this.count == -1) {
                    IndexReader.this.readPositionCount();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return IndexReader.this.count;
        }

        public IntIterator positions() {
            this.count();
            return IntIterators.wrap((int[])this.positionArray(), (int)0, (int)IndexReader.this.count);
        }

        public int[] positionArray() {
            int[] a = new int[this.count()];
            this.positions(a);
            return a;
        }

        public int positions(int[] positions) {
            if (!IndexReader.this.index.hasPositions) {
                throw new UnsupportedOperationException("This index does not contain positions");
            }
            this.count();
            try {
                return IndexReader.this.readDocumentPositions(positions);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int skipTo(int n) {
            try {
                if (IndexReader.this.currentDocument >= n) {
                    return IndexReader.this.currentDocument;
                }
                if (IndexReader.this.endOfList()) {
                    return -1;
                }
                IndexReader.this.skipTo(n);
                if (IndexReader.this.index.hasPositions) {
                    this.intervalIterator.reset();
                }
                return IndexReader.this.currentDocument >= n ? IndexReader.this.currentDocument : -1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasNext() {
            return IndexReader.this.endOfList() ^ true;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                IndexReader.this.readDocumentPointer();
                if (IndexReader.this.index.hasPositions) {
                    this.intervalIterator.reset();
                }
                return IndexReader.this.currentDocument;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int nextDocument() {
            return this.nextInt();
        }

        public String toString() {
            return IndexReader.this.index + " [" + IndexReader.this.term + ']';
        }

        public Map intervalIterators() {
            return this.singletonIntervalIterator;
        }

        public IntervalIterator intervalIterator() {
            return this.intervalIterator(IndexReader.this.index);
        }

        public IntervalIterator intervalIterator(Index index) {
            return index == IndexReader.this.index ? this.intervalIterator : (IndexReader.this.count > 0 ? IntervalIterators.TRUE : IntervalIterators.FALSE);
        }

        public Set indices() {
            return IndexReader.this.index.singletonSet;
        }

        private final /* synthetic */ void this() {
            this.intervalIterator = IndexReader.this.index.hasPositions ? new IndexIntervalIterator() : null;
            this.singletonIntervalIterator = Reference2ReferenceMaps.singleton((Object)IndexReader.this.index, (Object)this.intervalIterator);
        }

        public IndexReaderDocumentIterator(int term) throws IOException {
            this.this();
            IndexReader.this.position(term);
            IndexReader.this.readFrequency();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private class IndexIntervalIterator
        extends AbstractObjectIterator
        implements IntervalIterator {
            int[] positions;
            int pos;
            int count;

            public void reset() {
                this.pos = -1;
                this.count = IndexReaderDocumentIterator.this.count();
            }

            private final void ensurePositions() {
                if (this.pos < 0 && this.count >= 0) {
                    if (IndexReaderDocumentIterator.this.positions(this.positions) < 0) {
                        this.positions = IndexReaderDocumentIterator.this.positionArray();
                    }
                    this.pos = 0;
                }
            }

            public boolean hasNext() {
                this.ensurePositions();
                boolean bl = false;
                if (this.pos < this.count) {
                    bl = true;
                }
                return bl;
            }

            public Interval nextInterval() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Interval.getInstance(this.positions[this.pos++]);
            }

            public int extent() {
                return 1;
            }

            public Object next() {
                return this.nextInterval();
            }

            public String toString() {
                return IndexReader.this.index + ": #" + IndexReader.this.term + "[doc=" + IndexReader.this.currentDocument + ", count=" + this.count + ", pos=" + this.pos + ']';
            }

            private final /* synthetic */ void this() {
                this.positions = IntArrays.EMPTY_ARRAY;
                this.pos = -1;
            }

            private IndexIntervalIterator() {
                this.this();
            }
        }
    }
}

