/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Index
implements CompressionFlags {
    public final String basename;
    public final Properties properties;
    public final File indexFile;
    public final int numberOfDocuments;
    public final int numberOfTerms;
    public final int maxDocPos;
    public final int frequencyCoding;
    public final int pointerCoding;
    public final int countCoding;
    public final int positionCoding;
    public final boolean hasCounts;
    public final boolean hasPositions;
    public final boolean isCaseSensitive;
    public final Set singletonSet;
    public final LongList offsets;
    public final IntList sizes;
    public final TermMap termMap;
    public final EmptyDocumentIterator emptyDocumentIterator;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$Index;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$TermMap;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$util$ProgressMeter;

    private static final long string2Flags(String flagString) throws IOException {
        long flags = 0L;
        if (flagString.length() != 0) {
            String[] f = flagString.split("\\|");
            int i = 0;
            while (i < f.length) {
                try {
                    Class clazz = class$it$unimi$dsi$mg4j$index$Index;
                    if (clazz == null) {
                        clazz = Index.class$("[Lit.unimi.dsi.mg4j.index.Index;", false);
                    }
                    Field field = clazz.getField(f[i].trim());
                    Class clazz2 = class$it$unimi$dsi$mg4j$index$Index;
                    if (clazz2 == null) {
                        clazz2 = Index.class$("[Lit.unimi.dsi.mg4j.index.Index;", false);
                    }
                    flags |= field.getLong(clazz2);
                }
                catch (Exception notFound) {
                    throw new IOException("Compression flag " + f[i] + " unknown.");
                }
                ++i;
            }
        }
        return flags;
    }

    public static LongList readOffsets(InputBitStream in, int T, ProgressMeter pm) throws IOException {
        long[] offset = new long[T + 1];
        offset[0] = in.readGamma();
        if (pm != null) {
            pm.expectedUpdates(T);
            pm.start("Reading offsets...");
            int i = 0;
            while (i < T) {
                pm.update();
                offset[i + 1] = (long)in.readGamma() + offset[i];
                ++i;
            }
            pm.done();
        } else {
            int i = 0;
            while (i < T) {
                offset[i + 1] = (long)in.readGamma() + offset[i];
                ++i;
            }
        }
        return LongArrayList.wrap((long[])offset);
    }

    public static IntList readSizes(InputBitStream in, int N, ProgressMeter pm) throws IOException {
        int[] size = new int[N];
        if (pm != null) {
            pm.start("Reading sizes...");
            pm.expectedUpdates(N);
            int i = 0;
            while (i < N) {
                pm.update();
                size[i] = in.readGamma();
                ++i;
            }
            pm.done();
        } else {
            int i = 0;
            while (i < N) {
                size[i] = in.readGamma();
                ++i;
            }
        }
        return IntArrayList.wrap((int[])size);
    }

    public static TermMap loadTermMap(String filename) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));
            TermMap result = (TermMap)ois.readObject();
            ois.close();
            return result;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Index getInstance(CharSequence basename, TermMap termMap, boolean loadOffsets, ProgressMeter pm) throws IOException {
        String propertyFilename = basename + ".properties";
        if (!new File(propertyFilename).exists()) {
            throw new FileNotFoundException("Cannot open property file " + propertyFilename);
        }
        FileInputStream propertyFile = new FileInputStream(propertyFilename);
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        try {
            Class clazz;
            Class<?> clazz2 = Class.forName(properties.getProperty("indexclass", "unspecified"));
            Class[] classArray = new Class[4];
            Class clazz3 = class$java$lang$CharSequence;
            if (clazz3 == null) {
                clazz3 = classArray[0] = (class$java$lang$CharSequence = Index.class$("[Ljava.lang.CharSequence;", false));
            }
            if ((clazz = class$it$unimi$dsi$mg4j$index$TermMap) == null) {
                clazz = class$it$unimi$dsi$mg4j$index$TermMap = Index.class$("[Lit.unimi.dsi.mg4j.index.TermMap;", false);
            }
            classArray[1] = clazz;
            classArray[2] = Boolean.TYPE;
            Class clazz4 = class$it$unimi$dsi$mg4j$util$ProgressMeter;
            if (clazz4 == null) {
                clazz4 = class$it$unimi$dsi$mg4j$util$ProgressMeter = Index.class$("[Lit.unimi.dsi.mg4j.util.ProgressMeter;", false);
            }
            classArray[3] = clazz4;
            Constructor<?> constructor = clazz2.getDeclaredConstructor(classArray);
            return (Index)constructor.newInstance(basename, termMap, loadOffsets, pm);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            System.err.println("The Index factory was not able to locate a suitable constructor for the index class " + properties.getProperty("indexclass", "unspecified"));
            throw new RuntimeException(e);
        }
    }

    public static Index getInstance(CharSequence basename, boolean loadOffsets, ProgressMeter pm) throws IOException {
        return Index.getInstance(basename, Index.loadTermMap(basename + ".termmap"), loadOffsets, pm);
    }

    public static Index getInstance(CharSequence basename, ProgressMeter pm) throws IOException {
        return Index.getInstance(basename, Index.loadTermMap(basename + ".termmap"), true, pm);
    }

    public static Index getInstance(CharSequence basename) throws IOException {
        return Index.getInstance(basename, Index.loadTermMap(basename + ".termmap"), true, null);
    }

    public IndexReader getReader() throws IOException {
        return this.getReader(16384);
    }

    public IndexReader getReader(int bufferSize) throws IOException {
        return new IndexReader(this, bufferSize);
    }

    public String toString() {
        return this.basename;
    }

    public static void main(String[] arg) throws IOException {
        int ch;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104)};
        Getopt g = new Getopt("Index", arg, "hos", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            if (ch != 104) continue;
            System.err.println("Usage: Index [OPTIONS] BASENAME");
            System.err.println("Loads an index.");
            System.err.println("");
            System.err.println("Mandatory arguments:");
            System.err.println("  BASENAME    all file names will be stemmed from this name");
            System.err.println("");
            System.err.println("Optional arguments:");
            System.err.println("");
            System.err.println("Help:");
            System.err.println("  -h, --help        print this help screen");
            System.err.println("");
            return;
        }
        if (arg.length - g.getOptind() != 1) {
            System.err.println("Wrong number (" + (arg.length - g.getOptind()) + ") of arguments.");
            return;
        }
        String basename = arg[g.getOptind()];
        Index index = Index.getInstance(basename, new ProgressMeter(100000, "ints", System.out));
        System.out.println(" Index class:      " + index.getClass());
        System.out.println("Frequency coding: " + CODING_NAME[index.frequencyCoding]);
        System.out.println("Pointer coding:   " + CODING_NAME[index.pointerCoding]);
        System.out.println("Count coding:     " + (index.countCoding == 255 ? "Not stored" : CODING_NAME[index.countCoding]));
        System.out.println("Position coding:  " + (index.positionCoding == 255 ? "Not stored" : CODING_NAME[index.positionCoding]));
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.emptyDocumentIterator = new EmptyDocumentIterator();
    }

    protected Index(CharSequence basename, TermMap termMap, boolean loadOffsets, ProgressMeter pm) throws IOException {
        this.this();
        this.basename = basename.toString();
        this.termMap = termMap;
        this.singletonSet = ObjectSets.singleton((Object)this);
        this.indexFile = new File(this.basename + ".index");
        if (!this.indexFile.exists()) {
            throw new FileNotFoundException("Cannot find index file " + this.indexFile.getName());
        }
        String propertyFilename = this.basename + ".properties";
        if (!new File(propertyFilename).exists()) {
            throw new FileNotFoundException("Cannot open property file " + propertyFilename);
        }
        FileInputStream propertyFile = new FileInputStream(propertyFilename);
        this.properties = new Properties();
        this.properties.load(propertyFile);
        propertyFile.close();
        this.numberOfDocuments = Integer.parseInt(this.properties.getProperty("documents"));
        this.numberOfTerms = Integer.parseInt(this.properties.getProperty("terms"));
        this.maxDocPos = Integer.parseInt(this.properties.getProperty("maxdocpos"));
        long flags = Index.string2Flags(this.properties.getProperty("compressionflags"));
        this.frequencyCoding = (int)(((flags & 0xFFL) != 0L ? flags : (long)2) & 0xFFL);
        this.pointerCoding = (int)(((flags >>> 8 & 0xFFL) != 0L ? flags : 768L) >>> 8 & 0xFFL);
        this.countCoding = (int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL);
        boolean bl = false;
        if (this.countCoding != 255) {
            bl = this.hasCounts = true;
        }
        if (!this.hasCounts) {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : -16777216L) >>> 24 & 0xFFL);
            if (this.positionCoding != 255) {
                throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
            }
        } else {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0x3000000L) >>> 24 & 0xFFL);
        }
        boolean bl2 = false;
        if (this.positionCoding != 255) {
            bl2 = this.hasPositions = true;
        }
        if (!this.hasCounts && this.hasPositions) {
            throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
        }
        this.isCaseSensitive = Boolean.valueOf(this.properties.getProperty("iscasesensitive"));
        this.sizes = this.positionCoding == 3 || this.positionCoding == 6 ? Index.readSizes(new InputBitStream(basename + ".sizes"), this.numberOfDocuments, pm) : null;
        this.offsets = loadOffsets ? Index.readOffsets(new InputBitStream(basename + ".offsets"), this.numberOfTerms, pm) : null;
    }

    public Index(String basename, File indexFile, Properties properties, int numberOfDocuments, int numberOfTerms, int maxDocPos, boolean isCaseSensitive, long flags, TermMap termMap, LongList offsets, IntList sizes) throws IOException {
        this.this();
        this.basename = basename;
        this.indexFile = indexFile;
        this.properties = properties;
        this.numberOfDocuments = numberOfDocuments;
        this.numberOfTerms = numberOfTerms;
        this.maxDocPos = maxDocPos;
        this.isCaseSensitive = isCaseSensitive;
        this.sizes = sizes;
        this.termMap = termMap;
        this.offsets = offsets;
        this.singletonSet = ObjectSets.singleton((Object)this);
        this.frequencyCoding = (int)(((flags & 0xFFL) != 0L ? flags : (long)2) & 0xFFL);
        this.pointerCoding = (int)(((flags >>> 8 & 0xFFL) != 0L ? flags : 768L) >>> 8 & 0xFFL);
        this.countCoding = (int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL);
        boolean bl = false;
        if (this.countCoding != 255) {
            bl = this.hasCounts = true;
        }
        if (!this.hasCounts) {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : -16777216L) >>> 24 & 0xFFL);
            if (this.positionCoding != 255) {
                throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
            }
        } else {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0x3000000L) >>> 24 & 0xFFL);
        }
        boolean bl2 = false;
        if (this.positionCoding != 255) {
            bl2 = this.hasPositions = true;
        }
        if (!this.hasCounts && this.hasPositions) {
            throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
        }
    }

    private class EmptyDocumentIterator
    extends Iterators.EmptyIterator
    implements IndexIterator {
        public int document() {
            return -1;
        }

        public Set indices() {
            return Index.this.singletonSet;
        }

        public IntervalIterator intervalIterator() {
            throw new IllegalStateException();
        }

        public Map intervalIterators() {
            throw new IllegalStateException();
        }

        public IntervalIterator intervalIterator(Index index) {
            throw new IllegalStateException();
        }

        public int nextDocument() {
            throw new NoSuchElementException();
        }

        public int skipTo(int n) {
            return -1;
        }

        public int frequency() {
            throw new IllegalStateException();
        }

        public int count() {
            throw new IllegalStateException();
        }

        public IntIterator positions() {
            throw new IllegalStateException();
        }

        public int positions(int[] positions) {
            throw new IllegalStateException();
        }

        public int[] positionArray() {
            throw new IllegalStateException();
        }

        private EmptyDocumentIterator() {
        }
    }
}

