/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.wga.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class Text2DataOutput {
    static final int IO_BUFFER_SIZE = 65536;

    private Text2DataOutput() {
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(Text2DataOutput.class.getName(), "Converts a text file containing numbers to binary (DataOutput) format.", new Parameter[]{new UnflaggedOption("textFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The intput text file."), new UnflaggedOption("binaryFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The output binary file."), new FlaggedOption("kind", (StringParser)JSAP.STRING_PARSER, "int", false, 'k', "kind", "The data kind: byte, int, short, long, double, float (default: int).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Kind kind = Kind.INT;
        String kindString = jsapResult.getString("kind");
        if (kindString.equalsIgnoreCase("byte")) {
            kind = Kind.BYTE;
        } else if (kindString.equalsIgnoreCase("short")) {
            kind = Kind.SHORT;
        } else if (kindString.equalsIgnoreCase("int")) {
            kind = Kind.INT;
        } else if (kindString.equalsIgnoreCase("long")) {
            kind = Kind.LONG;
        } else if (kindString.equalsIgnoreCase("float")) {
            kind = Kind.FLOAT;
        } else if (kindString.equalsIgnoreCase("double")) {
            kind = Kind.DOUBLE;
        } else {
            System.err.println("Kind is " + kindString + ", instead it must be one of: byte, int, short, long, float, double.");
            System.exit(1);
        }
        String inFileName = jsapResult.getString("textFile");
        String outFileName = jsapResult.getString("binaryFile");
        FastBufferedReader in = new FastBufferedReader((Reader)new InputStreamReader(inFileName.equals("-") ? System.in : new FileInputStream(inFileName), "UTF-8"), 65536);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outFileName.equals("-") ? System.out : new FileOutputStream(outFileName), 65536));
        MutableString s = new MutableString();
        switch (kind) {
            case BYTE: {
                while (in.readLine(s) != null) {
                    out.writeByte(Byte.decode(s.toString()).byteValue());
                }
                break;
            }
            case INT: {
                while (in.readLine(s) != null) {
                    out.writeInt(Integer.parseInt(s.toString()));
                }
                break;
            }
            case SHORT: {
                while (in.readLine(s) != null) {
                    out.writeShort(Short.parseShort(s.toString()));
                }
                break;
            }
            case LONG: {
                while (in.readLine(s) != null) {
                    out.writeLong(Long.parseLong(s.toString()));
                }
                break;
            }
            case FLOAT: {
                while (in.readLine(s) != null) {
                    out.writeFloat(Float.parseFloat(s.toString()));
                }
                break;
            }
            case DOUBLE: {
                while (in.readLine(s) != null) {
                    out.writeDouble(Double.parseDouble(s.toString()));
                }
                break;
            }
        }
        in.close();
        out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Kind {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

