/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.wga.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.law.util.CRC64;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.StringMap;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;

public class NumberDistinctLines {
    private static final Logger LOGGER = Logger.getLogger(NumberDistinctLines.class);
    private static final int BUFFER_SIZE = 0x100000;

    private NumberDistinctLines() {
    }

    public static void main(String[] arg) throws IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(NumberDistinctLines.class.getName(), "Numeber distinct lines.", new Parameter[]{new FlaggedOption("restrictFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "restrict", "The SignedMinimalPerfectHash of the only strings to be considered."), new UnflaggedOption("stringsFile", (StringParser)JSAP.STRING_PARSER, true, "The intput file of UTF-8 strings to number."), new UnflaggedOption("intsFile", (StringParser)JSAP.STRING_PARSER, true, "The output file of ints numbering distinct lines.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Long2IntOpenHashMap crc2int = new Long2IntOpenHashMap();
        crc2int.defaultReturnValue(-1);
        String inFileName = jsapResult.getString("stringsFile");
        String outFileName = jsapResult.getString("intsFile");
        FastBufferedReader in = new FastBufferedReader((Reader)new InputStreamReader(inFileName.equals("-") ? System.in : new FileInputStream(inFileName), "UTF-8"), 0x100000);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outFileName.equals("-") ? System.out : new FileOutputStream(outFileName), 0x100000));
        StringMap restrict = jsapResult.contains("restrictFile") ? (StringMap)BinIO.loadObject((CharSequence)jsapResult.getString("restrictFile")) : null;
        ProgressLogger pm = new ProgressLogger(LOGGER, 10000L, "lines");
        pm.start((CharSequence)"Converting...");
        MutableString s = new MutableString();
        int numStrings = 0;
        while (in.readLine(s) != null) {
            if (restrict != null && restrict.getLong((Object)s) == -1L) {
                out.writeInt(-1);
            } else {
                long crc = CRC64.compute(s);
                int i = crc2int.get(crc);
                if (i == -1) {
                    i = numStrings++;
                    crc2int.put(crc, i);
                }
                out.writeInt(i);
            }
            pm.update();
        }
        in.close();
        out.close();
        pm.stop((CharSequence)("Done. Number of different strings " + numStrings + " (map size " + crc2int.size() + ")."));
    }
}

