/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.wga.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.law.wga.tool.Text2DataOutput;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.EnumMap;

public class DataInput2Text {
    static final int IO_BUFFER_SIZE = 65536;
    private static final EnumMap<Kind, Integer> kind2size = new EnumMap(new Object2ObjectOpenHashMap((Object[])new Kind[]{Kind.BYTE, Kind.SHORT, Kind.INT, Kind.LONG, Kind.FLOAT, Kind.DOUBLE}, (Object[])new Integer[]{1, 2, 4, 8, 4, 8}));

    private DataInput2Text() {
    }

    private static void skipItems(DataInput in, int numberOfItems, int sizeOfItem) throws IOException {
        if (numberOfItems == 0) {
            return;
        }
        int toBeSkipped = sizeOfItem * numberOfItems;
        int skipped = ((RandomAccessFile)in).skipBytes(toBeSkipped);
        if (skipped < toBeSkipped) {
            throw new EOFException();
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        Closeable in;
        SimpleJSAP jsap = new SimpleJSAP(Text2DataOutput.class.getName(), "Converts a binary (DataOutput) file containing numbers to text format.", new Parameter[]{new UnflaggedOption("binaryFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The input binary file."), new UnflaggedOption("textFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The output text file."), new FlaggedOption("kind", (StringParser)JSAP.STRING_PARSER, "int", false, 'k', "kind", "The data kind: byte, int, short, long, double, float (default: int)."), new FlaggedOption("from", (StringParser)JSAP.INTEGER_PARSER, "0", false, 'f', "from", "Start from the given item (inclusive), 0-based (default: 0)."), new FlaggedOption("number", (StringParser)JSAP.INTEGER_PARSER, "0", false, 'n', "number", "Output at most n items, 0 meaning unlimited (dafault: unlimited, or 1 if -f is specified)."), new FlaggedOption("step", (StringParser)JSAP.INTEGER_PARSER, "1", false, 's', "step", "Only output one out of step elements (default: 1).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Kind kind = Kind.INT;
        int fromItem = 0;
        int howManyItems = Integer.MAX_VALUE;
        int step = 1;
        boolean fromHasBeenSpecified = false;
        boolean skipHasBeenSpecified = false;
        String kindString = jsapResult.getString("kind");
        if (kindString.equalsIgnoreCase("byte")) {
            kind = Kind.BYTE;
        } else if (kindString.equalsIgnoreCase("short")) {
            kind = Kind.SHORT;
        } else if (kindString.equalsIgnoreCase("int")) {
            kind = Kind.INT;
        } else if (kindString.equalsIgnoreCase("long")) {
            kind = Kind.LONG;
        } else if (kindString.equalsIgnoreCase("float")) {
            kind = Kind.FLOAT;
        } else if (kindString.equalsIgnoreCase("double")) {
            kind = Kind.DOUBLE;
        } else {
            System.err.println("Kind is " + kindString + ", instead it must be one of: byte, int, short, long, float, double.");
            System.exit(1);
        }
        int sizeOfItem = kind2size.get((Object)kind);
        if (jsapResult.userSpecified("from")) {
            fromItem = jsapResult.getInt("from");
            howManyItems = 1;
            fromHasBeenSpecified = true;
        }
        if ((howManyItems = jsapResult.getInt("number")) == 0) {
            howManyItems = Integer.MAX_VALUE;
        }
        if (jsapResult.userSpecified("step")) {
            step = jsapResult.getInt("step");
            skipHasBeenSpecified = true;
        }
        String inFileName = jsapResult.getString("binaryFile");
        String outFileName = jsapResult.getString("textFile");
        if (fromHasBeenSpecified || skipHasBeenSpecified) {
            if (inFileName.equals("-")) {
                throw new IllegalArgumentException("Cannot position on standard input");
            }
            in = new RandomAccessFile(inFileName, "r");
            ((RandomAccessFile)in).seek(sizeOfItem * fromItem);
        } else {
            in = new DataInputStream(new BufferedInputStream(inFileName.equals("-") ? System.in : new FileInputStream(inFileName), 65536));
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outFileName.equals("-") ? System.out : new FileOutputStream(outFileName), "UTF-8"), 65536));
        switch (kind) {
            case BYTE: {
                try {
                    while (howManyItems-- > 0) {
                        out.println(in.readByte());
                        if (step <= 0) continue;
                        DataInput2Text.skipItems((DataInput)((Object)in), step - 1, sizeOfItem);
                    }
                    break;
                }
                catch (EOFException e) {
                    break;
                }
            }
            case SHORT: {
                try {
                    while (howManyItems-- > 0) {
                        out.println(in.readShort());
                        if (step <= 0) continue;
                        DataInput2Text.skipItems((DataInput)((Object)in), step - 1, sizeOfItem);
                    }
                    break;
                }
                catch (EOFException e) {
                    break;
                }
            }
            case INT: {
                try {
                    while (howManyItems-- > 0) {
                        out.println(in.readInt());
                        if (step <= 0) continue;
                        DataInput2Text.skipItems((DataInput)((Object)in), step - 1, sizeOfItem);
                    }
                    break;
                }
                catch (EOFException e) {
                    break;
                }
            }
            case LONG: {
                try {
                    while (howManyItems-- > 0) {
                        out.println(in.readLong());
                        if (step <= 0) continue;
                        DataInput2Text.skipItems((DataInput)((Object)in), step - 1, sizeOfItem);
                    }
                    break;
                }
                catch (EOFException e) {
                    break;
                }
            }
            case FLOAT: {
                try {
                    while (howManyItems-- > 0) {
                        out.println(in.readFloat());
                        if (step <= 0) continue;
                        DataInput2Text.skipItems((DataInput)((Object)in), step - 1, sizeOfItem);
                    }
                    break;
                }
                catch (EOFException e) {
                    break;
                }
            }
            case DOUBLE: {
                try {
                    while (howManyItems-- > 0) {
                        out.println(in.readDouble());
                        if (step <= 0) continue;
                        DataInput2Text.skipItems((DataInput)((Object)in), step - 1, sizeOfItem);
                    }
                    break;
                }
                catch (EOFException e) {
                    // empty catch block
                }
            }
        }
        out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Kind {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

