/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.util;

import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.law.warc.io.BoundedCountingInputStream;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.AbstractHttpResponse;
import it.unimi.dsi.law.warc.util.HttpResponse;
import it.unimi.dsi.law.warc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarcHttpResponse
extends AbstractHttpResponse {
    private MeasurableInputStream is = null;
    private MeasurableInputStream block = null;
    private boolean headersHaveBeenParsed = false;

    @Override
    public Map<String, String> headers() {
        try {
            this.ensureHeadersHabeBeenParsed();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.headerMap;
    }

    @Override
    public MeasurableInputStream contentAsStream() throws IOException {
        this.ensureHeadersHabeBeenParsed();
        return this.is;
    }

    @Override
    public boolean fromWarcRecord(WarcRecord wr) throws IOException {
        if (!AbstractHttpResponse.FILTER.accept(wr)) {
            return false;
        }
        this.url(wr.header.subjectUri);
        this.statusLine = HttpParser.readLine((InputStream)wr.block, (String)HttpResponse.HEADER_CHARSET.name());
        this.status = new StatusLine(this.statusLine).getStatusCode();
        this.block = wr.block;
        this.headersHaveBeenParsed = false;
        return true;
    }

    private void ensureHeadersHabeBeenParsed() throws IOException {
        if (this.block == null) {
            throw new NullPointerException("Block not yet read");
        }
        if (this.headersHaveBeenParsed) {
            return;
        }
        this.headerMap.clear();
        Util.readANVLHeaders((InputStream)this.block, this.headerMap, HEADER_CHARSET);
        this.headersHaveBeenParsed = true;
        this.is = new BoundedCountingInputStream((InputStream)this.block, this.block.length() - this.block.position());
    }
}

