/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.lang.MutableString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final boolean ASSERTS = true;
    public static final Hash.Strategy<String> CASE_INSENSITIVE_STRING_HASH_STRATEGY = new Hash.Strategy<String>(){

        public int hashCode(String key) {
            int h = -558906932;
            int i = key.length();
            while (i-- != 0) {
                h ^= (h << 5) + Character.toLowerCase(key.charAt(i)) + (h >>> 2);
            }
            return h;
        }

        public boolean equals(String key0, String key1) {
            return key0.equalsIgnoreCase(key1);
        }
    };
    private static final Random RND = new Random(0L);
    private static final char[] HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char FILE_SEPARATOR = File.separatorChar;
    private static final int MAX_ATTEMPTS_CREATE_HIERARCHICAL_TEMP_FILE = 256;
    private static final char[] RESERVED = new char[]{'[', ']', '\"', '|', '{', '}', '^', '<', '>', '`'};
    private static final String[] RESERVED_SUBST = new String[RESERVED.length];

    private Util() {
    }

    public static byte[] getASCIIBytes(String s) {
        return Util.getASCIIBytes(new MutableString(s));
    }

    public static byte[] getASCIIBytes(MutableString s) {
        byte[] result = new byte[s.length()];
        char[] a = s.array();
        int i = result.length;
        while (i-- != 0) {
            assert (a[i] < '\u0080') : "Character at position  " + i + " is " + a[i] + " in \"" + s + "\"";
        }
        i = result.length;
        while (i-- != 0) {
            result[i] = (byte)(a[i] & 0x7F);
        }
        return result;
    }

    public static byte[] getBytes(char[] a, int offset, int length, CharsetEncoder encoder) throws CharacterCodingException {
        ByteBuffer bb = encoder.encode(CharBuffer.wrap(a, 0, a.length));
        byte[] result = new byte[bb.limit()];
        System.arraycopy(bb.array(), 0, result, 0, result.length);
        CharsetDecoder decoder = encoder.charset().newDecoder();
        CharBuffer cb = decoder.decode(ByteBuffer.wrap(result));
        char[] cba = new char[cb.limit()];
        System.arraycopy(cb.array(), 0, cba, 0, a.length);
        assert (Arrays.equals(a, cba));
        return result;
    }

    public static byte[] getBytes(char[] a, int offset, int length, Charset encoding) throws CharacterCodingException {
        return Util.getBytes(a, offset, length, encoding.newEncoder());
    }

    public static String getString(byte[] array) {
        return Util.getString(array, 0, array.length);
    }

    public static String getString(byte[] array, int offset, int length) {
        int j = length;
        while (j-- != 0) {
            assert (array[offset + j] >= 0) : "Byte at position  " + (offset + j) + " is " + array[offset + j];
        }
        int i = length;
        char[] charArray = new char[i];
        while (i-- != 0) {
            charArray[i] = (char)(array[offset + i] & 0x7F);
        }
        return new String(charArray);
    }

    public static int log10(int x) {
        return x < 100000 ? (x < 100 ? (x < 10 ? (x < 1 ? -1 : 0) : 1) : (x < 10000 ? (x < 1000 ? 2 : 3) : 4)) : (x < 100000000 ? (x < 10000000 ? (x < 1000000 ? 5 : 6) : 7) : (x < 1000000000 ? 8 : 9));
    }

    public static int log10(long x) {
        return x < 1000000000L ? (x < 10000L ? (x < 100L ? (x < 10L ? (x < 1L ? -1 : 0) : 1) : (x < 1000L ? 2 : 3)) : (x < 10000000L ? (x < 1000000L ? (x < 100000L ? 4 : 5) : 6) : (x < 100000000L ? 7 : 8))) : (x < 100000000000000L ? (x < 1000000000000L ? (x < 100000000000L ? (x < 10000000000L ? 9 : 10) : 11) : (x < 10000000000000L ? 12 : 13)) : (x < 100000000000000000L ? (x < 10000000000000000L ? (x < 1000000000000000L ? 14 : 15) : 16) : (x < 1000000000000000000L ? 17 : 18)));
    }

    public static int digits(int x) {
        assert (x >= 0) : x;
        if (x == 0) {
            return 1;
        }
        if (x > 0x40000000) {
            return 10;
        }
        return Util.log10(x) + 1;
    }

    public static int digits(long x) {
        assert (x >= 0L) : x;
        if (x == 0L) {
            return 1;
        }
        if (x > 0x4000000000000000L) {
            return 19;
        }
        return Util.log10(x) + 1;
    }

    public static String[] parseCommaSeparatedProperty(String s) throws IOException {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String item = st.nextToken().trim();
            if (item.length() > 1 && item.charAt(0) == '@') {
                String urlOrFilename = item.substring(1);
                URL url = new URL(urlOrFilename);
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "ISO-8859-1"));
                while ((item = br.readLine()) != null) {
                    if (item.startsWith("#")) continue;
                    result.add(item.trim());
                }
                br.close();
                continue;
            }
            result.add(item);
        }
        return result.toArray(new String[0]);
    }

    public static void consume(InputStream in, long howMany) throws IOException {
        long r;
        byte[] b = new byte[1024];
        while (howMany > 0L && (r = (long)in.read(b, 0, (int)Math.min(howMany, 1024L))) != -1L) {
            howMany -= r;
        }
    }

    public static void consume(InputStream in) throws IOException {
        Util.consume(in, Long.MAX_VALUE);
    }

    public static void readANVLHeaders(InputStream in, Map<String, String> map, Charset charset) throws HttpException, IOException {
        for (Header header : HttpParser.parseHeaders((InputStream)in, (String)charset.name())) {
            map.put(header.getName(), header.getValue());
        }
    }

    public static void writeANVLHeaders(OutputStream out, Map<String, String> map, Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        OutputStreamWriter writer = new OutputStreamWriter(out, encoder);
        try {
            for (Map.Entry<String, String> e : map.entrySet()) {
                writer.write(e.getKey());
                writer.write(": ");
                writer.write(e.getValue());
                writer.write("\r\n");
            }
            ((Writer)writer).close();
        }
        catch (IOException cantHappen) {
            throw new RuntimeException(cantHappen);
        }
    }

    public static String toHexString(byte[] a) {
        MutableString result = new MutableString(a.length * 2);
        for (int i = 0; i < a.length; ++i) {
            result.append(a[i] >= 0 && a[i] < 16 ? "0" : "").append(Integer.toHexString(a[i] & 0xFF));
        }
        return result.toString();
    }

    public static byte[] fromHexString(String s) {
        byte[] b = new byte[s.length() / 2];
        int i = s.length() / 2;
        while (i-- != 0) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createHierarchicalTempFile(File directory, int pathElements) throws IOException {
        File res;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (pathElements < 1 || pathElements > 8) {
            throw new IllegalArgumentException();
        }
        char[] path = new char[3 * pathElements];
        int attempts = 256;
        do {
            File dir;
            long x;
            Random random = RND;
            synchronized (random) {
                x = RND.nextLong();
            }
            int i = 2 * pathElements;
            int j = 3 * pathElements - 1;
            while (i-- != 0) {
                path[j--] = HEXDIGIT[(int)(x & 0xFL)];
                if (i % 2 == 0) {
                    path[j--] = FILE_SEPARATOR;
                }
                x >>= 4;
            }
            if (pathElements > 1 && ((dir = new File(directory, new String(path, 0, path.length - 2))).exists() && !dir.isDirectory() || !dir.exists() && !dir.mkdirs())) {
                throw new IOException("Can't create dirs: " + dir);
            }
            res = new File(directory, new String(path));
        } while (--attempts != 0 && res.exists());
        if (res.exists()) {
            throw new IOException("Could not create temporary file " + res + " (too many attempts)");
        }
        res.createNewFile();
        return res;
    }

    public static void fixURL(MutableString url) {
        int l;
        if (url.startsWith("http:%2F%2F")) {
            url.replace("%2F", "/");
        }
        if (url.startsWith("http:%2f%2f")) {
            url.replace("%2f", "/");
        }
        int prefix = "http:/".length();
        if (url.startsWith("http:/") && url.length() > prefix && url.charAt(prefix) != '/') {
            url.insert(prefix, '/');
        }
        if (url.lastChar() == '\"' || url.lastChar() == '\'') {
            url.length(url.length() - 1);
        }
        url.replace(RESERVED, RESERVED_SUBST);
        char[] a = url.array();
        int i = l = url.length();
        while (i-- != 0) {
            if (a[i] != '%' || i < l - 2 && Util.isHexDigit(a[i + 1]) && Util.isHexDigit(a[i + 2])) continue;
            url.insert(i + 1, "25");
        }
        if (url.startsWith("http://bloody_tears")) {
            url.replace(0, "http://bloody_tears".length(), "http://bloodytears");
        }
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static int readCompletelyFromStream(InputStream in, byte[] buf, int offset, int length) throws IOException {
        int readBytes;
        int totallyRead = 0;
        while ((readBytes = in.read(buf, offset, length)) >= 0) {
            offset += readBytes;
            totallyRead += readBytes;
            if ((length -= readBytes) > 0) continue;
        }
        return totallyRead;
    }

    static {
        int i = RESERVED_SUBST.length;
        while (i-- != 0) {
            Util.RESERVED_SUBST[i] = (RESERVED[i] < '\u0010' ? "%0" : "%") + Integer.toHexString(RESERVED[i]);
        }
    }
}

