/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.bits.Utf16TransformationStrategy;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.law.warc.util.ByteArrayCharSequence;
import it.unimi.dsi.sux4j.mph.MWHCFunction;
import it.unimi.dsi.sux4j.util.ShiftAddXorSignedStringMap;
import it.unimi.dsi.util.StringMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemappedStringMap
extends AbstractObject2LongFunction<CharSequence>
implements StringMap<CharSequence>,
Serializable {
    public static final String DEFAULT_BUFFER_SIZE = "64Ki";
    private static final long serialVersionUID = 1L;
    private final StringMap<? extends CharSequence> stringMap;
    private final int[] map;

    public RemappedStringMap(StringMap<? extends CharSequence> stringMap, int[] map) {
        if (stringMap.size() != map.length) {
            throw new IllegalArgumentException("Minimal perfect hash size (" + stringMap.size() + ") is not equal to map length (" + map.length + ")");
        }
        this.stringMap = stringMap;
        this.map = map;
    }

    public long getLong(Object o) {
        CharSequence term = (CharSequence)o;
        int x = (int)this.stringMap.getLong((Object)term);
        if (x == -1) {
            return -1L;
        }
        return this.map[x];
    }

    public int size() {
        return this.stringMap.size();
    }

    public static void run(String duplicateURLs, String archetypeURLs, StringMap<? extends CharSequence> resolver, String remappedFilename, int bufferSize) throws IOException {
        FastBufferedInputStream arch = new FastBufferedInputStream((InputStream)new FileInputStream(archetypeURLs), bufferSize);
        FileLinesCollection flc = new FileLinesCollection((CharSequence)duplicateURLs, "ASCII");
        ShiftAddXorSignedStringMap duplicateMph = new ShiftAddXorSignedStringMap((Iterator)flc.iterator(), (Object2LongFunction)new MWHCFunction((Iterable)flc, (TransformationStrategy)new Utf16TransformationStrategy()));
        byte[] line = new byte[2048];
        int[] map = new int[duplicateMph.size()];
        ByteArrayCharSequence s = new ByteArrayCharSequence();
        int n = 0;
        while (true) {
            int len;
            int start = 0;
            while ((len = arch.readLine(line, start, line.length - start)) == line.length - start) {
                start += len;
                line = ByteArrays.grow((byte[])line, (int)(line.length + 1));
            }
            if ((len = start + Math.max(len, 0)) == 0) break;
            map[n] = (int)resolver.getLong((Object)s.wrap(line, 0, len));
            if (map[n] == -1) {
                throw new IllegalArgumentException("URL " + new String(line, 0, len, "ASCII") + " cannot be resolved");
            }
            ++n;
        }
        BinIO.storeObject((Object)new RemappedStringMap((StringMap<? extends CharSequence>)duplicateMph, map), (CharSequence)remappedFilename);
        arch.close();
    }

    public ObjectList<CharSequence> list() {
        return null;
    }

    public boolean containsKey(Object o) {
        return this.stringMap.containsKey(o);
    }

    public static void main(String[] arg) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP(RemappedStringMap.class.getName(), "Builds a remapped minimal perfect hash by reading two parallel files (duplicates and archetypes), and mapping each line of the first file to the number returned by a given minimal perfect hash on the corresponding line of the second file.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, DEFAULT_BUFFER_SIZE, false, 'b', "buffer-size", "The size of an I/O buffer."), new UnflaggedOption("duplicateURLs", (StringParser)JSAP.STRING_PARSER, true, "The duplicate file."), new UnflaggedOption("archetypeURLs", (StringParser)JSAP.STRING_PARSER, true, "The archetype file."), new UnflaggedOption("resolver", (StringParser)JSAP.STRING_PARSER, true, "The term map used to resolve the second field."), new UnflaggedOption("remappedMph", (StringParser)JSAP.STRING_PARSER, true, "The resulting remapped minimal perfect hash.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        RemappedStringMap.run(jsapResult.getString("duplicateURLs"), jsapResult.getString("archetypeURLs"), (StringMap<? extends CharSequence>)((StringMap)BinIO.loadObject((CharSequence)jsapResult.getString("resolver"))), jsapResult.getString("remappedMph"), jsapResult.getInt("bufferSize"));
    }
}

