/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.util;

import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.law.warc.util.Util;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class BURL
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(BURL.class);
    private static final boolean ASSERTS = true;
    private static final boolean DEBUG = false;
    public static final char[] FORBIDDEN_CHARS = new char[]{'\n', '\r'};
    public static final char[] BAD_CHAR = new char[]{'\\', ' ', '\t', '[', ']', '\"', '|', '{', '}', '^', '<', '>', '`'};
    public static final String[] BAD_CHAR_SUBSTITUTE = new String[BAD_CHAR.length];
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final String asciiStringRepresentation;
    private String pathAndQuery;
    private transient byte[] byteRepresentation;

    protected BURL(URI uri) {
        this.uri = uri;
        this.asciiStringRepresentation = uri.toASCIIString();
    }

    public static BURL parse(String spec) {
        return BURL.parse(new MutableString(spec));
    }

    public static BURL parse(MutableString spec) {
        int l;
        spec.trim();
        if (spec.indexOfAnyOf(FORBIDDEN_CHARS) != -1) {
            return null;
        }
        spec.replace(BAD_CHAR, BAD_CHAR_SUBSTITUTE);
        char[] a = spec.array();
        int i = l = spec.length();
        while (i-- != 0) {
            if (a[i] != '%' || i < l - 2 && BURL.isHexDigit(a[i + 1]) && BURL.isHexDigit(a[i + 2])) continue;
            spec.insert(i + 1, "25");
        }
        try {
            String scheme;
            URI parseURI = new URI(spec.toString()).normalize();
            if (parseURI.isOpaque()) {
                return null;
            }
            if (parseURI.isAbsolute()) {
                parseURI.parseServerAuthority();
            }
            if ((scheme = parseURI.getScheme()) != null) {
                if (scheme.indexOf(0) != -1) {
                    return null;
                }
                scheme = scheme.toLowerCase();
            }
            if (parseURI.isAbsolute() && parseURI.getAuthority() == null) {
                return null;
            }
            String host = parseURI.getHost();
            if (host != null) {
                if (host.indexOf(0) != -1) {
                    return null;
                }
                if (host.endsWith(".")) {
                    host = host.substring(0, host.length() - 1);
                }
                host = host.toLowerCase();
            }
            String path = parseURI.getPath();
            if (host != null && (path == null || path.length() == 0)) {
                path = "/";
            }
            if (path != null && path.indexOf(0) != -1) {
                return null;
            }
            if (parseURI.getUserInfo() != null && parseURI.getUserInfo().indexOf(0) != -1) {
                return null;
            }
            if (parseURI.getQuery() != null && parseURI.getQuery().indexOf(0) != -1) {
                return null;
            }
            return new BURL(new URI(new URI(scheme, parseURI.getUserInfo(), host, parseURI.getPort(), path, parseURI.getQuery(), null).normalize().toASCIIString()));
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Unexpected exception while parsing " + spec), (Throwable)e);
            return null;
        }
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public BURL resolve(BURL relative) {
        if (relative.isAbsolute()) {
            return relative;
        }
        return new BURL(this.uri.resolve(relative.uri));
    }

    public byte[] toByteArray() {
        if (this.byteRepresentation == null) {
            this.byteRepresentation = Util.getASCIIBytes(this.asciiStringRepresentation);
        }
        return this.byteRepresentation;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public String authority() {
        return this.uri.getRawAuthority();
    }

    public String host() {
        return this.uri.getHost();
    }

    public String path() {
        assert (!this.uri.isAbsolute() || this.uri.getRawPath() != null) : this.uri;
        assert (!this.uri.isAbsolute() || this.uri.getRawPath().length() != 0) : this.uri;
        return this.uri.getRawPath();
    }

    public String pathAndQuery() {
        if (this.pathAndQuery == null) {
            String query = this.uri.getRawQuery();
            this.pathAndQuery = query == null ? this.uri.getRawPath() : this.uri.getRawPath() + "?" + this.uri.getRawQuery();
        }
        return this.pathAndQuery;
    }

    public int port() {
        return this.uri.getPort();
    }

    public String scheme() {
        return this.uri.getScheme();
    }

    public String query() {
        return this.uri.getRawQuery();
    }

    public String userInfo() {
        return this.uri.getRawUserInfo();
    }

    public int hashCode() {
        return this.asciiStringRepresentation.hashCode();
    }

    public String toString() {
        return this.asciiStringRepresentation;
    }

    public static String hostFromAuthority(String authority) {
        int colonPosition;
        int atPosition = authority.indexOf(64);
        if (atPosition != -1) {
            authority = authority.substring(atPosition + 1);
        }
        return (colonPosition = authority.indexOf(58)) == -1 ? authority : authority.substring(0, colonPosition);
    }

    public boolean equals(Object obj) {
        return obj instanceof BURL && ((BURL)obj).asciiStringRepresentation.equals(this.asciiStringRepresentation);
    }

    static {
        BURL.BAD_CHAR_SUBSTITUTE[0] = "/";
        int i = BAD_CHAR.length;
        while (i-- != 1) {
            BURL.BAD_CHAR_SUBSTITUTE[i] = (BAD_CHAR[i] < '\u0010' ? "%0" : "%") + Integer.toHexString(BAD_CHAR[i]);
        }
    }
}

