/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.util;

import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.filters.IsHttpResponse;
import it.unimi.dsi.law.warc.io.MeasurableSequenceInputStream;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.BURL;
import it.unimi.dsi.law.warc.util.HttpResponse;
import it.unimi.dsi.law.warc.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpResponse
implements HttpResponse {
    protected BURL url;
    protected int status;
    protected String statusLine;
    protected final Map<String, String> headerMap = new Object2ObjectOpenCustomHashMap(Util.CASE_INSENSITIVE_STRING_HASH_STRATEGY);
    protected static final Filter<WarcRecord> FILTER = IsHttpResponse.INSTANCE;

    @Override
    public BURL url() {
        return this.url;
    }

    @Override
    public void url(BURL url) {
        this.url = url;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public void status(int status) {
        this.status = status;
    }

    @Override
    public String statusLine() {
        return this.statusLine;
    }

    @Override
    public void statusLine(String statusLine) {
        this.statusLine = statusLine;
    }

    @Override
    public Map<String, String> headers() {
        return this.headerMap;
    }

    @Override
    public void toWarcRecordHeadersOnly(WarcRecord wr) throws UnsupportedEncodingException, IOException {
        WarcRecord.Header header = wr.header;
        header.recordType = WarcRecord.RecordType.RESPONSE;
        header.subjectUri = this.url;
        header.creationDate = new Date();
        String scheme = header.subjectUri.scheme();
        if (scheme == null) {
            throw new IllegalArgumentException("No scheme avaialbe for " + header.subjectUri);
        }
        if (scheme.equals("https")) {
            header.contentType = WarcRecord.ContentType.HTTPS;
        } else if (scheme.equals("http")) {
            header.contentType = WarcRecord.ContentType.HTTP;
        } else {
            throw new IllegalArgumentException("Only http/https schemes allowed, instead scheme is " + scheme);
        }
        header.recordId = UUID.randomUUID();
        header.anvlFields.clear();
        FastByteArrayOutputStream buf = new FastByteArrayOutputStream();
        buf.write(this.statusLine.getBytes(HEADER_CHARSET.name()));
        buf.write(WarcRecord.CRLF);
        Util.writeANVLHeaders((OutputStream)buf, this.headerMap, HEADER_CHARSET);
        buf.write(WarcRecord.CRLF);
        buf.flush();
        wr.block = new FastByteArrayInputStream(buf.array, 0, buf.length);
    }

    @Override
    public void toWarcRecord(WarcRecord wr) throws UnsupportedEncodingException, IOException {
        this.toWarcRecordHeadersOnly(wr);
        wr.block = new MeasurableSequenceInputStream(wr.block, this.contentAsStream());
    }
}

