/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.law.warc.io.GZWarcRecord;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.Util;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class ListGZWarcComments {
    private static final Logger LOGGER = Logger.getLogger(ListGZWarcComments.class);
    public static final String DEFAULT_BUFFER_SIZE = "64Ki";

    public static void run(FastBufferedInputStream in, PrintWriter pw) throws IOException, WarcRecord.FormatException {
        GZWarcRecord record = new GZWarcRecord();
        ProgressLogger pl = new ProgressLogger(LOGGER, 60000L, "records");
        pl.start((CharSequence)"Listing...");
        while (record.skip(in) != -1L) {
            pw.println(Util.getString(record.gzheader.comment));
            pl.update();
        }
        pl.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP(ListGZWarcComments.class.getName(), "Lists the gzip comments of a compressed warc file.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, DEFAULT_BUFFER_SIZE, false, 'b', "buffer-size", "The size of an I/O buffer."), new UnflaggedOption("warcFile", (StringParser)JSAP.STRING_PARSER, null, true, false, "The Warc input file basename (if not present, or -, stdin will be used).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String warcFile = jsapResult.getString("warcFile");
        int bufferSize = jsapResult.getInt("bufferSize");
        FastBufferedInputStream in = new FastBufferedInputStream(warcFile.equals("-") ? System.in : new FileInputStream(new File(warcFile + ".warc.gz")), bufferSize);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream((OutputStream)System.out, bufferSize), "ASCII"));
        try {
            ListGZWarcComments.run(in, pw);
        }
        finally {
            pw.close();
            in.close();
        }
    }
}

