/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.tool;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.law.warc.io.GZWarcRecord;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class IndexWarc {
    private static final Logger LOGGER = Logger.getLogger(IndexWarc.class);
    static final int IO_BUFFER_SIZE = 65536;

    public static void run(FastBufferedInputStream in, boolean isGZipped, OutputStream out) throws IOException, WarcRecord.FormatException {
        WarcRecord inRecord = isGZipped ? new GZWarcRecord() : new WarcRecord();
        ProgressLogger pl = new ProgressLogger(LOGGER, "records");
        DataOutputStream dout = new DataOutputStream(out);
        pl.logInterval = 10000L;
        pl.start((CharSequence)"Indexing...");
        dout.writeLong(0L);
        while (inRecord.skip(in) != -1L) {
            dout.writeLong(in.position());
            pl.update();
        }
        pl.done();
    }

    public static void main(String[] arg) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP(IndexWarc.class.getName(), "Index a warc file.", new Parameter[]{new Switch("gzip", 'z', "gzip", "Tells if the warc is compressed."), new UnflaggedOption("warcFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The Warc file basename (if not present, or -, stdin/stdout will be used).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String warcFile = jsapResult.getString("warcFile");
        boolean isGZipped = jsapResult.getBoolean("gzip");
        FastBufferedInputStream in = new FastBufferedInputStream(warcFile.equals("-") ? System.in : new FileInputStream(new File(warcFile + ".warc" + (isGZipped ? ".gz" : ""))), 65536);
        FastBufferedOutputStream out = new FastBufferedOutputStream(warcFile.equals("-") ? System.out : new FileOutputStream(new File(warcFile + ".warc" + (isGZipped ? ".gz" : "") + ".idx")), 65536);
        IndexWarc.run(in, isGZipped, (OutputStream)out);
        in.close();
        out.close();
    }
}

