/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.tool;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.filters.Filters;
import it.unimi.dsi.law.warc.filters.parser.FilterParser;
import it.unimi.dsi.law.warc.io.GZWarcRecord;
import it.unimi.dsi.law.warc.io.WarcFilteredIterator;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrepWarc {
    private static final Logger LOGGER = Logger.getLogger(GrepWarc.class);
    static final int IO_BUFFER_SIZE = 65536;

    public static void run(FastBufferedInputStream in, boolean isGZipped, Filter<WarcRecord> filter, OutputStream out) throws IOException {
        WarcRecord inRecord = isGZipped ? new GZWarcRecord() : new WarcRecord();
        WarcRecord outRecord = new WarcRecord();
        ProgressLogger pl = new ProgressLogger(LOGGER, "records");
        WarcFilteredIterator it = new WarcFilteredIterator(in, inRecord, filter, pl);
        pl.logInterval = 10000L;
        pl.start((CharSequence)"Grepping...");
        while (it.hasNext()) {
            it.next();
            outRecord.fromWarcRecord(inRecord);
            outRecord.write(out);
        }
        pl.done();
    }

    public static void main(String[] arg) throws Exception {
        ObjectRBTreeSet filterNames = new ObjectRBTreeSet();
        for (Class<Filter<?>> clazz : Filters.standardFilters()) {
            filterNames.add(clazz.getSimpleName());
        }
        SimpleJSAP jsap = new SimpleJSAP(GrepWarc.class.getName(), "Grep for warc files.", new Parameter[]{new Switch("gzip", 'z', "gzip", "Tells if the warc is compressed."), new UnflaggedOption("filter", (StringParser)JSAP.STRING_PARSER, true, "The filter. " + filterNames), new UnflaggedOption("warcFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The Warc input file basename (if not present, or -, stdin will be used).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean isGZipped = jsapResult.getBoolean("gzip");
        Filter<WarcRecord> filter = new FilterParser<WarcRecord>(WarcRecord.class).parse(jsapResult.getString("filter"));
        String warcFile = jsapResult.getString("warcFile");
        FastBufferedInputStream in = new FastBufferedInputStream(warcFile.equals("-") ? System.in : new FileInputStream(new File(warcFile + ".warc" + (isGZipped ? ".gz" : ""))), 65536);
        FastBufferedOutputStream out = new FastBufferedOutputStream((OutputStream)System.out, 65536);
        GrepWarc.run(in, isGZipped, filter, (OutputStream)out);
        in.close();
        out.close();
    }
}

