/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.tool;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import hep.aida.bin.StaticBin1D;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.law.warc.io.GZWarcRecord;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class CompressWarc {
    private static final Logger LOGGER = Logger.getLogger(CompressWarc.class);
    static final int IO_BUFFER_SIZE = 65536;

    public static void run(FastBufferedInputStream in, OutputStream out) throws IOException, WarcRecord.FormatException {
        WarcRecord inRecord = new WarcRecord();
        GZWarcRecord outRecord = new GZWarcRecord();
        final StaticBin1D compressionRatio = new StaticBin1D();
        ProgressLogger pl = new ProgressLogger(LOGGER, "records");
        pl.logInterval = 10000L;
        pl.info = new Object(){

            public String toString() {
                int size = compressionRatio.size();
                return "compression ratio: " + (size != 0 ? (int)(100.0 * compressionRatio.sum() / (double)size) + "%" : "NA");
            }
        };
        pl.start((CharSequence)"Compressing...");
        while (inRecord.read(in) != -1L) {
            outRecord.fromWarcRecord(inRecord);
            outRecord.write(out);
            compressionRatio.add((double)outRecord.gzheader.compressedSkipLength / (double)inRecord.header.dataLength);
            pl.update();
        }
        pl.done();
    }

    public static void main(String[] arg) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP(CompressWarc.class.getName(), "Compress a warc file.", new Parameter[]{new UnflaggedOption("warcFile", (StringParser)JSAP.STRING_PARSER, "-", true, false, "The Warc file basename (if not present, or -, stdin/stdout will be used).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String warcFile = jsapResult.getString("warcFile");
        FastBufferedInputStream in = new FastBufferedInputStream(warcFile.equals("-") ? System.in : new FileInputStream(new File(warcFile + ".warc")), 65536);
        FastBufferedOutputStream out = new FastBufferedOutputStream(warcFile.equals("-") ? System.out : new FileOutputStream(new File(warcFile + ".warc.gz")), 65536);
        CompressWarc.run(in, (OutputStream)out);
        in.close();
        out.close();
    }
}

