/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.parser;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.law.warc.util.BURL;
import it.unimi.dsi.law.warc.util.Util;
import it.unimi.dsi.parser.Attribute;
import it.unimi.dsi.parser.BulletParser;
import it.unimi.dsi.parser.Element;
import it.unimi.dsi.parser.callback.Callback;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digester
implements Callback {
    private static final int BYTE_BUFFER_SIZE = 8192;
    private static final char[] AUTHORITY_DELIMITER = "\u0000".toCharArray();
    private static final char[] ATTRIBUTE_VALUE_DELIMITER = "\"".toCharArray();
    private static final boolean DEBUG = false;
    private static final Object2ObjectOpenHashMap<Element, byte[]> startTag = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Element, byte[]> endTag = new Object2ObjectOpenHashMap();
    private final MessageDigest md;
    private byte[] byteBuffer = new byte[8192];
    private int fill;
    private BURL url;
    private byte[] digest;

    public Digester(String algorithm) throws NoSuchAlgorithmException {
        this.md = MessageDigest.getInstance(algorithm);
    }

    public void configure(BulletParser parser) {
        parser.parseTags(true);
        parser.parseAttributes(true);
        parser.parseText(true);
        parser.parseAttribute(Attribute.SRC);
    }

    private void update(char[] c) {
        this.update(c, 0, c.length);
    }

    private void update(char[] c, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.fill == 8192) {
                this.md.update(this.byteBuffer);
                this.fill = 0;
            }
            this.byteBuffer[this.fill++] = (byte)(c[offset + i] >> 8);
            this.byteBuffer[this.fill++] = (byte)c[offset + i];
        }
    }

    public byte[] digest() {
        return this.digest;
    }

    public void url(BURL url) {
        this.url = url;
    }

    public void startDocument() {
        this.md.reset();
        this.fill = 0;
        if (this.url != null) {
            this.update(this.url.authority().toCharArray());
            this.update(AUTHORITY_DELIMITER);
        }
    }

    public boolean startElement(Element element, Map<Attribute, MutableString> attributes) {
        MutableString urlSpec;
        this.md.update((byte[])startTag.get((Object)element));
        if ((element == Element.FRAME || element == Element.IFRAME) && (urlSpec = attributes.get(Attribute.SRC)) != null) {
            this.update(ATTRIBUTE_VALUE_DELIMITER);
            this.update(urlSpec.array(), 0, urlSpec.length());
            this.update(ATTRIBUTE_VALUE_DELIMITER);
        }
        return true;
    }

    public boolean endElement(Element element) {
        this.md.update((byte[])endTag.get((Object)element));
        return true;
    }

    public boolean characters(char[] data, int offset, int length, boolean flowBroken) {
        this.update(data, offset, length);
        return true;
    }

    public boolean cdata(Element element, char[] data, int offset, int length) {
        return true;
    }

    public void endDocument() {
        this.md.update(this.byteBuffer, 0, this.fill);
        this.fill = 0;
        this.digest = this.md.digest();
    }

    static {
        for (Field f : Element.class.getFields()) {
            Element element;
            if (f.getType() != Element.class) continue;
            try {
                element = (Element)f.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            startTag.put((Object)element, (Object)Util.getASCIIBytes("<" + element + ">"));
            endTag.put((Object)element, (Object)Util.getASCIIBytes("</" + element + ">"));
        }
        startTag.defaultReturnValue((Object)Util.getASCIIBytes("<unknown>"));
        endTag.defaultReturnValue((Object)Util.getASCIIBytes("</unknown>"));
    }
}

