/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io.examples;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.law.warc.io.GZWarcRecord;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.WarcHttpResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class SequentialHttpResponseRead {
    static final int IO_BUFFER_SIZE = 65536;
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");

    public static void main(String[] arg) throws Exception {
        String warcFile = "test";
        boolean isGZipped = true;
        GZWarcRecord record = new GZWarcRecord();
        WarcHttpResponse response = new WarcHttpResponse();
        FastBufferedInputStream in = new FastBufferedInputStream((InputStream)new FileInputStream(new File("test.warc.gz")), 65536);
        while (((WarcRecord)record).read(in) != -1L) {
            int r;
            System.out.println("GZip header:\n" + record.gzheader);
            System.out.println("WARC header:\n" + record.header);
            if (!response.fromWarcRecord(record)) continue;
            System.out.println("HTTP status line:\n" + response.statusLine());
            System.out.println("HTTP headers:\n" + response.headers());
            System.out.println("First few bytes of content:");
            Charset charset = ISO_8859_1;
            String charsetName = record.header.anvlFields.get("BUbiNG-guessed-charset");
            if (charsetName != null) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException e) {
                    System.err.println("Illegal charset, using " + ISO_8859_1);
                }
                catch (UnsupportedCharsetException e) {
                    System.err.println("Unsupported charset, using " + ISO_8859_1);
                }
            }
            InputStreamReader reader = new InputStreamReader((InputStream)response.contentAsStream(), charset);
            int n = 100;
            while ((r = ((Reader)reader).read()) != -1 && n-- > 0) {
                System.out.print((char)r);
            }
            System.out.println("\n");
        }
    }
}

