/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.law.warc.io.BoundedCountingInputStream;
import it.unimi.dsi.law.warc.util.BURL;
import it.unimi.dsi.law.warc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CRC32;

public class WarcRecord {
    public static final boolean DEBUG = false;
    public static final boolean ASSERTS = true;
    public static final boolean USE_POSITION_INSTEAD_OF_SKIP = false;
    public static final Object2ObjectMap<byte[], ContentType> BYTE_REPRESENTATION_TO_CONTENT_TYPE = new Object2ObjectOpenCustomHashMap(ByteArrays.HASH_STRATEGY);
    public static final Object2ObjectMap<byte[], RecordType> BYTE_REPRESENTATION_TO_RECORD_TYPE = new Object2ObjectOpenCustomHashMap(ByteArrays.HASH_STRATEGY);
    public static final int DEFAULT_BUFFER_SIZE = 102400;
    private static final Charset ANVL_CHARSET;
    public static final byte[] WARC_ID;
    public static final byte[] UUID_FIELD_NAME;
    public static final byte[] CRLF;
    final EnumSet<FastBufferedInputStream.LineTerminator> LINE_TERMINATOR = EnumSet.of(FastBufferedInputStream.LineTerminator.CR_LF);
    private static final SimpleDateFormat DATE_FORMAT;
    private final byte[] buffer;
    private final MinimalisticParser minimalisticParser = new MinimalisticParser();
    private long positionOfLastHeader;
    private long dataLengthInLastHeader;
    protected CRC32 crc = null;
    public final Header header = new Header();
    public MeasurableInputStream block;

    public WarcRecord(byte[] buffer) {
        this.buffer = buffer;
        this.positionOfLastHeader = -1L;
    }

    public WarcRecord() {
        this(new byte[102400]);
    }

    public void fromWarcRecord(WarcRecord record) {
        this.header.fromHeader(record.header);
        this.block = record.block;
    }

    public void resetRead() {
        this.positionOfLastHeader = -1L;
    }

    public long skip(FastBufferedInputStream bin) throws IOException, FormatException {
        if (this.readHeaderLine(bin) == -1L) {
            return -1L;
        }
        long newPosition = this.positionOfLastHeader + this.dataLengthInLastHeader;
        assert (newPosition >= bin.position());
        bin.skip(newPosition - bin.position());
        return this.dataLengthInLastHeader;
    }

    public long read(FastBufferedInputStream bin) throws IOException, FormatException {
        if (this.readHeaderLine(bin) == -1L) {
            return -1L;
        }
        this.header.dataLength = this.dataLengthInLastHeader;
        this.minimalisticParser.positionAtNextWord();
        this.header.recordType = (RecordType)((Object)BYTE_REPRESENTATION_TO_RECORD_TYPE.get((Object)this.minimalisticParser.asByteArray()));
        this.minimalisticParser.positionAtNextWord();
        this.header.subjectUri = BURL.parse(this.minimalisticParser.asAsciiSting());
        this.minimalisticParser.positionAtNextWord();
        try {
            this.header.creationDate = DATE_FORMAT.parse(this.minimalisticParser.asAsciiSting());
        }
        catch (ParseException e) {
            throw new FormatException("Error parsing creation-date: " + e.getMessage());
        }
        this.minimalisticParser.positionAtNextWord();
        this.header.contentType = (ContentType)((Object)BYTE_REPRESENTATION_TO_CONTENT_TYPE.get((Object)this.minimalisticParser.asByteArray()));
        this.minimalisticParser.positionAtNextWord();
        String recordIdAsString = this.minimalisticParser.asAsciiSting();
        if (!this.minimalisticParser.startsWith(UUID_FIELD_NAME)) {
            throw new FormatException("Unknown type of record-id." + recordIdAsString);
        }
        try {
            this.header.recordId = UUID.fromString(recordIdAsString.substring(UUID_FIELD_NAME.length + 1));
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("Error parsing record-id '" + recordIdAsString + "'; " + e.getMessage());
        }
        this.header.anvlFields.clear();
        Util.readANVLHeaders((InputStream)bin, this.header.anvlFields, ANVL_CHARSET);
        long blockLength = this.header.dataLength - (bin.position() - this.positionOfLastHeader) - 4L;
        assert (blockLength >= 0L);
        this.block = new BoundedCountingInputStream((InputStream)bin, blockLength);
        return this.dataLengthInLastHeader;
    }

    public void write(OutputStream out) throws IOException {
        int read;
        FastByteArrayOutputStream hbuf = new FastByteArrayOutputStream(this.buffer);
        this.header.dataLength = this.prebufferHeader(hbuf);
        byte[] dataLengthAsBytes = Util.getASCIIBytes(Long.toString(this.header.dataLength));
        out.write(WARC_ID);
        out.write(32);
        out.write(dataLengthAsBytes);
        out.write(32);
        out.write(hbuf.array, 0, hbuf.length);
        if (this.crc != null) {
            this.crc.update(WARC_ID);
            this.crc.update(32);
            this.crc.update(dataLengthAsBytes);
            this.crc.update(32);
            this.crc.update(hbuf.array, 0, hbuf.length);
        }
        hbuf = null;
        long remaining = this.block.length();
        while ((read = this.block.read(this.buffer, 0, (int)Math.min(remaining, (long)this.buffer.length))) != -1) {
            out.write(this.buffer, 0, read);
            if (this.crc != null) {
                this.crc.update(this.buffer, 0, read);
            }
            if ((remaining -= (long)read) > 0L) continue;
        }
        out.write(CRLF);
        out.write(CRLF);
        if (this.crc != null) {
            this.crc.update(CRLF);
            this.crc.update(CRLF);
        }
    }

    public String toString() {
        return this.header.toString();
    }

    private long prebufferHeader(FastByteArrayOutputStream hbuf) throws IOException {
        hbuf.write(this.header.recordType.byteRepresentation);
        hbuf.write(32);
        hbuf.write(this.header.subjectUri.toByteArray());
        hbuf.write(32);
        hbuf.write(Util.getASCIIBytes(DATE_FORMAT.format(this.header.creationDate)));
        hbuf.write(32);
        hbuf.write(this.header.contentType.byteRepresentation);
        hbuf.write(32);
        hbuf.write(UUID_FIELD_NAME);
        hbuf.write(58);
        hbuf.write(Util.getASCIIBytes(this.header.recordId.toString()));
        hbuf.write(CRLF);
        Util.writeANVLHeaders((OutputStream)hbuf, this.header.anvlFields, ANVL_CHARSET);
        hbuf.write(CRLF);
        long dataLength = (int)((long)(WARC_ID.length + hbuf.length) + this.block.length() + 6L);
        int digits = Util.digits(dataLength);
        return dataLength += Util.digits(dataLength + (long)digits) == digits ? (long)digits : (long)(digits + 1);
    }

    private long readHeaderLine(FastBufferedInputStream bin) throws IOException, FormatException {
        if (this.positionOfLastHeader != -1L) {
            long newPosition = this.positionOfLastHeader + this.dataLengthInLastHeader;
            assert (newPosition >= bin.position());
            bin.skip(newPosition - bin.position());
        }
        int length = -1;
        do {
            this.positionOfLastHeader = bin.position();
            length = bin.readLine(this.buffer, this.LINE_TERMINATOR);
            if (length != -1) continue;
            return -1L;
        } while (length == 0);
        this.minimalisticParser.setInput(this.buffer, 0, length);
        this.minimalisticParser.positionAtNextWord();
        if (!this.minimalisticParser.startsWith(WARC_ID)) {
            throw new FormatException("Missing or incorrect warc-id.");
        }
        this.minimalisticParser.positionAtNextWord();
        this.dataLengthInLastHeader = this.minimalisticParser.asInt();
        return this.dataLengthInLastHeader;
    }

    static {
        for (ContentType contentType : ContentType.values()) {
            BYTE_REPRESENTATION_TO_CONTENT_TYPE.put((Object)contentType.byteRepresentation, (Object)contentType);
        }
        for (Enum enum_ : RecordType.values()) {
            BYTE_REPRESENTATION_TO_RECORD_TYPE.put((Object)((RecordType)enum_).byteRepresentation, (Object)enum_);
        }
        ANVL_CHARSET = Charset.forName("UTF-8");
        WARC_ID = Util.getASCIIBytes("warc/0.9");
        UUID_FIELD_NAME = Util.getASCIIBytes("uuid");
        CRLF = new byte[]{13, 10};
        DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    }

    private static class MinimalisticParser {
        private static final boolean DEBUG = false;
        private int start;
        private int end;
        private int length;
        private byte[] buf;

        private MinimalisticParser() {
        }

        public void setInput(byte[] buf) {
            this.setInput(buf, 0, buf.length);
        }

        public void setInput(byte[] buf, int offset, int length) {
            this.buf = buf;
            this.end = this.start = offset;
            this.length = length;
        }

        public void positionAtNextWord() {
            this.start = this.end;
            while (this.start < this.length && Character.isWhitespace(this.buf[this.start])) {
                ++this.start;
            }
            this.end = this.start;
            while (this.end < this.length && !Character.isWhitespace(this.buf[this.end])) {
                ++this.end;
            }
        }

        public boolean startsWith(byte[] m) {
            int i;
            int ml = m.length;
            for (i = 0; i < ml && this.start + i < this.length && this.buf[this.start + i] == m[i]; ++i) {
            }
            return i == ml;
        }

        public int asInt() {
            int val = 0;
            for (int i = this.start; i < this.end; ++i) {
                val = val * 10 + (this.buf[i] - 48);
            }
            return val;
        }

        public String asAsciiSting() {
            String ret = Util.getString(this.buf, this.start, this.end - this.start);
            return ret;
        }

        public byte[] asByteArray() {
            byte[] b = new byte[this.end - this.start];
            System.arraycopy(this.buf, this.start, b, 0, this.end - this.start);
            return b;
        }
    }

    public class FormatException
    extends Exception {
        private static final long serialVersionUID = -1L;

        public FormatException(String s) {
            super(s);
        }
    }

    public static class Header {
        public long dataLength;
        public RecordType recordType;
        public BURL subjectUri;
        public Date creationDate;
        public ContentType contentType;
        public UUID recordId;
        public final Map<String, String> anvlFields = new Object2ObjectOpenCustomHashMap(Util.CASE_INSENSITIVE_STRING_HASH_STRATEGY);

        public void fromHeader(Header header) {
            this.dataLength = header.dataLength;
            this.recordType = header.recordType;
            this.subjectUri = header.subjectUri;
            this.creationDate = header.creationDate;
            this.contentType = header.contentType;
            this.recordId = header.recordId;
            this.anvlFields.clear();
            this.anvlFields.putAll(header.anvlFields);
        }

        public int hashCode() {
            return this.recordId.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Header)) {
                return false;
            }
            Header h = (Header)o;
            if (this.dataLength != h.dataLength) {
                return false;
            }
            if (this.recordType != h.recordType) {
                return false;
            }
            if (!this.subjectUri.equals(h.subjectUri)) {
                return false;
            }
            if (this.creationDate.getTime() / 1000L != h.creationDate.getTime() / 1000L) {
                return false;
            }
            if (this.contentType != h.contentType) {
                return false;
            }
            if (!this.recordId.toString().equals(h.recordId.toString())) {
                return false;
            }
            return ((Object)this.anvlFields).equals(h.anvlFields);
        }

        public String toString() {
            MutableString s = new MutableString();
            s.append("dataLength: ");
            s.append(this.dataLength);
            s.append(", recordType: ");
            s.append((Object)this.recordType);
            s.append(", subjectUri: ");
            s.append((Object)this.subjectUri);
            s.append(", creationDate: ");
            s.append((Object)this.creationDate);
            s.append(", contentType: ");
            s.append((Object)this.contentType);
            s.append(", recordId: ");
            s.append((Object)this.recordId);
            s.append(", anvlFields: ");
            s.append(this.anvlFields);
            return s.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordType {
        WARCINFO("warcinfo"),
        RESPONSE("response"),
        RESOURCE("resource"),
        REQUEST("request"),
        METADATA("metadata"),
        REVISIT("revisit"),
        CONVERSION("conversion"),
        CONTINUATION("continuation");

        public final byte[] byteRepresentation;

        private RecordType(String name) {
            this.byteRepresentation = Util.getASCIIBytes(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        HTTP("message/http"),
        HTTPS("message/https");

        public final byte[] byteRepresentation;

        private ContentType(String name) {
            this.byteRepresentation = Util.getASCIIBytes(name);
        }
    }
}

