/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarcFilteredIterator
implements Iterator<WarcRecord> {
    private final FastBufferedInputStream in;
    private final WarcRecord record;
    private final Filter<WarcRecord> filter;
    private final ProgressLogger pl;
    private boolean eofIsReached;
    private boolean cached;

    public WarcFilteredIterator(FastBufferedInputStream in, WarcRecord record, Filter<WarcRecord> filter, ProgressLogger pl) {
        this.in = in;
        this.record = record;
        this.filter = filter;
        this.pl = pl;
        this.eofIsReached = false;
        this.cached = false;
    }

    public WarcFilteredIterator(FastBufferedInputStream in, WarcRecord record, Filter<WarcRecord> filter) {
        this(in, record, filter, null);
    }

    @Override
    public boolean hasNext() {
        if (this.eofIsReached) {
            return false;
        }
        if (this.cached) {
            return true;
        }
        try {
            long read;
            do {
                read = this.record.read(this.in);
                if (this.pl == null || read == -1L) continue;
                this.pl.update();
            } while (read != -1L && !this.filter.accept(this.record));
            this.eofIsReached = read == -1L;
            this.cached = !this.eofIsReached;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while reading next record", e);
        }
        catch (WarcRecord.FormatException e) {
            throw new RuntimeException("FormatException while reading next record", e);
        }
        return !this.eofIsReached;
    }

    @Override
    public WarcRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.cached = false;
        return this.record;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

