/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import java.io.IOException;

public class MeasurableSequenceInputStream
extends MeasurableInputStream {
    private final MeasurableInputStream[] streams;
    private MeasurableInputStream currentStream;
    private int currentStreamIndex;
    private final long length;
    private long position;

    public MeasurableSequenceInputStream(MeasurableInputStream ... streams) throws IOException {
        if (streams == null) {
            throw new NullPointerException();
        }
        this.streams = streams;
        long l = 0L;
        for (MeasurableInputStream is : streams) {
            if (is == null) continue;
            l += is.length();
        }
        this.length = l;
        this.position = 0L;
        this.currentStreamIndex = -1;
        this.nextStream();
    }

    private boolean nextStream() {
        do {
            ++this.currentStreamIndex;
        } while (this.currentStreamIndex < this.streams.length && this.streams[this.currentStreamIndex] == null);
        if (this.currentStreamIndex < this.streams.length) {
            this.currentStream = this.streams[this.currentStreamIndex];
            return true;
        }
        return false;
    }

    public long length() {
        return this.length;
    }

    public long position() {
        return this.position;
    }

    public int read() throws IOException {
        int b;
        if (this.currentStream == null) {
            return -1;
        }
        do {
            if ((b = this.currentStream.read()) == -1) continue;
            ++this.position;
        } while (b == -1 && this.nextStream());
        return b;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int r;
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buf.length || length < 0 || offset + length > buf.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.currentStream == null) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        do {
            if ((r = this.currentStream.read(buf, offset, length)) == -1) continue;
            this.position += (long)r;
        } while (r == -1 && this.nextStream());
        return r;
    }

    public void close() throws IOException {
        for (MeasurableInputStream i : this.streams) {
            if (i == null) continue;
            i.close();
        }
    }
}

