/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.law.warc.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class InspectableBufferedInputStream
extends MeasurableInputStream {
    public static final Logger LOGGER = Logger.getLogger(InspectableBufferedInputStream.class);
    public static final boolean DEBUG = false;
    public static final int OVERFLOW_FILE_RANDOM_PATH_ELEMENTS = 3;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public byte[] buffer;
    public int inspectable;
    public final File overflowFile;
    private FileOutputStream overflowOut;
    private FileChannel overflowOutChannel;
    private FileInputStream overflowIn;
    private FileChannel overflowInChannel;
    private InputStream underlying;
    private long readBytes;
    private long position;
    private State state;
    private boolean filled;
    private final byte[] b = new byte[8192];

    public InspectableBufferedInputStream(int bufferSize, File overflowFileDir) throws IOException {
        if (overflowFileDir != null && !overflowFileDir.isDirectory()) {
            throw new IllegalArgumentException("Wrong overflow directory " + overflowFileDir);
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Wrong buffer size " + bufferSize);
        }
        this.buffer = new byte[bufferSize];
        if (overflowFileDir == null) {
            overflowFileDir = new File(System.getProperty("java.io.tmpdir", "/tmp"));
        }
        this.overflowFile = Util.createHierarchicalTempFile(overflowFileDir, 3);
        LOGGER.debug((Object)("Creating overflow file " + this.overflowFile));
        this.overflowFile.deleteOnExit();
        this.position = 0L;
        this.readBytes = 0L;
        this.state = State.READY;
        this.filled = false;
        this.overflowOut = new FileOutputStream(this.overflowFile);
        this.overflowOutChannel = this.overflowOut.getChannel();
        this.overflowIn = new FileInputStream(this.overflowFile);
        this.overflowInChannel = this.overflowIn.getChannel();
    }

    public InspectableBufferedInputStream(int bufferSize) throws IOException {
        this(bufferSize, null);
    }

    public InspectableBufferedInputStream() throws IOException {
        this(65536);
    }

    public void connect(InputStream underlying) throws IOException {
        int result;
        if (this.state == State.DISPOSED) {
            throw new IllegalStateException("Connecting a disposed stream");
        }
        if (underlying == null) {
            throw new IllegalArgumentException("Cannot connect to null");
        }
        this.underlying = underlying;
        this.inspectable = 0;
        while ((result = underlying.read(this.buffer, this.inspectable, this.buffer.length - this.inspectable)) > 0) {
            this.inspectable += result;
        }
        this.readBytes = this.inspectable;
        this.position = 0L;
        this.overflowInChannel.position(0L);
        this.overflowOutChannel.position(0L);
        this.overflowOutChannel.truncate(0L);
        this.state = State.CONNECTED;
        this.filled = false;
    }

    public void truncate(long size) throws FileNotFoundException, IOException {
        if (this.state != State.READY) {
            throw new IllegalStateException("Truncation is possible only for non-connected and non-disposed streams");
        }
        this.overflowOutChannel.truncate(size);
    }

    public long readBytes() {
        return this.readBytes;
    }

    public void dispose() throws IOException {
        this.buffer = null;
        this.overflowOut.close();
        this.overflowIn.close();
        this.overflowFile.delete();
        this.state = State.DISPOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.state != State.DISPOSED) {
                this.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void close() throws IOException {
        if (this.state == State.READY) {
            return;
        }
        if (this.state == State.DISPOSED) {
            throw new IllegalStateException("Cannot close a disposed stream");
        }
        this.underlying.close();
        this.position = 0L;
        this.readBytes = 0L;
        this.state = State.READY;
    }

    public void rewind() throws IOException {
        if (this.state != State.CONNECTED) {
            throw new IllegalStateException("Cannot rewind a non-connected (" + (Object)((Object)this.state) + ") stream");
        }
        this.position = 0L;
        this.overflowInChannel.position(0L);
    }

    public int available() throws IOException {
        if (this.state != State.CONNECTED) {
            throw new IllegalStateException();
        }
        int av = 0;
        if (this.position < this.readBytes) {
            av = (int)(this.readBytes - this.position);
        }
        return av += this.underlying.available();
    }

    private int copy(byte[] buffer, int offset, int length) throws IOException {
        int read;
        LOGGER.debug((Object)("Copying " + length + " more bytes from the underlying stream"));
        int totallyRead = 0;
        while ((read = this.underlying.read(buffer, offset + totallyRead, length - totallyRead)) >= 0 && length > (totallyRead += read)) {
        }
        this.readBytes += (long)totallyRead;
        this.overflowOut.write(buffer, offset, totallyRead);
        this.overflowOut.flush();
        return totallyRead;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.state != State.CONNECTED) {
            throw new IllegalStateException("Cannot read from an unconnected stream");
        }
        ByteArrays.ensureOffsetLength((byte[])b, (int)offset, (int)length);
        if (length == 0) {
            return 0;
        }
        int copied = 0;
        LOGGER.debug((Object)("Requested to read " + length));
        if (this.position < (long)this.inspectable) {
            copied = Math.min(this.inspectable - (int)this.position, length);
            LOGGER.debug((Object)(" -> from memory buffer " + copied));
            System.arraycopy(this.buffer, (int)this.position, b, offset, copied);
            this.position += (long)copied;
            offset += copied;
            length -= copied;
        }
        LOGGER.debug((Object)("After buffer, remaining to read " + length));
        if (this.readBytes < (long)this.buffer.length) {
            LOGGER.debug((Object)("Underlying is shorter than buffer; returning " + (copied > 0 ? copied : (this.position < this.readBytes ? 0 : -1))));
            return copied > 0 ? copied : (this.position < this.readBytes ? 0 : -1);
        }
        if (length > 0) {
            int c;
            int toBeReadFromOverflow = Math.min((int)(this.readBytes - this.position), length);
            int readFromOverflow = 0;
            while ((c = this.overflowIn.read(b, offset + readFromOverflow, toBeReadFromOverflow - readFromOverflow)) >= 0 && toBeReadFromOverflow > (readFromOverflow += c)) {
            }
            LOGGER.debug((Object)(" -> from overflow file " + toBeReadFromOverflow));
            copied += toBeReadFromOverflow;
            this.position += (long)toBeReadFromOverflow;
            offset += toBeReadFromOverflow;
            length -= toBeReadFromOverflow;
        }
        LOGGER.debug((Object)("After file, remaining to read " + length));
        if (length > 0) {
            int c = this.copy(b, offset, length);
            LOGGER.debug((Object)(" -> copied from underlying stream " + c));
            copied += c;
            this.position += (long)c;
        }
        LOGGER.debug((Object)("Returning " + (copied > 0 ? copied : -1)));
        return copied > 0 ? copied : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        for (long k = 0L; k < n; ++k) {
            if (this.read() >= 0) continue;
            return k;
        }
        return n;
    }

    public int read() throws IOException {
        if (this.state != State.CONNECTED) {
            throw new IllegalStateException("Cannot read from an unconnected stream");
        }
        if (this.position < (long)this.buffer.length) {
            return this.position < this.readBytes ? this.buffer[(int)this.position++] & 0xFF : -1;
        }
        if (this.position >= this.readBytes) {
            int read = this.underlying.read();
            if (read < 0) {
                return read;
            }
            ++this.readBytes;
            this.overflowOut.write(read);
            this.overflowOut.flush();
        }
        ++this.position;
        return this.overflowIn.read();
    }

    public long overflowLength() {
        return this.overflowFile.length();
    }

    public void fill(long limit) throws IOException {
        if (this.state != State.CONNECTED) {
            throw new IllegalStateException("Cannot read from an unconnected stream");
        }
        while (this.readBytes < limit && this.read(this.b, 0, (int)Math.min(limit - this.readBytes, (long)this.b.length)) > 0) {
        }
        this.filled = true;
    }

    public void fillAndRewind(long limit) throws IOException {
        this.fill(limit);
        this.rewind();
    }

    public long length() {
        if (!this.filled) {
            try {
                this.fill(Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.readBytes;
    }

    public long position() {
        return this.position;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CONNECTED,
        READY,
        DISPOSED;

    }
}

