/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.HttpResponse;
import it.unimi.dsi.law.warc.util.WarcHttpResponse;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseFilteredIterator
implements Iterator<WarcHttpResponse> {
    private final FastBufferedInputStream in;
    private final WarcRecord record;
    private final WarcHttpResponse response;
    private final Filter<HttpResponse> filter;
    private final ProgressLogger pl;
    private boolean eofIsReached;
    private boolean cached;

    public HttpResponseFilteredIterator(FastBufferedInputStream in, WarcRecord record, WarcHttpResponse response, Filter<HttpResponse> filter, ProgressLogger pl) {
        this.in = in;
        this.record = record;
        this.response = response;
        this.filter = filter;
        this.pl = pl;
        this.eofIsReached = false;
        this.cached = false;
    }

    public HttpResponseFilteredIterator(FastBufferedInputStream in, WarcRecord record, WarcHttpResponse response, Filter<HttpResponse> filter) {
        this(in, record, response, filter, null);
    }

    @Override
    public boolean hasNext() {
        if (this.eofIsReached) {
            return false;
        }
        if (this.cached) {
            return true;
        }
        try {
            long read;
            while ((read = this.record.read(this.in)) != -1L) {
                if (this.pl != null && read != -1L) {
                    this.pl.update();
                }
                if (this.response.fromWarcRecord(this.record) && this.filter.accept(this.response)) {
                    this.cached = true;
                    break;
                }
                if (read != -1L) continue;
            }
            this.eofIsReached = read == -1L;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while reading next record", e);
        }
        catch (WarcRecord.FormatException e) {
            throw new RuntimeException("FormatException while reading next record", e);
        }
        return !this.eofIsReached;
    }

    @Override
    public WarcHttpResponse next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.cached = false;
        return this.response;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

