/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.law.warc.io.BoundedCountingInputStream;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class GZWarcRecord
extends WarcRecord {
    private static final Logger LOGGER = Logger.getLogger(GZWarcRecord.class);
    public static final boolean ASSERTS = true;
    public static final boolean USE_POSITION_INSTEAD_OF_SKIP = false;
    public static final byte XFL = 9;
    public static final byte FTEXT = 1;
    public static final byte FHCRC = 2;
    public static final byte FEXTRA = 4;
    public static final byte FNAME = 8;
    public static final byte FCOMMENT = 16;
    public static final byte[] GZIP_START = new byte[]{31, -117, 8, 28};
    public static final byte[] XFL_OS = new byte[]{9, -1};
    public static final byte[] SKIP_LEN = new byte[]{115, 108};
    public static final short SUB_LEN = 8;
    public static final short XLEN = 12;
    public static final short TRAILER_LEN = 8;
    public static final int FIX_LEN = GZIP_START.length + 4 + XFL_OS.length + 14 + 8;
    public static final int PARTIAL_UNCOMPRESSED_READ_THRESHOLD = 16;
    public static final int UNCOMPRESSED_RECORD_STREAM_BUFFER_SIZE = 1024;
    private final Deflater deflater = new Deflater(9, true);
    private final Inflater inflater = new Inflater(true);
    private final FastByteArrayOutputStream compressedOutpuStream = new FastByteArrayOutputStream();
    private final byte[] headerBuffer = new byte[16384];
    private long positionOfLastGZHeader;
    private long compressedDataLengthInLastGZHeader;
    private FastBufferedInputStream uncompressedRecordStream;
    public final GZHeader gzheader = new GZHeader();

    public GZWarcRecord() {
        this.crc = new CRC32();
        this.positionOfLastGZHeader = -1L;
    }

    public void resetRead() {
        this.positionOfLastGZHeader = -1L;
    }

    public long skip(FastBufferedInputStream in) throws IOException, WarcRecord.FormatException {
        if (this.readGZHeader(in) == -1L) {
            return -1L;
        }
        this.uncompressedRecordStream = null;
        this.readGZTrailer(in);
        return this.gzheader.compressedSkipLength;
    }

    public long read(FastBufferedInputStream in) throws IOException, WarcRecord.FormatException {
        if (this.readGZHeader(in) == -1L) {
            return -1L;
        }
        this.inflater.reset();
        this.crc.reset();
        long reminingCompressedBytes = (long)this.gzheader.compressedSkipLength - (in.position() - this.positionOfLastGZHeader) - 8L;
        assert (reminingCompressedBytes > 0L);
        InflaterInputStream gzin = new InflaterInputStream((InputStream)((Object)new BoundedCountingInputStream((InputStream)in, reminingCompressedBytes)), this.inflater);
        this.uncompressedRecordStream = new FastBufferedInputStream((InputStream)((Object)new BoundedCountingInputStream(gzin, this.gzheader.uncompressedSkipLength, this.crc)), 1024);
        super.resetRead();
        super.read(this.uncompressedRecordStream);
        return this.compressedDataLengthInLastGZHeader;
    }

    public void write(OutputStream out) throws IOException {
        byte[] buffer = this.headerBuffer;
        this.deflater.reset();
        this.compressedOutpuStream.reset();
        DeflaterOutputStream gzout = new DeflaterOutputStream((OutputStream)this.compressedOutpuStream, this.deflater);
        this.crc.reset();
        super.write(gzout);
        gzout.finish();
        gzout = null;
        byte[] recordByteRepresentation = Util.getASCIIBytes(this.header.recordId.toString());
        String digest = this.header.anvlFields.get("BUbiNG-content-digest");
        this.gzheader.name = recordByteRepresentation;
        int commentLength = 0;
        if (digest != null) {
            byte[] digestByteRepresentation = Util.getASCIIBytes(digest);
            commentLength = digestByteRepresentation.length;
            System.arraycopy(digestByteRepresentation, 0, buffer, 0, commentLength);
        } else {
            commentLength = recordByteRepresentation.length;
            System.arraycopy(recordByteRepresentation, 0, buffer, 0, commentLength);
        }
        buffer[commentLength++] = 9;
        byte[] subjectUriByteRepresentation = this.header.subjectUri.toByteArray();
        System.arraycopy(subjectUriByteRepresentation, 0, buffer, commentLength, subjectUriByteRepresentation.length);
        this.gzheader.comment = ArrayUtils.subarray((byte[])buffer, (int)0, (int)(commentLength += subjectUriByteRepresentation.length));
        this.gzheader.compressedSkipLength = FIX_LEN + (this.gzheader.name.length + 1) + (this.gzheader.comment.length + 1) + this.compressedOutpuStream.length;
        this.gzheader.uncompressedSkipLength = (int)(this.header.dataLength & 0xFFFFFFFFFFFFFFFFL);
        this.gzheader.mtime = (int)(this.header.creationDate.getTime() / 1000L);
        out.write(GZIP_START);
        GZWarcRecord.writeLEInt(out, this.gzheader.mtime);
        out.write(XFL_OS);
        GZWarcRecord.writeLEShort(out, (short)12);
        out.write(SKIP_LEN);
        GZWarcRecord.writeLEShort(out, (short)8);
        GZWarcRecord.writeLEInt(out, this.gzheader.compressedSkipLength);
        GZWarcRecord.writeLEInt(out, this.gzheader.uncompressedSkipLength);
        out.write(this.gzheader.name);
        out.write(0);
        out.write(this.gzheader.comment);
        out.write(0);
        out.write(this.compressedOutpuStream.array, 0, this.compressedOutpuStream.length);
        GZWarcRecord.writeLEInt(out, (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL));
        GZWarcRecord.writeLEInt(out, this.gzheader.uncompressedSkipLength);
    }

    public void checkCRC(FastBufferedInputStream in) throws IOException, WarcRecord.FormatException {
        if (this.positionOfLastGZHeader == -1L || this.uncompressedRecordStream == null) {
            throw new IllegalStateException();
        }
        this.consumeUncompressedRecord();
        this.readGZTrailer(in);
    }

    public String toString() {
        return this.gzheader.toString() + "\n" + this.header.toString();
    }

    private long readGZHeader(FastBufferedInputStream in) throws IOException, WarcRecord.FormatException {
        int b;
        int l;
        byte[] buffer = this.headerBuffer;
        if (this.positionOfLastGZHeader != -1L) {
            this.readGZTrailer(in);
        }
        this.positionOfLastGZHeader = in.position();
        if (in.read(buffer, 0, 4) == -1) {
            return -1L;
        }
        if (buffer[0] != GZIP_START[0] || buffer[1] != GZIP_START[1]) {
            throw new WarcRecord.FormatException(this, "Missing GZip magic numbers, found: " + buffer[0] + " " + buffer[1]);
        }
        if (buffer[2] != 8) {
            throw new WarcRecord.FormatException(this, "Unknown compression method: " + buffer[2]);
        }
        byte flg = buffer[3];
        this.gzheader.mtime = GZWarcRecord.readLEInt((InputStream)in);
        in.read(buffer, 0, 2);
        this.gzheader.compressedSkipLength = -1;
        if ((flg & 4) != 0) {
            short xlen = GZWarcRecord.readLEShort((InputStream)in);
            while (xlen > 0) {
                in.read(buffer, 0, 2);
                short len = GZWarcRecord.readLEShort((InputStream)in);
                if (buffer[0] == SKIP_LEN[0] && buffer[1] == SKIP_LEN[1]) {
                    this.gzheader.compressedSkipLength = GZWarcRecord.readLEInt((InputStream)in);
                    this.compressedDataLengthInLastGZHeader = this.gzheader.compressedSkipLength;
                    this.gzheader.uncompressedSkipLength = GZWarcRecord.readLEInt((InputStream)in);
                } else {
                    in.read(buffer, 0, (int)len);
                }
                xlen = (short)(xlen - (len + 4));
            }
        }
        if (this.gzheader.compressedSkipLength < 0) {
            throw new WarcRecord.FormatException(this, "Missing SL extra field, or negative compressed-skip-length");
        }
        if ((flg & 8) != 0) {
            l = 0;
            while ((b = in.read()) != 0) {
                buffer[l++] = (byte)b;
            }
            this.gzheader.name = ArrayUtils.subarray((byte[])buffer, (int)0, (int)l);
        }
        if ((flg & 0x10) != 0) {
            l = 0;
            while ((b = in.read()) != 0) {
                buffer[l++] = (byte)b;
            }
            this.gzheader.comment = ArrayUtils.subarray((byte[])buffer, (int)0, (int)l);
        }
        if ((flg & 2) != 0) {
            in.read(buffer, 0, 2);
        }
        return this.compressedDataLengthInLastGZHeader;
    }

    private void readGZTrailer(FastBufferedInputStream in) throws IOException, WarcRecord.FormatException {
        int iSize;
        if (this.positionOfLastGZHeader == -1L) {
            return;
        }
        boolean consumed = false;
        if (this.uncompressedRecordStream != null) {
            long remaining = this.uncompressedRecordStream.length() - this.uncompressedRecordStream.position();
            assert (remaining >= 0L);
            if (0L < remaining && remaining < 16L) {
                this.consumeUncompressedRecord();
                consumed = true;
            } else {
                LOGGER.debug((Object)"Omitting CRC check, since the last read was partial.");
            }
        } else {
            LOGGER.debug((Object)"Omitting CRC check, since coming from a skip.");
        }
        long newPosition = this.positionOfLastGZHeader + this.compressedDataLengthInLastGZHeader - 8L;
        assert (newPosition >= in.position());
        in.skip(newPosition - in.position());
        int expectedCrc = GZWarcRecord.readLEInt((InputStream)in);
        if (consumed) {
            int actualCrc = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
            if (expectedCrc != actualCrc) {
                throw new WarcRecord.FormatException(this, "CRC32 mismatch, expected: " + expectedCrc + ", actual: " + actualCrc);
            }
            LOGGER.debug((Object)"CRC check OK.");
        }
        if (this.gzheader.uncompressedSkipLength != (iSize = GZWarcRecord.readLEInt((InputStream)in))) {
            throw new WarcRecord.FormatException(this, "Length mismatch between (warc) extra gzip fields uncompressed-skip-length (" + this.gzheader.uncompressedSkipLength + ") and ISIZE (" + iSize + ")");
        }
        this.positionOfLastGZHeader = -1L;
    }

    private void consumeUncompressedRecord() throws IOException {
        assert (this.uncompressedRecordStream.length() - this.uncompressedRecordStream.position() >= 4L);
        byte[] b = new byte[1024];
        while (this.uncompressedRecordStream.read(b) != -1) {
        }
        this.uncompressedRecordStream.skip(Long.MAX_VALUE);
    }

    private static int readLEInt(InputStream in) throws IOException {
        int i = in.read() & 0xFF;
        i |= (in.read() & 0xFF) << 8;
        i |= (in.read() & 0xFF) << 16;
        return i |= (in.read() & 0xFF) << 24;
    }

    private static short readLEShort(InputStream in) throws IOException {
        short s = (byte)in.read();
        s = (short)(s | (byte)in.read() << 8);
        return s;
    }

    private static void writeLEInt(OutputStream out, int i) throws IOException {
        out.write((byte)i);
        out.write((byte)(i >> 8 & 0xFF));
        out.write((byte)(i >> 16 & 0xFF));
        out.write((byte)(i >> 24 & 0xFF));
    }

    private static void writeLEShort(OutputStream out, short s) throws IOException {
        out.write((byte)s);
        out.write((byte)(s >> 8 & 0xFF));
    }

    public static class GZHeader {
        public int compressedSkipLength;
        public int uncompressedSkipLength;
        public int mtime;
        public byte[] name;
        public byte[] comment;

        public String toString() {
            MutableString s = new MutableString();
            s.append("compressedSkipLength: ");
            s.append(this.compressedSkipLength);
            s.append(", uncompressedSkipLength: ");
            s.append(this.uncompressedSkipLength);
            s.append(", mtime: ");
            s.append(this.mtime);
            s.append(", name: ");
            s.append(this.name == null ? "<null>" : Util.getString(this.name));
            s.append(", comment: ");
            s.append(this.comment == null ? "<null>" : Util.getString(this.comment));
            return s.toString();
        }

        public int hashCode() {
            return Util.getString(this.name).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof GZHeader)) {
                return false;
            }
            GZHeader h = (GZHeader)o;
            if (this.compressedSkipLength != h.compressedSkipLength) {
                return false;
            }
            if (this.uncompressedSkipLength != h.uncompressedSkipLength) {
                return false;
            }
            if (this.mtime != h.mtime) {
                return false;
            }
            if (!Arrays.equals(this.name, h.name)) {
                return false;
            }
            return Arrays.equals(this.comment, h.comment);
        }
    }
}

