/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.io;

import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class BoundedCountingInputStream
extends MeasurableInputStream {
    private InputStream is;
    private long length;
    private long bound;
    private long position;
    private boolean eofReached;
    public CRC32 crc;

    public BoundedCountingInputStream() {
    }

    public BoundedCountingInputStream(InputStream is, long bound, CRC32 crc) throws IOException {
        this.setInput(is, bound, crc);
    }

    public BoundedCountingInputStream(InputStream is, long bound) throws IOException {
        this.setInput(is, bound);
    }

    public void setInput(InputStream is, long bound, CRC32 crc) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        this.is = is;
        this.bound = bound;
        this.crc = crc;
        this.eofReached = false;
        long isLength = Long.MAX_VALUE;
        if (is instanceof MeasurableInputStream) {
            try {
                isLength = ((MeasurableInputStream)is).length();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.length = Math.min(isLength, bound);
    }

    public void setInput(InputStream is, long bound) throws IOException {
        this.setInput(is, bound, null);
    }

    public int available() throws IOException {
        return (int)Math.min((long)this.is.available(), this.bound - this.position);
    }

    public int read() throws IOException {
        if (this.position >= this.bound || this.eofReached) {
            return -1;
        }
        int b = this.is.read();
        if (b == -1) {
            this.eofReached = true;
        } else {
            ++this.position;
            if (this.crc != null) {
                this.crc.update(b);
            }
        }
        return b;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this.position >= this.bound || this.eofReached) {
            return -1;
        }
        int read = this.is.read(buf, offset, (int)Math.min((long)length, this.bound - this.position));
        if (read == -1) {
            this.eofReached = true;
        } else {
            this.position += (long)read;
            if (this.crc != null) {
                this.crc.update(buf, offset, read);
            }
        }
        return read;
    }

    public long length() throws IOException {
        return this.length;
    }

    public long position() {
        return this.position;
    }
}

