/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.filters;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.util.BURL;
import it.unimi.dsi.law.warc.util.Util;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathEndsWithOneOf
extends Filter<BURL> {
    private final String[] suffixes;

    public PathEndsWithOneOf(String[] suffixes) {
        this.suffixes = new String[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            this.suffixes[i] = suffixes[i].toLowerCase();
        }
    }

    @Override
    public boolean accept(BURL x) {
        String file = x.path().toLowerCase();
        for (String suffix : this.suffixes) {
            if (!file.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static PathEndsWithOneOf fromExternalForm(String spec) throws IOException {
        return new PathEndsWithOneOf(Util.parseCommaSeparatedProperty(spec));
    }

    @Override
    public String toExternalForm() {
        return StringUtils.join((Object[])this.suffixes, (char)',');
    }

    public boolean equals(Object x) {
        if (x instanceof PathEndsWithOneOf) {
            ObjectOpenHashSet suffixSet = new ObjectOpenHashSet((Object[])this.suffixes);
            ObjectOpenHashSet xSuffixSet = new ObjectOpenHashSet((Object[])((PathEndsWithOneOf)x).suffixes);
            return suffixSet.equals(xSuffixSet);
        }
        return false;
    }
}

