/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.filters;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.law.warc.filters.ContentTypeStartsWith;
import it.unimi.dsi.law.warc.filters.DigestEquals;
import it.unimi.dsi.law.warc.filters.DuplicateSegmentsLessThan;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.filters.HostEndsWith;
import it.unimi.dsi.law.warc.filters.HostEquals;
import it.unimi.dsi.law.warc.filters.IsHttpResponse;
import it.unimi.dsi.law.warc.filters.PathEndsWithOneOf;
import it.unimi.dsi.law.warc.filters.SchemeEquals;
import it.unimi.dsi.law.warc.filters.StatusCategory;
import it.unimi.dsi.law.warc.filters.URLEquals;
import it.unimi.dsi.law.warc.filters.URLMatchesRegex;
import it.unimi.dsi.law.warc.filters.URLShorterThan;
import it.unimi.dsi.law.warc.filters.parser.ParseException;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.BURL;
import it.unimi.dsi.law.warc.util.HttpResponse;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static final Filter<?>[] EMPTY_ARRAY = new Filter[0];
    private static final ObjectOpenHashSet<Class<? extends Filter<?>>> FILTERS = new ObjectOpenHashSet((Object[])new Class[]{ContentTypeStartsWith.class, DigestEquals.class, DuplicateSegmentsLessThan.class, HostEndsWith.class, HostEquals.class, IsHttpResponse.class, PathEndsWithOneOf.class, SchemeEquals.class, StatusCategory.class, URLEquals.class, URLMatchesRegex.class, URLShorterThan.class});
    public static Filter TRUE = new Filter(){

        public boolean accept(Object x) {
            return true;
        }

        public String toExternalForm() {
            return "true";
        }
    };

    public static <T> Filter<T> and(final Filter<T> ... f) {
        return new Filter<T>(){

            @Override
            public boolean accept(T x) {
                for (Filter filter : f) {
                    if (filter.accept(x)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String toExternalForm() {
                return StringUtils.join((Object[])f, (String)" and ");
            }
        };
    }

    public static <T> Filter<T> or(final Filter<T> ... f) {
        return new Filter<T>(){

            @Override
            public boolean accept(T x) {
                for (Filter filter : f) {
                    if (!filter.accept(x)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String toExternalForm() {
                return StringUtils.join((Object[])f, (String)" or ");
            }
        };
    }

    public static <T> Filter<T> not(final Filter<T> filter) {
        return new Filter<T>(){

            @Override
            public boolean accept(T x) {
                return !filter.accept(x);
            }

            @Override
            public String toExternalForm() {
                return "not " + filter.toString();
            }
        };
    }

    public static <T> Filter<T> getFilterFromSpec(String className, String externalForm, Class tClass) throws ParseException {
        String filterClassName = className.indexOf(46) >= 0 ? className : Filter.FILTER_PACKAGE_NAME + "." + className;
        try {
            Method adaptMethod;
            int i;
            Class<?> c = Class.forName(filterClassName);
            if (!Filter.class.isAssignableFrom(c)) {
                throw new ParseException(filterClassName + " is not a valid filter class");
            }
            Filter filter = (Filter)c.getMethod("fromExternalForm", String.class).invoke(null, externalForm);
            Method[] m = filter.getClass().getDeclaredMethods();
            for (i = 0; i < m.length && !m[i].getName().equals("accept"); ++i) {
            }
            if (i == m.length) {
                throw new NoSuchMethodException("Could not find accept method in filter " + filter);
            }
            Class<?> toClass = m[i].getParameterTypes()[0];
            if (toClass.equals(tClass)) {
                return filter;
            }
            try {
                adaptMethod = Filters.class.getMethod("adaptFilter" + toClass.getSimpleName() + "2" + tClass.getSimpleName(), Filter.class);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodException("Cannot adapt a Filter<" + toClass.getSimpleName() + "> into Filter<" + tClass.getSimpleName() + ">");
            }
            return (Filter)adaptMethod.invoke(null, filter);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e.toString());
        }
    }

    public static Filter<BURL> adaptFilterString2BURL(final Filter<String> original) {
        return new Filter<BURL>(){

            @Override
            public boolean accept(BURL x) {
                return original.accept(x.toString());
            }

            @Override
            public String toExternalForm() {
                return original.toExternalForm();
            }

            @Override
            public String toString() {
                return original.toString();
            }
        };
    }

    public static Filter<HttpResponse> adaptFilterBURL2HttpResponse(final Filter<BURL> original) {
        return new Filter<HttpResponse>(){

            @Override
            public boolean accept(HttpResponse x) {
                return original.accept(x.url());
            }

            @Override
            public String toExternalForm() {
                return original.toExternalForm();
            }

            @Override
            public String toString() {
                return original.toString();
            }
        };
    }

    public static Filter<WarcRecord> adaptFilterBURL2WarcRecord(final Filter<BURL> original) {
        return new Filter<WarcRecord>(){

            @Override
            public boolean accept(WarcRecord x) {
                return original.accept(x.header.subjectUri);
            }

            @Override
            public String toExternalForm() {
                return original.toExternalForm();
            }

            @Override
            public String toString() {
                return original.toString();
            }
        };
    }

    public static Class<? extends Filter<?>>[] standardFilters() {
        return (Class[])FILTERS.toArray((Object[])new Class[FILTERS.size()]);
    }
}

