/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.filters;

import cern.colt.Sorting;
import cern.colt.function.IntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.util.BURL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateSegmentsLessThan
extends Filter<BURL> {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = true;
    private static final char EXTRA_SYMBOL = '\uffff';
    private final int threshold;

    public DuplicateSegmentsLessThan(int threshold) {
        if (threshold < 2) {
            throw new IllegalArgumentException("This filter requires a threshold larger than one");
        }
        this.threshold = threshold;
    }

    private void matches(boolean b, String s) {
        Matcher m0 = Pattern.compile(".*(/.*)\\1{" + (this.threshold - 1) + ",}/.*").matcher(s);
        Matcher m1 = Pattern.compile(".*(/.*)\\1{" + (this.threshold - 1) + ",}").matcher(s);
        assert (b != (m0.matches() || m1.matches())) : s + " (" + !b + (!b ? "" : ", " + (m0.matches() ? m0.group(1) : m1.group(1))) + ")";
    }

    @Override
    public boolean accept(BURL url) {
        int k;
        int starti;
        int length;
        assert (url.path().length() > 0) : url;
        String s = url.path();
        boolean pathEndsWithSlash = s.charAt((length = s.length()) - 1) == '/';
        final char[] path = new char[length + 1 + (!pathEndsWithSlash ? 1 : 0)];
        path[path.length - 1] = 65535;
        if (!pathEndsWithSlash) {
            path[path.length - 2] = 47;
        }
        s.getChars(0, length, path, 0);
        int c = 0;
        int i = length;
        while (i-- != 0) {
            if (path[i] != '/') continue;
            ++c;
        }
        if (c < this.threshold) {
            this.matches(true, s);
            return true;
        }
        final int[] start = new int[c];
        c = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (path[i2] != '/') continue;
            start[c++] = i2;
        }
        int[] a = new int[c];
        int i3 = c;
        while (i3-- != 0) {
            a[i3] = i3;
        }
        Sorting.quickSort((int[])a, (int)0, (int)c, (IntComparator)new IntComparator(){

            public int compare(int x, int y) {
                if (x == y) {
                    return 0;
                }
                int j = start[x];
                int k = start[y];
                while (path[++j] == path[++k]) {
                }
                return path[j] - path[k];
            }
        });
        int[] r = new int[c];
        int i4 = c;
        while (i4-- != 0) {
            r[a[i4]] = i4;
        }
        int[] lcp = new int[c + 1];
        int h = 0;
        int p = 1;
        boolean maxNonZero = false;
        for (int i5 = 0; i5 < c; ++i5) {
            if (r[i5] <= 0) continue;
            int j = a[r[i5] - 1];
            starti = start[i5];
            int startj = start[j];
            while (path[starti + p] == path[startj + p]) {
                if (path[starti + p] == '/') {
                    ++h;
                }
                ++p;
            }
            lcp[r[i5]] = h;
            if (h > 0) {
                maxNonZero = true;
                k = 1;
                while (path[starti + k] != '/') {
                    ++k;
                }
                p -= k;
                --h;
                continue;
            }
            p = 1;
        }
        if (!maxNonZero) {
            this.matches(true, s);
            return true;
        }
        int[] lcp2 = new int[c + 1];
        int i6 = c;
        while (i6-- != 1) {
            starti = start[a[i6 - 1]];
            int startipp = start[a[i6]];
            k = 1;
            int n = 0;
            while (path[starti + k] == path[startipp + k]) {
                if (path[starti + k] == '/') {
                    ++n;
                }
                ++k;
            }
            lcp2[i6] = n;
        }
        assert (Arrays.equals(lcp2, lcp));
        int[] ls = new int[c + 1];
        int[] ds = new int[c + 1];
        int[] prog = new int[c];
        ds[0] = -1;
        ls[0] = -1;
        p = 1;
        for (int i7 = 0; i7 < c; ++i7) {
            int llca = i7;
            int dlca = lcp[i7 + 1];
            while (ds[p - 1] > dlca) {
                int l = ls[--p];
                int d = ds[p];
                if (i7 - l + 1 >= this.threshold) {
                    IntArrays.fill((int[])prog, (int)l, (int)(i7 + 1), (int)0);
                    for (int j = l; j <= i7; ++j) {
                        int pos;
                        int u;
                        if (prog[j] != 0) continue;
                        int t = 1;
                        int k2 = u = a[j];
                        while ((k2 += d) < c && (pos = r[k2]) >= l && i7 >= pos) {
                            if (prog[pos] != 0) {
                                assert (prog[pos] > 0) : "l=" + l + " , i=" + i7 + ", j=" + j + ", t=" + t + ", a=" + Arrays.toString(a) + ", prog=" + Arrays.toString(prog);
                                t += prog[pos];
                                break;
                            }
                            ++t;
                        }
                        if (t >= this.threshold) {
                            this.matches(false, s);
                            return false;
                        }
                        prog[j] = t;
                        while ((k2 -= d) != u) {
                            prog[r[k2]] = -1;
                        }
                    }
                }
                llca = l;
            }
            if (ds[p - 1] >= dlca) continue;
            ls[p] = llca;
            ds[p++] = dlca;
        }
        this.matches(true, s);
        return true;
    }

    public static DuplicateSegmentsLessThan fromExternalForm(String spec) {
        return new DuplicateSegmentsLessThan(Integer.parseInt(spec));
    }

    @Override
    public String toExternalForm() {
        return Integer.toString(this.threshold);
    }

    public boolean equals(Object x) {
        return x instanceof DuplicateSegmentsLessThan && ((DuplicateSegmentsLessThan)x).threshold == this.threshold;
    }

    public static void main(String[] arg) {
        int rep = Integer.parseInt(arg[0]);
        long times = Long.parseLong(arg[1]);
        Pattern p = Pattern.compile(".*/(.*/)\\1{" + (rep - 1) + ",}.*");
        String url = "http://example.com/test/foo/bar1/foo/bar2/foo/mu/foo/bar3/foo/bar4/foo/bar5/test/foo/bar1/foo/bar2/foo/mu/foo/bar3/foo/bar4/foo/bar5/test/";
        DuplicateSegmentsLessThan filter = new DuplicateSegmentsLessThan(rep);
        BURL burl = BURL.parse(url);
        System.err.println("Regex: " + !p.matcher(url).matches());
        System.err.println("Filter: " + filter.accept(burl));
        int k = 10;
        while (k-- != 0) {
            long start = -System.currentTimeMillis();
            long i = times;
            while (i-- != 0L) {
                Matcher m = p.matcher(url);
                m.matches();
            }
            System.err.printf("Regex: %f Kcalls/s\n", (double)times / (double)(start += System.currentTimeMillis()));
            start = -System.currentTimeMillis();
            i = times;
            while (i-- != 0L) {
                filter.accept(burl);
            }
            System.err.printf("Filter: %f Kcalls/s\n", (double)times / (double)(start += System.currentTimeMillis()));
        }
    }
}

