/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.warc.filters;

import it.unimi.dsi.law.warc.filters.Filter;
import it.unimi.dsi.law.warc.io.WarcRecord;
import it.unimi.dsi.law.warc.util.Util;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestEquals
extends Filter<WarcRecord> {
    private final byte[] digest;

    private DigestEquals(byte[] digest) {
        this.digest = digest;
    }

    @Override
    public boolean accept(WarcRecord x) {
        String s = x.header.anvlFields.get("BUbiNG-content-digest");
        return s != null && Arrays.equals(this.digest, Util.fromHexString(s));
    }

    public static DigestEquals fromExternalForm(String spec) {
        return new DigestEquals(Util.fromHexString(spec));
    }

    @Override
    public String toExternalForm() {
        return Util.toHexString(this.digest);
    }
}

