/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.vector;

import java.io.Serializable;

public abstract class Vector
implements Serializable {
    public static final int INVALID_ID = -1;
    public static final double INVALID_NORM = -1.0;
    public final int size;
    public final int id;
    protected double ell2norm;
    protected double ell1norm;
    private final boolean mutable;

    protected Vector(int size, boolean mutable, int id) {
        this.size = size;
        this.mutable = mutable;
        this.id = id;
        this.ell1norm = -1.0;
        this.ell2norm = -1.0;
    }

    public abstract void set(int var1, double var2);

    public abstract double get(int var1);

    public void add(double alpha, Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        int i = this.size;
        while (i-- != 0) {
            this.set(i, this.get(i) + v.get(i) * alpha);
        }
        this.ell2norm = -1.0;
    }

    public void scale(double alpha) {
        int i = this.size;
        while (i-- != 0) {
            this.set(i, alpha * this.get(i));
        }
        if (this.ell2norm != -1.0) {
            this.ell2norm *= Math.abs(alpha);
        }
        if (this.ell1norm != -1.0) {
            this.ell1norm *= Math.abs(alpha);
        }
    }

    public void zero() {
        for (int i = 0; i < this.size; ++i) {
            this.set(i, 0.0);
        }
        this.ell1norm = 0.0;
        this.ell2norm = 0.0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public double dotProduct(Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        double dot = 0.0;
        double c = 0.0;
        int i = this.size;
        while (i-- != 0) {
            double y = this.get(i) * v.get(i) - c;
            double t = dot + y;
            c = t - dot - y;
            dot = t;
        }
        return dot;
    }

    public double euclideanDistance(Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        double dist = 0.0;
        int i = this.size;
        while (i-- != 0) {
            double temp = this.get(i) - v.get(i);
            dist += temp * temp;
        }
        return Math.sqrt(Math.abs(dist));
    }

    public double ell2Norm() {
        if (this.ell2norm == -1.0) {
            this.ell2norm = Math.sqrt(Math.abs(this.dotProduct(this)));
        }
        return this.ell2norm;
    }

    public double ell1Norm() {
        if (this.ell1norm == -1.0) {
            double tempNorm = 0.0;
            int i = this.size;
            while (i-- != 0) {
                tempNorm += Math.abs(this.get(i));
            }
            this.ell1norm = tempNorm;
        }
        return this.ell1norm;
    }
}

