/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.vector;

import it.unimi.dsi.fastutil.ints.Int2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.law.vector.ImmutableSparseVector;
import it.unimi.dsi.law.vector.Vector;

public class Int2DoubleMapVector
extends Vector {
    static final long serialVersionUID = 2006002L;
    private final Int2DoubleMap value;

    private Int2DoubleMapVector(int size, int id) {
        super(size, true, id);
        this.value = new Int2DoubleAVLTreeMap();
        this.ell1norm = 0.0;
        this.ell2norm = 0.0;
    }

    private Int2DoubleMapVector(int size, Int2DoubleMap value, int id) {
        super(size, true, id);
        this.value = value;
        this.ell2norm = -1.0;
    }

    public static Int2DoubleMapVector getInstance(int size, int id) {
        return new Int2DoubleMapVector(size, id);
    }

    public static Int2DoubleMapVector getInstance(int size, Int2DoubleMap value, int id) {
        return new Int2DoubleMapVector(size, value, id);
    }

    public void set(int idx, double val) {
        if (idx < 0 || idx >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        this.value.put(idx, val);
        this.ell1norm = -1.0;
        this.ell2norm = -1.0;
    }

    public double get(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.value.get(idx);
    }

    public ImmutableSparseVector toImmutableSparseVector() {
        double[] value = this.value.values().toDoubleArray();
        int[] index = this.value.keySet().toIntArray();
        return ImmutableSparseVector.getInstance(this.size, value, index, this.id);
    }
}

