/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.vector;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.law.vector.DenseVector;
import it.unimi.dsi.law.vector.Vector;
import java.util.Arrays;

public class ImmutableSparseVector
extends Vector {
    static final long serialVersionUID = 2006002L;
    public final double[] value;
    public final int[] index;
    public final int nonZero;
    private int lastIndex;
    private int lastIndexValue;
    private int lastIndexNextValue;

    private ImmutableSparseVector(int size, double[] value, int[] index, int id) {
        super(size, false, id);
        this.value = value;
        this.index = index;
        this.nonZero = index.length;
        this.lastIndexNextValue = -1;
        this.lastIndexValue = -1;
        this.lastIndex = -1;
    }

    public static ImmutableSparseVector getInstance(int size, double[] value, int[] index, int id) {
        if (value.length != index.length) {
            throw new IllegalArgumentException("array with different size");
        }
        int i = index.length;
        while (i-- != 0) {
            if (index[i] >= 0) continue;
            throw new IllegalArgumentException("index with negative value");
        }
        return new ImmutableSparseVector(size, value, index, id);
    }

    public static ImmutableSparseVector getInstance(Vector v, double threshold, int id) {
        int size;
        IntArrayList indexList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        int i = size = v.size;
        while (i-- != 0) {
            double d = v.get(i);
            if (!(d < -threshold) && !(d > threshold)) continue;
            indexList.add(i);
            valueList.add(d);
        }
        return new ImmutableSparseVector(size, valueList.toDoubleArray(), indexList.toIntArray(), id);
    }

    public static ImmutableSparseVector getInstance(double[] value, double threshold, int id) {
        IntArrayList indexList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        int size = value.length;
        for (int i = 0; i < size; ++i) {
            double d = value[i];
            if (!(d < -threshold) && !(d > threshold)) continue;
            indexList.add(i);
            valueList.add(d);
        }
        return new ImmutableSparseVector(size, valueList.toDoubleArray(), indexList.toIntArray(), id);
    }

    public static ImmutableSparseVector getInstance(int[] index, double[] value, int size, double threshold, int id) {
        IntArrayList indexList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        for (int i = 0; i < index.length; ++i) {
            if (!(value[i] >= threshold)) continue;
            indexList.add(index[i]);
            valueList.add(value[i]);
        }
        return new ImmutableSparseVector(size, valueList.toDoubleArray(), indexList.toIntArray(), id);
    }

    public void set(int idx, double val) {
        throw new UnsupportedOperationException("ImmutableSparseVector is immutable");
    }

    public double get(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (idx > this.lastIndexValue && idx < this.lastIndexNextValue) {
            return 0.0;
        }
        if (idx == this.lastIndexNextValue) {
            ++this.lastIndex;
            this.lastIndexValue = this.index[this.lastIndex];
            this.lastIndexNextValue = this.lastIndex == this.nonZero - 1 ? this.size : this.index[this.lastIndex + 1];
            return this.value[this.lastIndex];
        }
        int pos = Arrays.binarySearch(this.index, idx);
        if (pos < 0) {
            this.lastIndexNextValue = -1;
            this.lastIndexValue = -1;
            return 0.0;
        }
        this.lastIndex = pos;
        this.lastIndexValue = this.index[this.lastIndex];
        this.lastIndexNextValue = this.lastIndex == this.nonZero - 1 ? this.size : this.index[this.lastIndex + 1];
        return this.value[pos];
    }

    public void add(double alpha, Vector v) {
        throw new UnsupportedOperationException("ImmutableSparseVector is immutable");
    }

    public void scale(double alpha) {
        throw new UnsupportedOperationException("ImmutableSparseVector is immutable");
    }

    public void zero() {
        throw new UnsupportedOperationException("ImmutableSparseVector is immutable");
    }

    public double dotProduct(Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        if (v instanceof ImmutableSparseVector) {
            ImmutableSparseVector sVector = (ImmutableSparseVector)v;
            double[] svValue = sVector.value;
            int[] svIndex = sVector.index;
            int last0 = this.nonZero;
            int last1 = sVector.nonZero;
            int i = 0;
            int j = 0;
            double dot = 0.0;
            double c = 0.0;
            while (i < last0 && j < last1) {
                if (this.index[i] < svIndex[j]) {
                    ++i;
                    continue;
                }
                if (svIndex[j] < this.index[i]) {
                    ++j;
                    continue;
                }
                double y = this.value[i] * svValue[j] - c;
                double t = dot + y;
                c = t - dot - y;
                dot = t;
                ++i;
                ++j;
            }
            return dot;
        }
        if (v instanceof DenseVector) {
            double[] dvValue = ((DenseVector)v).value;
            double dot = 0.0;
            double c = 0.0;
            int i = this.nonZero;
            while (i-- != 0) {
                double y = dvValue[this.index[i]] * this.value[i] - c;
                double t = dot + y;
                c = t - dot - y;
                dot = t;
            }
            return dot;
        }
        return super.dotProduct(v);
    }

    public double euclideanDistance(Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        if (v instanceof DenseVector) {
            return v.euclideanDistance(this);
        }
        if (v instanceof ImmutableSparseVector) {
            return Math.sqrt(Math.abs(this.dotProduct(this) + v.dotProduct(v) - 2.0 * this.dotProduct(v)));
        }
        return super.euclideanDistance(v);
    }

    public double ell2Norm() {
        if (this.ell2norm == -1.0) {
            double tempNorm = 0.0;
            int i = this.nonZero;
            while (--i >= 0) {
                tempNorm += this.value[i] * this.value[i];
            }
            this.ell2norm = Math.sqrt(Math.abs(tempNorm));
        }
        return this.ell2norm;
    }

    public double ell1Norm() {
        if (this.ell1norm == -1.0) {
            double tempNorm = 0.0;
            int i = this.nonZero;
            while (i-- != 0) {
                tempNorm += Math.abs(this.value[i]);
            }
            this.ell1norm = tempNorm;
        }
        return this.ell1norm;
    }
}

