/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.vector;

import it.unimi.dsi.law.vector.ImmutableSparseVector;
import it.unimi.dsi.law.vector.Vector;
import java.util.Arrays;

public class DenseVector
extends Vector {
    static final long serialVersionUID = 2006002L;
    final double[] value;

    private DenseVector(int size, int id) {
        super(size, true, id);
        this.value = new double[size];
        this.ell1norm = 0.0;
        this.ell2norm = 0.0;
    }

    private DenseVector(double[] value, int id) {
        super(value.length, true, id);
        this.value = value;
        this.ell1norm = -1.0;
        this.ell2norm = -1.0;
    }

    public static DenseVector getInstance(int size, int id) {
        return new DenseVector(size, id);
    }

    public static DenseVector getInstance(double[] value, int id) {
        return new DenseVector(value, id);
    }

    public void set(int idx, double val) {
        if (idx < 0 || idx >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.ell1norm != -1.0) {
            this.ell1norm = this.ell1norm - Math.abs(this.value[idx]) + Math.abs(val);
        }
        this.value[idx] = val;
        this.ell2norm = -1.0;
    }

    public double get(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.value[idx];
    }

    public void add(double alpha, Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        if (v instanceof DenseVector) {
            double[] dvValue = ((DenseVector)v).value;
            int i = this.size;
            while (i-- != 0) {
                int n = i;
                this.value[n] = this.value[n] + dvValue[i] * alpha;
            }
        } else if (v instanceof ImmutableSparseVector) {
            ImmutableSparseVector sv = (ImmutableSparseVector)v;
            double[] svValue = sv.value;
            int[] svIndex = sv.index;
            int i = sv.nonZero;
            while (i-- != 0) {
                int n = svIndex[i];
                this.value[n] = this.value[n] + svValue[i] * alpha;
            }
        } else {
            super.add(alpha, v);
        }
        this.ell1norm = -1.0;
        this.ell2norm = -1.0;
    }

    public void scale(double alpha) {
        int i = this.size;
        while (i-- != 0) {
            int n = i;
            this.value[n] = this.value[n] * alpha;
        }
        if (this.ell2norm != -1.0) {
            this.ell2norm *= Math.abs(alpha);
        }
        if (this.ell1norm != -1.0) {
            this.ell1norm *= Math.abs(alpha);
        }
    }

    public void zero() {
        Arrays.fill(this.value, 0.0);
        this.ell2norm = 0.0;
    }

    public double dotProduct(Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        if (v instanceof DenseVector) {
            double[] dvValue = ((DenseVector)v).value;
            double dot = 0.0;
            double c = 0.0;
            int i = this.size;
            while (i-- != 0) {
                double y = this.value[i] * dvValue[i] - c;
                double t = dot + y;
                c = t - dot - y;
                dot = t;
            }
            return dot;
        }
        if (v instanceof ImmutableSparseVector) {
            return v.dotProduct(this);
        }
        return super.dotProduct(v);
    }

    public double euclideanDistance(Vector v) {
        if (this.size != v.size) {
            throw new IllegalArgumentException("vectors with different size");
        }
        if (v instanceof DenseVector) {
            double[] dvValue = ((DenseVector)v).value;
            double dist = 0.0;
            double c = 0.0;
            int i = this.size;
            while (i-- != 0) {
                double temp = this.value[i] - dvValue[i];
                double y = temp * temp - c;
                double t = dist + y;
                c = t - dist - y;
                dist = t;
            }
            return Math.sqrt(Math.abs(dist));
        }
        if (v instanceof ImmutableSparseVector) {
            return Math.sqrt(Math.abs(this.dotProduct(this) + v.dotProduct(v) - 2.0 * v.dotProduct(this)));
        }
        return super.euclideanDistance(v);
    }

    public double ell2Norm() {
        if (this.ell2norm == -1.0) {
            double tempNorm = 0.0;
            int i = this.size;
            while (i-- != 0) {
                tempNorm += this.value[i] * this.value[i];
            }
            this.ell2norm = Math.sqrt(Math.abs(tempNorm));
        }
        return this.ell2norm;
    }

    public double ell1Norm() {
        if (this.ell1norm == -1.0) {
            double tempNorm = 0.0;
            int i = this.size;
            while (i-- != 0) {
                tempNorm += Math.abs(this.value[i]);
            }
            this.ell1norm = tempNorm;
        }
        return this.ell1norm;
    }
}

