/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.util;

public class NormL2 {
    private NormL2() {
    }

    public static double compute(double[] a, double[] b) {
        double normL2;
        if (a == null) {
            throw new IllegalArgumentException("The first parameter is null.");
        }
        if (b != null && a.length != b.length) {
            throw new IllegalArgumentException("The two vectors have different sizes.");
        }
        double c = 0.0;
        if (b == null) {
            normL2 = a[a.length - 1] * a[a.length - 1];
            int i = a.length - 1;
            while (i-- != 0) {
                double y = a[i] * a[i] - c;
                double t = normL2 + y;
                c = t - normL2 - y;
                normL2 = t;
            }
        } else {
            normL2 = (a[a.length - 1] - b[a.length - 1]) * (a[a.length - 1] - b[a.length - 1]);
            int i = a.length - 1;
            while (i-- != 0) {
                double y = (a[i] - b[i]) * (a[i] - b[i]) - c;
                double t = normL2 + y;
                c = t - normL2 - y;
                normL2 = t;
            }
        }
        return Math.sqrt(normL2);
    }

    public static double compute(double[] a) {
        return NormL2.compute(a, null);
    }

    public static double compute(int[] a, int[] b) {
        if (a == null) {
            throw new IllegalArgumentException("The first parameter is null.");
        }
        if (b != null && a.length != b.length) {
            throw new IllegalArgumentException("The two vectors have different sizes.");
        }
        double normL2 = 0.0;
        if (b == null) {
            int i = a.length;
            while (i-- != 0) {
                normL2 += (double)(a[i] * a[i]);
            }
        } else {
            int i = a.length;
            while (i-- != 0) {
                normL2 += (double)((a[i] - b[i]) * (a[i] - b[i]));
            }
        }
        return Math.sqrt(normL2);
    }

    public static double compute(int[] a) {
        return NormL2.compute(a, null);
    }

    public static void normalize(double[] v, double n) {
        if (n < 0.0) {
            throw new IllegalArgumentException("A L2 norm is always not negative.");
        }
        double sum = NormL2.compute(v);
        double c = n / sum;
        int i = v.length;
        while (i-- != 0) {
            int n2 = i;
            v[n2] = v[n2] * c;
        }
    }
}

