/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.util;

public class NormL1 {
    private NormL1() {
    }

    public static double compute(double[] a, double[] b) {
        if (a == null) {
            throw new IllegalArgumentException("The first parameter is null.");
        }
        if (b != null && a.length != b.length) {
            throw new IllegalArgumentException("The two vectors have different sizes.");
        }
        double normL1 = 0.0;
        double c = 0.0;
        if (b == null) {
            int i = a.length;
            while (i-- != 0) {
                double y = Math.abs(a[i]) - c;
                double t = normL1 + y;
                c = t - normL1 - y;
                normL1 = t;
            }
        } else {
            int i = a.length;
            while (i-- != 0) {
                double y = Math.abs(a[i] - b[i]) - c;
                double t = normL1 + y;
                c = t - normL1 - y;
                normL1 = t;
            }
        }
        return normL1;
    }

    public static double compute(double[] a) {
        return NormL1.compute(a, null);
    }

    public static int compute(int[] a, int[] b) {
        if (a == null) {
            throw new IllegalArgumentException("The first parameter is null.");
        }
        if (b != null && a.length != b.length) {
            throw new IllegalArgumentException("The two vectors have different sizes.");
        }
        int normL1 = 0;
        if (b == null) {
            int i = a.length;
            while (i-- != 0) {
                normL1 += Math.abs(a[i]);
            }
        } else {
            int i = a.length;
            while (i-- != 0) {
                normL1 += Math.abs(a[i] - b[i]);
            }
        }
        return normL1;
    }

    public static int compute(int[] a) {
        return NormL1.compute(a, null);
    }

    public static void normalize(double[] v, double n) {
        if (n < 0.0) {
            throw new IllegalArgumentException("A L1 norm is always not negative.");
        }
        double sum = NormL1.compute(v);
        double c = n / sum;
        int i = v.length;
        while (i-- != 0) {
            int n2 = i;
            v[n2] = v[n2] * c;
        }
    }
}

