/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.util;

import cern.colt.function.IntComparator;

public class ExchangeCounter {
    private final int[] temp;
    private final IntComparator c;
    private final int[] a;

    public ExchangeCounter(int[] a, IntComparator c, int[] support) {
        this.a = a;
        this.c = c;
        if (support.length < a.length) {
            throw new IllegalArgumentException("The support array length (" + support.length + ") is smaller than the main array length (" + a.length + ")");
        }
        this.temp = support;
    }

    public ExchangeCounter(int[] a, IntComparator c) {
        this(a, c, new int[a.length]);
    }

    public long count() {
        return this.count(0, this.a.length);
    }

    private long count(int offset, int length) {
        long exchanges = 0L;
        if (length == 1) {
            return 0L;
        }
        if (length == 2) {
            if (this.c.compare(this.a[offset], this.a[offset + 1]) <= 0) {
                return 0L;
            }
            int t = this.a[offset];
            this.a[offset] = this.a[offset + 1];
            this.a[offset + 1] = t;
            return 1L;
        }
        int length0 = length / 2;
        int length1 = length - length / 2;
        int middle = offset + length0;
        exchanges += this.count(offset, length0);
        exchanges += this.count(middle, length1);
        if (this.c.compare(this.a[middle - 1], this.a[middle]) < 0) {
            return exchanges;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        while (j < length0 || k < length1) {
            int d;
            if (k >= length1 || j < length0 && this.c.compare(this.a[offset + j], this.a[middle + k]) <= 0) {
                this.temp[i] = this.a[offset + j];
                d = i - j;
                ++j;
            } else {
                this.temp[i] = this.a[middle + k];
                d = offset + i - (middle + k);
                ++k;
            }
            if (d > 0) {
                exchanges += (long)d;
            }
            ++i;
        }
        System.arraycopy(this.temp, 0, this.a, offset, length);
        return exchanges;
    }
}

