/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.util;

import cern.jet.random.engine.MersenneTwister;
import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsistentHashFunction<T extends Comparable<? super T>> {
    public static final int REPLICAE_PER_BUCKET = 200;
    protected final Long2ObjectSortedMap<Object> replicae = new Long2ObjectAVLTreeMap();
    protected final ObjectSortedSet<Map.Entry<Long, Object>> entrySet = this.replicae.entrySet();
    protected final Object2IntMap<T> sizes = new Object2IntOpenHashMap();
    protected final Set<T> buckets = this.sizes.keySet();
    protected final SkipStrategy<T> skipStrategy;
    private static final boolean DEBUG = false;

    public ConsistentHashFunction() {
        this(null);
    }

    public ConsistentHashFunction(SkipStrategy<T> skipStrategy) {
        this.skipStrategy = skipStrategy;
    }

    public boolean add(T bucket, int weight) {
        if (this.sizes.containsKey(bucket)) {
            return false;
        }
        this.sizes.put(bucket, weight);
        MersenneTwister twister = new MersenneTwister(bucket.hashCode());
        for (int i = 0; i < weight * 200; ++i) {
            long point = twister.nextLong();
            Object o = this.replicae.get(point);
            if (o != null) {
                if (o == bucket) continue;
                if (o instanceof SortedSet) {
                    ((SortedSet)o).add(bucket);
                    continue;
                }
                TreeSet conflictSet = new TreeSet();
                conflictSet.add((Comparable)o);
                conflictSet.add(bucket);
                this.replicae.put(point, conflictSet);
                continue;
            }
            this.replicae.put(point, bucket);
        }
        return true;
    }

    public boolean remove(T bucket) {
        if (!this.sizes.containsKey(bucket)) {
            return false;
        }
        MersenneTwister twister = new MersenneTwister(bucket.hashCode());
        int size = this.sizes.removeInt(bucket);
        for (int i = 0; i < size * 200; ++i) {
            long point = twister.nextLong();
            Object o = this.replicae.remove(point);
            if (o instanceof SortedSet) {
                SortedSet conflictSet = (SortedSet)o;
                conflictSet.remove(bucket);
                if (conflictSet.size() > 1) {
                    this.replicae.put(point, (Object)conflictSet);
                    continue;
                }
                this.replicae.put(point, conflictSet.first());
                continue;
            }
            if (o == null || ((Comparable)o).compareTo(bucket) == 0) continue;
            this.replicae.put(point, o);
        }
        return true;
    }

    public Object[] hash(long point, int n) {
        if (n == 0 || this.buckets.size() == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet(n, 0.5f);
        ObjectBidirectionalIterator i = this.replicae.entrySet().iterator((Object)new AbstractLong2ObjectMap.BasicEntry(point, null));
        int pass = 2;
        while (pass-- != 0) {
            while (i.hasNext()) {
                Object value = ((Map.Entry)i.next()).getValue();
                if (value instanceof SortedSet) {
                    for (Comparable p : (SortedSet)value) {
                        if (this.skipStrategy != null && this.skipStrategy.isSkippable(p) || !result.add((Object)p) || --n != 0) continue;
                        return result.toArray();
                    }
                    continue;
                }
                if (this.skipStrategy != null && this.skipStrategy.isSkippable((Comparable)value) || !result.add(value) || --n != 0) continue;
                return result.toArray();
            }
            i = this.replicae.entrySet().iterator();
        }
        return result.toArray();
    }

    public Object[] hash(Object key, int n) {
        return this.hash((long)key.hashCode() << 32, n);
    }

    public T hash(long point) {
        Object[] result = this.hash(point, 1);
        if (result.length == 0) {
            throw new NoSuchElementException();
        }
        return (T)((Comparable)result[0]);
    }

    public T hash(Object key) {
        Object[] result = this.hash(key, 1);
        if (result.length == 0) {
            throw new NoSuchElementException();
        }
        return (T)((Comparable)result[0]);
    }

    public Set<T> buckets() {
        return this.buckets;
    }

    public String toString() {
        return this.replicae.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SkipStrategy<T> {
        public boolean isSkippable(T var1);
    }
}

