/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.stat;

import cern.colt.Sorting;
import cern.colt.function.IntComparator;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.law.util.ExchangeCounter;
import it.unimi.dsi.law.util.Precision;
import java.io.IOException;
import org.apache.log4j.Logger;

public class KendallTau {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final Logger LOGGER = Util.getLogger(KendallTau.class);

    KendallTau() {
    }

    public static double compute(double[] v0, double[] v1) {
        if (v0.length != v1.length) {
            throw new IllegalArgumentException("Vectors length differ: " + v0.length + ", " + v1.length);
        }
        int length = v0.length;
        if (length == 0) {
            throw new IllegalArgumentException("Kendall's \u03c4 is undefined on empty rankings");
        }
        int[] perm = new int[length];
        int i = length;
        while (i-- != 0) {
            perm[i] = i;
        }
        Sorting.quickSort((int[])perm, (int)0, (int)length, (IntComparator)new LexicographicalStableComparator(v0, v1));
        int first = 0;
        long t = 0L;
        for (i = 1; i < length; ++i) {
            if (v0[perm[first]] == v0[perm[i]] && v1[perm[first]] == v1[perm[i]]) continue;
            t += (long)(i - first) * ((long)(i - first) - 1L) / 2L;
            first = i;
        }
        LOGGER.debug((Object)("Joint ties: " + (t += (long)(i - first) * ((long)(i - first) - 1L) / 2L)));
        first = 0;
        long u = 0L;
        for (i = 1; i < length; ++i) {
            if (v0[perm[first]] == v0[perm[i]]) continue;
            u += (long)(i - first) * ((long)(i - first) - 1L) / 2L;
            first = i;
        }
        LOGGER.debug((Object)("Ties after first ordering: " + (u += (long)(i - first) * ((long)(i - first) - 1L) / 2L)));
        v0 = null;
        long exchanges = new ExchangeCounter(perm, new LexicographicalStableOneVectorComparator(v1)).count();
        LOGGER.debug((Object)("Exchanges: " + exchanges));
        first = 0;
        long v = 0L;
        for (i = 1; i < length; ++i) {
            if (v1[perm[first]] == v1[perm[i]]) continue;
            v += (long)(i - first) * ((long)(i - first) - 1L) / 2L;
            first = i;
        }
        LOGGER.debug((Object)("Ties after second ordering: " + (v += (long)(i - first) * ((long)(i - first) - 1L) / 2L)));
        long tot = (long)length * ((long)length - 1L) / 2L;
        LOGGER.debug((Object)("Combinations of order two: " + tot));
        if (tot == u && tot == v) {
            return 1.0;
        }
        return ((double)(tot - (v + u - t)) - 2.0 * (double)exchanges) / Math.sqrt((double)(tot - u) * (double)(tot - v));
    }

    public static double compute(CharSequence f0, CharSequence f1) throws IOException {
        return KendallTau.compute(f0, f1, -1, false);
    }

    public static double compute(CharSequence f0, CharSequence f1, int digits) throws IOException {
        return KendallTau.compute(f0, f1, digits, false);
    }

    public static double compute(CharSequence f0, CharSequence f1, int digits, boolean text) throws IOException {
        return KendallTau.compute(Precision.truncate(KendallTau.load(f0, text), digits), Precision.truncate(KendallTau.load(f1, text), digits));
    }

    protected static double[] load(CharSequence f, boolean text) throws IOException {
        return text ? DoubleIterators.unwrap((DoubleIterator)TextIO.asDoubleIterator((CharSequence)f)) : BinIO.loadDoubles((CharSequence)f);
    }

    public static void main(String[] arg) throws NumberFormatException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(KendallTau.class.getName(), "Computes Kendall's \u03c4 comparing two given rank files. The two files must contain the same number of doubles, written in Java binary format. If the option -t is specified, the files are assumed to be text files containing one double per line.\nIf one or more truncations are specified with the option -T, the values of Kendall's \u03c4 for the given files truncated to the given number of binary fractional digits, in the same order, will be printed to standard output.If there is more than one value, the vectors will be loaded in memory just once and copied across computations.", new Parameter[]{new Switch("text", 't', "text", "Input files are in text format."), new FlaggedOption("digits", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'T', "truncate", "Truncate inputs to the given number of binary fractional digits.").setAllowMultipleDeclarations(true), new UnflaggedOption("file0", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The first rank file."), new UnflaggedOption("file1", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The second rank file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String f0 = jsapResult.getString("file0");
        String f1 = jsapResult.getString("file1");
        boolean text = jsapResult.getBoolean("text");
        int[] digits = jsapResult.getIntArray("digits");
        if (digits.length == 0) {
            digits = new int[]{-1};
        }
        if (digits.length == 1) {
            System.out.println(KendallTau.compute(f0, f1, digits[0], text));
        } else {
            double[] v0 = KendallTau.load(f0, text);
            double[] v1 = KendallTau.load(f1, text);
            for (int d : digits) {
                System.out.println(KendallTau.compute(Precision.truncate((double[])v0.clone(), d), Precision.truncate((double[])v1.clone(), d)));
            }
        }
    }

    protected static final class LexicographicalStableOneVectorComparator
    implements IntComparator {
        private final double[] v1;

        LexicographicalStableOneVectorComparator(double[] v1) {
            this.v1 = v1;
        }

        public int compare(int x, int y) {
            double xr = this.v1[x];
            double yr = this.v1[y];
            return xr > yr ? -1 : (xr < yr ? 1 : 0);
        }
    }

    protected static final class LexicographicalStableComparator
    implements IntComparator {
        private final double[] v0;
        private final double[] v1;

        LexicographicalStableComparator(double[] v0, double[] v1) {
            this.v0 = v0;
            this.v1 = v1;
        }

        public int compare(int x, int y) {
            double xr = this.v0[x];
            double yr = this.v0[y];
            if (xr > yr) {
                return -1;
            }
            if (xr < yr) {
                return 1;
            }
            xr = this.v1[x];
            yr = this.v1[y];
            return xr > yr ? -1 : (xr < yr ? 1 : x - y);
        }
    }
}

