/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.rank;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.law.Util;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class PageRankPowerSeries {
    private static final Logger LOGGER = it.unimi.dsi.Util.getLogger(PageRankPowerSeries.class);
    private static final int BUFFER_SIZE = 0x100000;

    public static void compute(String coeffBasename, int numCoeff, String rankBasename, double[] alpha, int[] order) throws IOException {
        int i;
        int i2;
        LOGGER.info((Object)"Opening files...");
        int numDerivatives = order.length;
        int numAlphas = alpha.length;
        DoubleIterator[] coeff = new DoubleIterator[numCoeff];
        DataInputStream[] coeffStream = new DataInputStream[numCoeff];
        int i3 = numCoeff;
        while (i3-- != 0) {
            coeffStream[i3] = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(coeffBasename + "-" + i3), 0x100000));
            coeff[i3] = BinIO.asDoubleIterator((DataInput)coeffStream[i3]);
        }
        DataOutputStream[][] result = new DataOutputStream[numAlphas][numDerivatives];
        int l = numAlphas;
        while (l-- != 0) {
            i2 = numDerivatives;
            while (i2-- != 0) {
                result[l][i2] = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(rankBasename + "-" + alpha[l] + (order[i2] == 0 ? ".ranks" : ".der-" + order[i2])), 0x100000));
            }
        }
        LOGGER.info((Object)"Computing coefficients...");
        double[][][] a = new double[numAlphas][numDerivatives][numCoeff];
        i2 = numDerivatives;
        while (i2-- != 0) {
            int k = order[i2];
            int l2 = numAlphas;
            while (l2-- != 0) {
                double alphaNMinusK = 1.0;
                a[l2][i2][0] = Util.falling(0, k);
                for (int n = 1; n < numCoeff; ++n) {
                    if (n > k) {
                        alphaNMinusK *= alpha[l2];
                    }
                    a[l2][i2][n] = alphaNMinusK * Util.falling(n, k);
                }
            }
        }
        int numNodes = (int)(new File(coeffBasename + "-0").length() / 8L);
        double[][] partialSum = new double[numAlphas][numDerivatives];
        double[][] infinityNorm = new double[numAlphas][numDerivatives];
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.itemsName = "nodes";
        pl.expectedUpdates = numNodes;
        pl.start((CharSequence)"Computing PageRank and derivatives...");
        for (i = 0; i < numNodes; ++i) {
            int l3 = numAlphas;
            while (l3-- != 0) {
                DoubleArrays.fill((double[])partialSum[l3], (double)0.0);
            }
            double t = 0.0;
            for (int n = 0; n < numCoeff; ++n) {
                t = coeff[n].nextDouble();
                int l4 = numAlphas;
                while (l4-- != 0) {
                    int j = numDerivatives;
                    while (j-- != 0) {
                        double[] dArray = partialSum[l4];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + a[l4][j][n] * t;
                    }
                }
            }
            int l5 = numAlphas;
            while (l5-- != 0) {
                int j = numDerivatives;
                while (j-- != 0) {
                    infinityNorm[l5][j] = Math.max(infinityNorm[l5][j], a[l5][j][numCoeff - 1] * t);
                    result[l5][j].writeDouble(partialSum[l5][j]);
                }
            }
            pl.update();
        }
        pl.done();
        for (i = 0; i < numCoeff; ++i) {
            coeffStream[i].close();
        }
        int l6 = numAlphas;
        while (l6-- != 0) {
            for (int i4 = 0; i4 < numDerivatives; ++i4) {
                if ((double)(numCoeff - 1) < (double)order[i4] / (1.0 - alpha[l6])) {
                    LOGGER.info((Object)("Error bound for derivative of order " + order[i4] + " (alpha=" + alpha[l6] + "): unknown"));
                } else {
                    double delta = alpha[l6] * (double)(numCoeff - 1) / (double)(numCoeff - 1 + order[i4]);
                    LOGGER.info((Object)("Error bound for derivative of order " + order[i4] + " (alpha=" + alpha[l6] + "): " + infinityNorm[l6][i4] * delta / (1.0 - delta)));
                }
                result[l6][i4].close();
            }
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(PageRankPowerSeries.class.getName(), "Computes PageRank and possibly its derivatives using the coefficients of the PageRank power series (usually computed by PageRankPowerMethod).", new Parameter[]{new FlaggedOption("alpha", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(0.85), false, 'a', "alpha", "Damping factor(s), one for each desired output.").setAllowMultipleDeclarations(true), new FlaggedOption("numCoeff", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, 'n', "num-coeff", "The number of coefficients to use."), new FlaggedOption("derivative", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'd', "derivative", "The order(s) of the the derivative(s) to be computed (0 means PageRank); the orders are interpreted as a list of specifications parallel to that of the damping factors.").setAllowMultipleDeclarations(true), new UnflaggedOption("coeffBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the coefficients."), new UnflaggedOption("rankBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the resulting rank (doubles in binary form) are stored.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String coeffBasename = jsapResult.getString("coeffBasename");
        String rankBasename = jsapResult.getString("rankBasename");
        double[] alpha = jsapResult.getDoubleArray("alpha");
        int[] order = jsapResult.getIntArray("derivative");
        int numCoeff = jsapResult.getInt("numCoeff");
        PageRankPowerSeries.compute(coeffBasename, numCoeff, rankBasename, alpha, order);
    }
}

