/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.rank;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.law.Util;
import it.unimi.dsi.law.rank.PageRank;
import it.unimi.dsi.law.util.NormL1;
import it.unimi.dsi.law.util.NormL2;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.Properties;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class PageRankPowerMethod
extends PageRank {
    private static final Logger LOGGER = it.unimi.dsi.Util.getLogger(PageRankPowerMethod.class);
    public double[] previousRank = null;
    protected final ProgressLogger progressLogger;
    public int[] subset;
    public double[][] derivative;
    public int[] order = IntArrays.EMPTY_ARRAY;
    public String coeffBasename;

    public PageRankPowerMethod(ImmutableGraph g, Logger logger) {
        super(g, logger);
        this.progressLogger = new ProgressLogger(logger, "nodes");
    }

    public PageRankPowerMethod(ImmutableGraph g) {
        this(g, LOGGER);
    }

    public void init() throws IOException {
        super.init();
        if (this.start != null && (this.coeffBasename != null || this.order.length > 0)) {
            throw new IllegalArgumentException("You cannot choose a preference vector when computing coefficients or derivatives");
        }
        if (this.previousRank == null) {
            this.previousRank = new double[this.numNodes];
        }
        this.derivative = new double[this.order.length][this.subset != null ? this.subset.length : this.g.numNodes()];
        if (IntArrayList.wrap((int[])this.order).indexOf(0) != -1) {
            throw new IllegalArgumentException("You cannot compute the derivative of order 0 (use PageRank instead)");
        }
        if (this.coeffBasename != null) {
            BinIO.storeDoubles((double[])this.rank, (CharSequence)(this.coeffBasename + "-" + 0));
        }
        this.logger.info((Object)"Completed.");
    }

    public void step() throws IOException {
        double nFallingK;
        double alphak;
        int k;
        int j;
        int i;
        double[] oldRank = this.rank;
        double[] newRank = this.previousRank;
        DoubleArrays.fill((double[])newRank, (double)0.0);
        double accum = 0.0;
        this.progressLogger.expectedUpdates = this.numNodes;
        this.progressLogger.start((CharSequence)("Iteration " + ++this.iterationNumber + "..."));
        NodeIterator nodeIterator = this.g.nodeIterator();
        int n = this.numNodes;
        while (n-- != 0) {
            i = nodeIterator.nextInt();
            int outdegree = nodeIterator.outdegree();
            if (outdegree == 0 || this.buckets != null && this.buckets.get(i)) {
                accum += oldRank[i];
            } else {
                j = outdegree;
                int[] succ = nodeIterator.successorArray();
                while (j-- != 0) {
                    int n2 = succ[j];
                    newRank[n2] = newRank[n2] + oldRank[i] / (double)outdegree;
                }
            }
            this.progressLogger.update();
        }
        this.progressLogger.done();
        double accumOverNumNodes = accum / (double)this.numNodes;
        double oneOverNumNodes = 1.0 / (double)this.numNodes;
        if (this.preference != null) {
            if (this.preferentialAdjustment == null) {
                i = this.numNodes;
                while (i-- != 0) {
                    newRank[i] = this.alpha * newRank[i] + (1.0 - this.alpha) * this.preference.getDouble(i) + this.alpha * accumOverNumNodes;
                }
            } else {
                i = this.numNodes;
                while (i-- != 0) {
                    newRank[i] = this.alpha * newRank[i] + (1.0 - this.alpha) * this.preference.getDouble(i) + this.alpha * accum * this.preferentialAdjustment.getDouble(i);
                }
            }
        } else if (this.preferentialAdjustment == null) {
            i = this.numNodes;
            while (i-- != 0) {
                newRank[i] = this.alpha * newRank[i] + (1.0 - this.alpha) * oneOverNumNodes + this.alpha * accumOverNumNodes;
            }
        } else {
            i = this.numNodes;
            while (i-- != 0) {
                newRank[i] = this.alpha * newRank[i] + (1.0 - this.alpha) * oneOverNumNodes + this.alpha * accum * this.preferentialAdjustment.getDouble(i);
            }
        }
        this.rank = newRank;
        this.previousRank = oldRank;
        n = this.iterationNumber;
        if (this.subset == null) {
            for (i = 0; i < this.order.length; ++i) {
                k = this.order[i];
                alphak = Math.pow(this.alpha, k);
                nFallingK = Util.falling(n, k);
                for (j = 0; j < this.numNodes; ++j) {
                    double[] dArray = this.derivative[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + nFallingK * (this.rank[j] - this.previousRank[j]) / alphak;
                }
            }
        } else {
            for (i = 0; i < this.order.length; ++i) {
                k = this.order[i];
                alphak = Math.pow(this.alpha, k);
                nFallingK = Util.falling(n, k);
                for (int t : this.subset) {
                    double[] dArray = this.derivative[i];
                    int n4 = t;
                    dArray[n4] = dArray[n4] + nFallingK * (this.rank[t] - this.previousRank[t]) / alphak;
                }
            }
        }
        if (this.coeffBasename != null) {
            DataOutputStream coefficients = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.coeffBasename + "-" + this.iterationNumber)));
            double alphaN = Math.pow(this.alpha, n);
            for (i = 0; i < this.numNodes; ++i) {
                coefficients.writeDouble((this.rank[i] - this.previousRank[i]) / alphaN);
            }
            coefficients.close();
        }
    }

    public void stepUntil(PageRank.StoppingCriterion stoppingCriterion) throws IOException {
        super.stepUntil(stoppingCriterion);
        for (int i = 0; i < this.order.length; ++i) {
            if ((double)this.iterationNumber < (double)this.order[i] / (1.0 - this.alpha)) {
                LOGGER.info((Object)("Error bound for derivative of order " + this.order[i] + " (alpha=" + this.alpha + "): unknown"));
                continue;
            }
            int k = this.order[i];
            double delta = this.alpha * (double)this.iterationNumber / (double)(this.iterationNumber + k);
            double alphak = Math.pow(this.alpha, k);
            double nFallingK = Util.falling(this.iterationNumber, k);
            double infinityNorm = 0.0;
            for (int j = 0; j < this.numNodes; ++j) {
                infinityNorm = Math.max(infinityNorm, nFallingK * (this.rank[j] - this.previousRank[j]) / alphak);
            }
            LOGGER.info((Object)("Error bound for derivative of order " + k + " (alpha=" + this.alpha + "): " + infinityNorm * delta / (1.0 - delta)));
        }
    }

    public double normDelta() {
        double delta = 0.0;
        switch (this.norm) {
            case L1: {
                delta = NormL1.compute(this.rank, this.previousRank);
                break;
            }
            case L2: {
                delta = NormL2.compute(this.rank, this.previousRank);
                break;
            }
            case INFTY: {
                int i = this.rank.length;
                while (i-- != 0) {
                    double d = Math.abs(this.rank[i] - this.previousRank[i]);
                    if (!(d > delta)) continue;
                    delta = d;
                }
                break;
            }
        }
        this.logger.debug((Object)("Current " + (Object)((Object)this.norm) + "-norm: " + delta));
        return delta;
    }

    public void clear() {
        super.clear();
        this.previousRank = null;
    }

    public static void main(String[] arg) throws IOException, JSAPException, ConfigurationException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(PageRankPowerMethod.class.getName(), "Computes PageRank of a graph with given graphBasename using the power method.The resulting doubles are stored in binary form in rankFile.\n[STOPPING CRITERION] The computation is stopped as soon as two successive iterates havean L2-distance smaller than a given threshold (-t option); in any case no more than a fixednumber of iterations (-i option) is performed.", new Parameter[]{new FlaggedOption("alpha", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(0.85), false, 'a', "alpha", "Damping factor."), new FlaggedOption("maxIter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(Integer.MAX_VALUE), false, 'i', "max-iter", "Maximum number of iterations."), new FlaggedOption("threshold", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(1.0E-6), false, 't', "threshold", "Threshold to determine whether to stop."), new FlaggedOption("coeff", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "coeff", "Save the k-th coefficient of the Taylor polynomial using this basename."), new FlaggedOption("derivative", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'd', "derivative", "The order(s) of the the derivative(s) to be computed (>0).").setAllowMultipleDeclarations(true), new FlaggedOption("preferenceVector", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "preference-vector", "A preference vector stored as a vector of binary doubles."), new FlaggedOption("preferenceObject", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'P', "preference-object", "A preference vector stored as a serialised DoubleList."), new FlaggedOption("startFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, '1', "start", "Start vector filename."), new FlaggedOption("buckets", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'b', "buckets", "The buckets of the graph; if supplied, buckets will be treated as dangling nodes."), new Switch("offline", 'o', "offline", "use loadOffline() to load the graph"), new Switch("strongly", 'S', "strongly", "use the preference vector to redistribute the dangling rank."), new Switch("sortedRank", 's', "sorted-ranks", "Store the ranks (from highest to lowest) into <rankBasename>-sorted.ranks."), new FlaggedOption("norm", (StringParser)JSAP.STRING_PARSER, PageRank.Norm.INFTY.toString(), false, 'n', "norm", "Norm type. Possible values: " + Arrays.toString((Object[])PageRank.Norm.values())), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("rankBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the resulting rank (doubles in binary form) are stored.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean offline = jsapResult.getBoolean("offline", false);
        boolean strongly = jsapResult.getBoolean("strongly", false);
        boolean sorted = jsapResult.getBoolean("sortedRank", false);
        int[] order = jsapResult.getIntArray("derivative");
        String graphBasename = jsapResult.getString("graphBasename");
        String rankBasename = jsapResult.getString("rankBasename");
        String buckets = jsapResult.getString("buckets");
        String startFilename = jsapResult.getString("startFilename", null);
        String coeffBasename = jsapResult.getString("coeff");
        String norm = jsapResult.getString("norm");
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        ImmutableGraph graph = offline ? ImmutableGraph.loadOffline((CharSequence)graphBasename, (ProgressLogger)progressLogger) : ImmutableGraph.loadSequential((CharSequence)graphBasename, (ProgressLogger)progressLogger);
        DoubleArrayList preference = null;
        String preferenceFilename = null;
        if (jsapResult.userSpecified("preferenceVector")) {
            preferenceFilename = jsapResult.getString("preferenceVector");
            preference = DoubleArrayList.wrap((double[])BinIO.loadDoubles((CharSequence)preferenceFilename));
        }
        if (jsapResult.userSpecified("preferenceObject")) {
            if (jsapResult.userSpecified("preferenceVector")) {
                throw new IllegalArgumentException("You cannot specify twice the preference vector");
            }
            preferenceFilename = jsapResult.getString("preferenceObject");
            preference = (DoubleList)BinIO.loadObject((CharSequence)preferenceFilename);
        }
        if (strongly && preference == null) {
            throw new IllegalArgumentException("The 'strongly' option requires a preference vector");
        }
        DoubleArrayList start = null;
        if (startFilename != null) {
            LOGGER.debug((Object)("Loading start vector \"" + startFilename + "\"..."));
            start = DoubleArrayList.wrap((double[])BinIO.loadDoubles((CharSequence)startFilename));
            LOGGER.debug((Object)"done.");
        }
        PageRankPowerMethod pr = new PageRankPowerMethod(graph);
        pr.alpha = jsapResult.getDouble("alpha");
        pr.preference = preference;
        pr.buckets = (BitSet)(buckets == null ? null : BinIO.loadObject((CharSequence)buckets));
        pr.stronglyPreferential = strongly;
        pr.start = start;
        pr.norm = PageRank.Norm.valueOf(norm);
        pr.order = (int[])(order != null ? order : null);
        pr.coeffBasename = coeffBasename;
        pr.stepUntil(PageRankPowerMethod.or(new PageRank.NormDeltaStoppingCriterion(jsapResult.getDouble("threshold")), new PageRank.IterationNumberStoppingCriterion(jsapResult.getInt("maxIter"))));
        System.err.print("Saving ranks...");
        BinIO.storeDoubles((double[])pr.rank, (CharSequence)(rankBasename + ".ranks"));
        Properties prop = pr.buildProperties(graphBasename, preferenceFilename, startFilename);
        prop.save(rankBasename + ".properties");
        if (pr.order != null) {
            System.err.print("Saving derivatives...");
            for (int i = 0; i < order.length; ++i) {
                BinIO.storeDoubles((double[])pr.derivative[i], (CharSequence)(rankBasename + ".der-" + order[i]));
            }
        }
        double[] rank = pr.rank;
        pr = null;
        graph = null;
        if (sorted) {
            System.err.print("Sorting ranks...");
            Arrays.sort(rank);
            int n = rank.length;
            int i = n / 2;
            while (i-- != 0) {
                double t = rank[i];
                rank[i] = rank[n - i - 1];
                rank[n - i - 1] = t;
            }
            System.err.print(" saving sorted ranks...");
            BinIO.storeDoubles((double[])rank, (CharSequence)(rankBasename + "-sorted.ranks"));
            System.err.println(" done.");
        }
    }
}

