/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.rank;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.law.rank.PageRank;
import it.unimi.dsi.law.util.NormL2;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.Properties;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class PageRankJacobi
extends PageRank {
    private static final Logger LOGGER = Util.getLogger(PageRankJacobi.class);
    public double[] previousRank = null;
    private double[] pseudoDiagonal = null;
    private final ProgressLogger progressLogger;

    protected PageRankJacobi(ImmutableGraph g, Logger logger) {
        super(g, logger);
        this.progressLogger = new ProgressLogger(logger, "nodes");
    }

    public PageRankJacobi(ImmutableGraph g) {
        this(g, LOGGER);
    }

    public void init() throws IOException {
        super.init();
        if (this.previousRank == null) {
            this.previousRank = new double[this.numNodes];
        }
        if (this.pseudoDiagonal == null) {
            this.pseudoDiagonal = new double[this.numNodes];
        }
        double oneMinusAlphaOverN = 1.0 - this.alpha / (double)this.numNodes;
        NodeIterator nodeIterator = this.g.nodeIterator();
        while (nodeIterator.hasNext()) {
            int i = nodeIterator.nextInt();
            int outdegree = nodeIterator.outdegree();
            if (outdegree == 0) {
                this.pseudoDiagonal[i] = -(this.preferentialAdjustment == null ? oneMinusAlphaOverN : 1.0 - this.alpha * this.preferentialAdjustment.getDouble(i));
                continue;
            }
            int j = outdegree;
            int[] succ = nodeIterator.successorArray();
            while (j-- != 0 && succ[j] != i) {
            }
            this.pseudoDiagonal[i] = j != -1 ? 1.0 - this.alpha / (double)outdegree : 1.0;
        }
        this.logger.info((Object)"Completed.");
    }

    public void step() {
        int i;
        double[] oldRank = this.rank;
        double[] newRank = this.previousRank;
        DoubleArrays.fill((double[])newRank, (double)0.0);
        double accum = 0.0;
        this.progressLogger.expectedUpdates = this.numNodes;
        this.progressLogger.start((CharSequence)("Iteration Jacobi " + ++this.iterationNumber + "..."));
        NodeIterator nodeIterator = this.g.nodeIterator();
        int n = this.numNodes;
        while (n-- != 0) {
            i = nodeIterator.nextInt();
            int outdegree = nodeIterator.outdegree();
            if (outdegree == 0) {
                accum += oldRank[i];
            } else {
                int j = outdegree;
                int[] succ = nodeIterator.successorArray();
                while (j-- != 0) {
                    if (succ[j] == i) continue;
                    int n2 = succ[j];
                    newRank[n2] = newRank[n2] + oldRank[i] / (double)outdegree;
                }
            }
            this.progressLogger.update();
        }
        this.progressLogger.done();
        i = this.numNodes;
        if (this.preference == null) {
            double oneMinusAlphaOverNumNodes = (1.0 - this.alpha) / (double)this.numNodes;
            if (this.preferentialAdjustment == null) {
                while (i-- != 0) {
                    newRank[i] = this.pseudoDiagonal[i] < 0.0 ? (oneMinusAlphaOverNumNodes + this.alpha * (newRank[i] + (accum - oldRank[i]) / (double)this.numNodes)) / -this.pseudoDiagonal[i] : (oneMinusAlphaOverNumNodes + this.alpha * (newRank[i] + accum / (double)this.numNodes)) / this.pseudoDiagonal[i];
                }
            } else {
                while (i-- != 0) {
                    newRank[i] = this.pseudoDiagonal[i] < 0.0 ? (oneMinusAlphaOverNumNodes + this.alpha * (newRank[i] + (accum - oldRank[i]) * this.preferentialAdjustment.getDouble(i))) / -this.pseudoDiagonal[i] : (oneMinusAlphaOverNumNodes + this.alpha * (newRank[i] + accum * this.preferentialAdjustment.getDouble(i))) / this.pseudoDiagonal[i];
                }
            }
        } else {
            double oneMinusAlpha = 1.0 - this.alpha;
            if (this.preferentialAdjustment == null) {
                while (i-- != 0) {
                    newRank[i] = this.pseudoDiagonal[i] < 0.0 ? (oneMinusAlpha * this.preference.getDouble(i) + this.alpha * (newRank[i] + (accum - oldRank[i]) / (double)this.numNodes)) / -this.pseudoDiagonal[i] : (oneMinusAlpha * this.preference.getDouble(i) + this.alpha * (newRank[i] + accum / (double)this.numNodes)) / this.pseudoDiagonal[i];
                }
            } else {
                while (i-- != 0) {
                    newRank[i] = this.pseudoDiagonal[i] < 0.0 ? (oneMinusAlpha * this.preference.getDouble(i) + this.alpha * (newRank[i] + (accum - oldRank[i]) * this.preferentialAdjustment.getDouble(i))) / -this.pseudoDiagonal[i] : (oneMinusAlpha * this.preference.getDouble(i) + this.alpha * (newRank[i] + accum * this.preferentialAdjustment.getDouble(i))) / this.pseudoDiagonal[i];
                }
            }
        }
        this.rank = newRank;
        this.previousRank = oldRank;
    }

    public double normDelta() {
        return NormL2.compute(this.rank, this.previousRank);
    }

    public void clear() {
        super.clear();
        this.previousRank = null;
    }

    public static void main(String[] arg) throws IOException, JSAPException, ConfigurationException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(PageRankJacobi.class.getName(), "Computes PageRank of a graph using the Jacobi method.The resulting doubles are stored in binary form in rankFile.\n[STOPPING CRITERION] The computation is stopped as soon as two successive iterates havean L2-distance smaller than a given threshold (-t option); in any case no more than a fixednumber of iterations (-i option) is performed.", new Parameter[]{new FlaggedOption("alpha", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(0.85), false, 'a', "alpha", "Damping factor."), new FlaggedOption("maxIter", (StringParser)JSAP.INTEGER_PARSER, Double.toString(2.147483647E9), false, 'i', "max-iter", "Maximum number of iterations."), new FlaggedOption("threshold", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(1.0E-6), false, 't', "threshold", "Threshold to determine whether to stop."), new FlaggedOption("preferenceVector", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "preference-vector", "A preference vector stored as a vector of binary doubles."), new FlaggedOption("preferenceObject", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'P', "preference-object", "A preference vector stored as a serialised DoubleList."), new FlaggedOption("startFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, '1', "start", "Start vector filename."), new FlaggedOption("norm", (StringParser)JSAP.STRING_PARSER, PageRank.Norm.L1.toString(), false, 'n', "norm", "Norm type. Possible values: " + Arrays.toString((Object[])PageRank.Norm.values())), new Switch("offline", 'o', "offline", "use loadOffline() to load the graph."), new Switch("strongly", 'S', "strongly", "use the preference vector to redistribute the dangling rank."), new Switch("sortedRank", 's', "sorted-ranks", "Store the ranks (from highest to lowest) into <rankBasename>-sorted.ranks."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename the graph."), new UnflaggedOption("rankBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the resulting rank (doubles in binary form) are stored.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean offline = jsapResult.getBoolean("offline", false);
        boolean strongly = jsapResult.getBoolean("strongly", false);
        boolean sorted = jsapResult.getBoolean("sortedRank", false);
        String graphBasename = jsapResult.getString("graphBasename");
        String rankBasename = jsapResult.getString("rankBasename");
        String startFilename = jsapResult.getString("startFilename", null);
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        ImmutableGraph graph = offline ? ImmutableGraph.loadOffline((CharSequence)graphBasename, (ProgressLogger)progressLogger) : ImmutableGraph.loadSequential((CharSequence)graphBasename, (ProgressLogger)progressLogger);
        DoubleArrayList preference = null;
        String preferenceFilename = null;
        if (jsapResult.userSpecified("preferenceVector")) {
            preferenceFilename = jsapResult.getString("preferenceVector");
            preference = DoubleArrayList.wrap((double[])BinIO.loadDoubles((CharSequence)preferenceFilename));
        }
        if (jsapResult.userSpecified("preferenceObject")) {
            if (jsapResult.userSpecified("preferenceVector")) {
                throw new IllegalArgumentException("You cannot specify twice the preference vector");
            }
            preferenceFilename = jsapResult.getString("preferenceObject");
            preference = (DoubleList)BinIO.loadObject((CharSequence)preferenceFilename);
        }
        if (strongly && preference == null) {
            throw new IllegalArgumentException("The 'strongly' option requires a preference vector");
        }
        DoubleArrayList start = null;
        if (startFilename != null) {
            LOGGER.debug((Object)("Loading start vector \"" + startFilename + "\"..."));
            start = DoubleArrayList.wrap((double[])BinIO.loadDoubles((CharSequence)startFilename));
            LOGGER.debug((Object)"done.");
        }
        PageRankJacobi pr = new PageRankJacobi(graph);
        pr.alpha = jsapResult.getDouble("alpha");
        pr.preference = preference;
        pr.stronglyPreferential = strongly;
        pr.start = start;
        pr.norm = PageRank.Norm.valueOf(jsapResult.getString("norm"));
        pr.stepUntil(PageRankJacobi.or(new PageRank.NormDeltaStoppingCriterion(jsapResult.getDouble("threshold")), new PageRank.IterationNumberStoppingCriterion(jsapResult.getInt("maxIter"))));
        System.err.print("Saving ranks...");
        BinIO.storeDoubles((double[])pr.rank, (CharSequence)(rankBasename + ".ranks"));
        Properties prop = pr.buildProperties(graphBasename, preferenceFilename, startFilename);
        prop.save(rankBasename + ".properties");
        double[] rank = pr.rank;
        pr = null;
        graph = null;
        if (sorted) {
            System.err.print("Sorting ranks...");
            Arrays.sort(rank);
            int n = rank.length;
            int i = n / 2;
            while (i-- != 0) {
                double t = rank[i];
                rank[i] = rank[n - i - 1];
                rank[n - i - 1] = t;
            }
            System.err.print(" saving sorted ranks...");
            BinIO.storeDoubles((double[])rank, (CharSequence)(rankBasename + "-sorted.ranks"));
            System.err.println(" done.");
        }
    }
}

