/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.rank;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.law.rank.PageRank;
import it.unimi.dsi.law.util.NormL1;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.Properties;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class PageRankGaussSeidel
extends PageRank {
    private static final Logger LOGGER = Util.getLogger(PageRankGaussSeidel.class);
    private double danglingRank;
    private boolean pseudoRank;
    private double delta;
    private int[] outdegree;
    private final ProgressLogger progressLogger;

    protected PageRankGaussSeidel(ImmutableGraph gTransposed, Logger logger) {
        super(gTransposed, logger);
        this.progressLogger = new ProgressLogger(logger, "nodes");
    }

    public PageRankGaussSeidel(ImmutableGraph gTransposed) {
        this(gTransposed, LOGGER);
    }

    public void clear() {
        this.rank = null;
        this.danglingRank = 0.0;
    }

    public void init() throws IOException {
        super.init();
        if (this.outdegree == null) {
            this.outdegree = new int[this.numNodes];
            this.progressLogger.expectedUpdates = this.numNodes;
            this.progressLogger.start((CharSequence)"Computing outdegrees...");
            NodeIterator nodeIterator = this.g.nodeIterator();
            int i = this.numNodes;
            while (i-- != 0) {
                nodeIterator.nextInt();
                int[] pred = nodeIterator.successorArray();
                int d = nodeIterator.outdegree();
                while (d-- != 0) {
                    int n = pred[d];
                    this.outdegree[n] = this.outdegree[n] + 1;
                }
                this.progressLogger.update();
            }
            this.progressLogger.done();
        }
        this.progressLogger.expectedUpdates = this.numNodes;
        this.progressLogger.start((CharSequence)"Computing initial dangling rank...");
        this.danglingRank = 0.0;
        int nDanglingNodes = 0;
        int i = this.numNodes;
        while (i-- != 0) {
            if (this.outdegree[i] != 0 && (this.buckets == null || !this.buckets.get(i))) continue;
            this.danglingRank += this.rank[i];
            if (this.outdegree[i] != 0) continue;
            ++nDanglingNodes;
        }
        this.progressLogger.done();
        this.logger.info((Object)(nDanglingNodes + " dangling nodes"));
        if (this.buckets != null) {
            this.logger.info((Object)(this.buckets.cardinality() + " buckets"));
        }
        this.logger.info((Object)("Initial dangling Rank: " + this.danglingRank));
        this.logger.info((Object)"Initialization completed.");
    }

    public double normDelta() {
        return this.delta;
    }

    public void step() {
        double oneMinusAlpha = 1.0 - this.alpha;
        double oneMinusAlphaOverNumNodes = oneMinusAlpha / (double)this.numNodes;
        NodeIterator nodeIterator = this.g.nodeIterator();
        int n = this.numNodes;
        double B = 0.0;
        double A = this.danglingRank;
        this.progressLogger.expectedUpdates = this.numNodes;
        this.progressLogger.start((CharSequence)("Iteration GS " + ++this.iterationNumber + "..."));
        this.delta = 0.0;
        while (n-- != 0) {
            double selfLoopFactor;
            double selfDanglingRank;
            int i = nodeIterator.nextInt();
            int inDegree = nodeIterator.outdegree();
            int[] pred = nodeIterator.successorArray();
            double sigma = 0.0;
            boolean hasLoop = false;
            int j = inDegree;
            while (j-- != 0) {
                int currPred = pred[j];
                if (this.buckets != null && this.buckets.get(pred[j])) continue;
                if (i == currPred) {
                    hasLoop = true;
                    continue;
                }
                sigma += this.rank[currPred] / (double)this.outdegree[currPred];
            }
            if (this.outdegree[i] == 0 || this.buckets != null && this.buckets.get(i)) {
                selfDanglingRank = this.rank[i];
                selfLoopFactor = this.pseudoRank ? 1.0 : (this.preferentialAdjustment != null ? 1.0 - this.alpha * this.preferentialAdjustment.getDouble(i) : 1.0 - this.alpha / (double)this.numNodes);
            } else {
                selfDanglingRank = 0.0;
                double d = selfLoopFactor = hasLoop ? 1.0 - this.alpha / (double)this.outdegree[i] : 1.0;
            }
            sigma += this.pseudoRank ? 0.0 : (this.preferentialAdjustment != null ? (B + A - selfDanglingRank) * this.preferentialAdjustment.getDouble(i) : (B + A - selfDanglingRank) / (double)this.numNodes);
            double d = sigma = this.preference != null ? (oneMinusAlpha * this.preference.getDouble(i) + this.alpha * sigma) / selfLoopFactor : (oneMinusAlphaOverNumNodes + this.alpha * sigma) / selfLoopFactor;
            if (this.outdegree[i] == 0 || this.buckets != null && this.buckets.get(i)) {
                B += sigma;
                A -= this.rank[i];
            }
            switch (this.norm) {
                case L1: {
                    this.delta += Math.abs(sigma - this.rank[i]);
                    break;
                }
                case L2: {
                    this.delta += (sigma - this.rank[i]) * (sigma - this.rank[i]);
                    break;
                }
                case INFTY: {
                    double d2 = Math.abs(sigma - this.rank[i]);
                    if (!(d2 > this.delta)) break;
                    this.delta = d2;
                }
            }
            this.rank[i] = sigma;
            this.progressLogger.update();
        }
        this.progressLogger.done();
        this.danglingRank = B;
        if (this.norm == PageRank.Norm.L2) {
            this.delta = Math.sqrt(this.delta);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("The rank L1 norm is " + NormL1.compute(this.rank)));
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException, ConfigurationException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(PageRankGaussSeidel.class.getName(), "Computes PageRank of a graph, given the transpose of the graph. The resulting doubles are stored in binary form in <rankFile>.\n\n[STOPPING CRITERION] The computation is stopped as soon as two successive iterates have a norm (-n option) distance smaller than a given threshold (-t option); in any case no more than a fixed number of iterations (-i option) is performed.", new Parameter[]{new FlaggedOption("alpha", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(0.85), false, 'a', "alpha", "Damping factor."), new FlaggedOption("maxIter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(Integer.MAX_VALUE), false, 'i', "max-iter", "Maximum number of iterations."), new FlaggedOption("threshold", (StringParser)JSAP.DOUBLE_PARSER, Double.toString(1.0E-6), false, 't', "threshold", "Threshold to determine whether to stop."), new FlaggedOption("preferenceVector", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "preference-vector", "A preference vector stored as a vector of binary doubles."), new FlaggedOption("preferenceObject", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'P', "preference-object", "A preference vector stored as a serialised DoubleList."), new FlaggedOption("startFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, '1', "start", "Start vector filename."), new FlaggedOption("norm", (StringParser)JSAP.STRING_PARSER, PageRank.Norm.L1.toString(), false, 'n', "norm", "Norm type. Possible values: " + Arrays.toString((Object[])PageRank.Norm.values())), new Switch("pseudoRank", '\u0000', "pseudorank", "Compute pseudoranks (the dangling preference is set to 0)."), new FlaggedOption("buckets", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'b', "buckets", "The buckets of the graph; if supplied, buckets will be treated as dangling nodes."), new Switch("offline", 'o', "offline", "Use loadOffline() to load the graph."), new Switch("strongly", 'S', "strongly", "Use the preference vector to redistribute the dangling rank."), new Switch("sortedRank", 's', "sorted-ranks", "Store the ranks (from highest to lowest) into <rankBasename>-sorted.ranks."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the transpose of the graph."), new UnflaggedOption("rankBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename where the results are stored. <rankBasename>.properties contains the parameter values used in the computation. <rankBasename>.ranks contains ranks (doubles in binary form).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean offline = jsapResult.getBoolean("offline", false);
        boolean strongly = jsapResult.getBoolean("strongly", false);
        boolean sorted = jsapResult.getBoolean("sortedRank", false);
        String buckets = jsapResult.getString("buckets");
        String graphBasename = jsapResult.getString("graphBasename");
        String rankBasename = jsapResult.getString("rankBasename");
        String startFilename = jsapResult.getString("startFilename", null);
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        ImmutableGraph graph = null;
        graph = offline ? ImmutableGraph.loadOffline((CharSequence)graphBasename, (ProgressLogger)progressLogger) : ImmutableGraph.loadSequential((CharSequence)graphBasename, (ProgressLogger)progressLogger);
        DoubleArrayList preference = null;
        String preferenceFilename = null;
        if (jsapResult.userSpecified("preferenceVector")) {
            preferenceFilename = jsapResult.getString("preferenceVector");
            preference = DoubleArrayList.wrap((double[])BinIO.loadDoubles((CharSequence)preferenceFilename));
        }
        if (jsapResult.userSpecified("preferenceObject")) {
            if (jsapResult.userSpecified("preferenceVector")) {
                throw new IllegalArgumentException("You cannot specify twice the preference vector");
            }
            preferenceFilename = jsapResult.getString("preferenceObject");
            preference = (DoubleList)BinIO.loadObject((CharSequence)preferenceFilename);
        }
        if (strongly && preference == null) {
            throw new IllegalArgumentException("The 'strongly' option requires a preference vector");
        }
        DoubleArrayList start = null;
        if (startFilename != null) {
            LOGGER.debug((Object)("Loading start vector \"" + startFilename + "\"..."));
            start = DoubleArrayList.wrap((double[])BinIO.loadDoubles((CharSequence)startFilename));
            LOGGER.debug((Object)"done.");
        }
        PageRankGaussSeidel pr = new PageRankGaussSeidel(graph);
        pr.alpha = jsapResult.getDouble("alpha");
        pr.preference = preference;
        pr.start = start;
        pr.buckets = (BitSet)(buckets == null ? null : BinIO.loadObject((CharSequence)buckets));
        pr.stronglyPreferential = strongly;
        pr.norm = PageRank.Norm.valueOf(jsapResult.getString("norm"));
        pr.pseudoRank = jsapResult.getBoolean("pseudoRank");
        pr.stepUntil(PageRankGaussSeidel.or(new PageRank.NormDeltaStoppingCriterion(jsapResult.getDouble("threshold")), new PageRank.IterationNumberStoppingCriterion(jsapResult.getInt("maxIter"))));
        System.err.print("Saving ranks...");
        BinIO.storeDoubles((double[])pr.rank, (CharSequence)(rankBasename + ".ranks"));
        Properties prop = pr.buildProperties(graphBasename, preferenceFilename, startFilename);
        prop.save(rankBasename + ".properties");
        System.err.println(" done.");
        double[] rank = pr.rank;
        pr = null;
        graph = null;
        if (sorted) {
            System.err.print("Sorting ranks...");
            Arrays.sort(rank);
            int n = rank.length;
            int i = n / 2;
            while (i-- != 0) {
                double t = rank[i];
                rank[i] = rank[n - i - 1];
                rank[n - i - 1] = t;
            }
            System.err.print(" saving sorted ranks...");
            BinIO.storeDoubles((double[])rank, (CharSequence)(rankBasename + "-sorted.ranks"));
            System.err.println(" done.");
        }
    }
}

