/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.rank;

import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.util.Properties;
import it.unimi.dsi.webgraph.ImmutableGraph;
import java.io.IOException;
import java.util.BitSet;
import org.apache.log4j.Logger;

public abstract class PageRank {
    public static final int DEFAULT_MAX_ITER = Integer.MAX_VALUE;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final double STOCHASTIC_TOLERANCE = 1.0E-6;
    public static final double DEFAULT_ALPHA = 0.85;
    public double alpha = 0.85;
    public DoubleList preference;
    public DoubleList start;
    public DoubleList preferentialAdjustment;
    protected final ImmutableGraph g;
    protected final int numNodes;
    protected BitSet buckets;
    public double[] rank;
    public int iterationNumber;
    public boolean stronglyPreferential;
    public Norm norm = Norm.L1;
    protected final Logger logger;

    public PageRank(ImmutableGraph g, Logger logger) {
        this.g = g;
        this.logger = logger;
        this.numNodes = g.numNodes();
        logger.info((Object)("Graph dimension = " + this.numNodes));
    }

    public static StoppingCriterion and(final StoppingCriterion stop1, final StoppingCriterion stop2) {
        return new StoppingCriterion(){

            public boolean shouldStop(PageRank p) {
                return stop1.shouldStop(p) && stop2.shouldStop(p);
            }
        };
    }

    public static StoppingCriterion or(final StoppingCriterion stop1, final StoppingCriterion stop2) {
        return new StoppingCriterion(){

            public boolean shouldStop(PageRank p) {
                return stop1.shouldStop(p) || stop2.shouldStop(p);
            }
        };
    }

    protected static boolean isStochastic(DoubleList v) {
        double normL1 = 0.0;
        double c = 0.0;
        int i = v.size();
        while (i-- != 0 && v.getDouble(i) >= 0.0) {
            double y = v.getDouble(i) - c;
            double t = normL1 + y;
            c = t - normL1 - y;
            normL1 = t;
        }
        return i == -1 && Math.abs(normL1 - 1.0) <= 1.0E-6;
    }

    public Properties buildProperties(String graphBasename, String preferenceFilename, String startFilename) {
        Properties prop = new Properties();
        prop.addProperty("rank.alpha", (Object)Double.toString(this.alpha));
        prop.addProperty("rank.stronglyPreferential", this.stronglyPreferential);
        prop.addProperty("method.numberOfIterations", this.iterationNumber);
        prop.addProperty("method.norm.type", (Object)this.norm);
        prop.addProperty("method.norm.value", (Object)Double.toString(this.normDelta()));
        prop.addProperty("graph.nodes", this.numNodes);
        prop.addProperty("graph.fileName", (Object)graphBasename);
        prop.addProperty("preference.fileName", (Object)preferenceFilename);
        prop.addProperty("start.fileName", (Object)startFilename);
        return prop;
    }

    public void init() throws IOException {
        this.logger.info((Object)"Initialising...");
        this.logger.info((Object)("alpha = " + this.alpha));
        this.logger.info((Object)("norm type = " + (Object)((Object)this.norm)));
        this.iterationNumber = 0;
        if (this.rank == null) {
            this.rank = new double[this.numNodes];
        }
        if (this.start != null) {
            if (!PageRank.isStochastic(this.start)) {
                throw new IllegalArgumentException("The start vector is not a stochastic vector.");
            }
            this.start.toDoubleArray(this.rank);
        } else if (this.preference != null) {
            this.preference.toDoubleArray(this.rank);
        } else {
            DoubleArrays.fill((double[])this.rank, (double)(1.0 / (double)this.numNodes));
        }
        this.logger.info((Object)("There is a start vector = " + (this.start != null)));
        if (this.preference != null) {
            if (this.preference.size() != this.numNodes) {
                throw new IllegalArgumentException("The preference vector size (" + this.preference.size() + ") is different from graph dimension (" + this.numNodes + ").");
            }
            if (!PageRank.isStochastic(this.preference)) {
                throw new IllegalArgumentException("The preference vector is not a stochastic vector. ");
            }
        }
        this.logger.info((Object)("There is a preference vector = " + (this.preference != null)));
        if (this.stronglyPreferential) {
            if (this.preference == null) {
                throw new IllegalArgumentException("The strongly flag is true but the preference vector is null.");
            }
            this.preferentialAdjustment = this.preference;
        } else {
            this.preferentialAdjustment = null;
        }
        this.logger.info((Object)("Strongly preferential = " + this.stronglyPreferential));
    }

    public abstract void step() throws IOException;

    public double normDelta() {
        throw new UnsupportedOperationException();
    }

    public void stepUntil(StoppingCriterion stoppingCriterion) throws IOException {
        this.init();
        do {
            this.step();
        } while (!stoppingCriterion.shouldStop(this));
        this.logger.info((Object)"Computation completed.");
    }

    public void clear() {
        this.rank = null;
    }

    public static class NormDeltaStoppingCriterion
    implements StoppingCriterion {
        private double threshold;

        public NormDeltaStoppingCriterion(double threshold) {
            this.threshold = threshold;
        }

        public boolean shouldStop(PageRank p) {
            p.logger.info((Object)("Current delta norm: " + p.normDelta() + " (will stop below " + this.threshold + ")"));
            return p.normDelta() < this.threshold;
        }
    }

    public static class IterationNumberStoppingCriterion
    implements StoppingCriterion {
        private int maxIter;

        public IterationNumberStoppingCriterion(int maxIter) {
            this.maxIter = maxIter;
        }

        public boolean shouldStop(PageRank p) {
            if (this.maxIter == Integer.MAX_VALUE) {
                return false;
            }
            p.logger.info((Object)("Iterations performed: " + p.iterationNumber + " (will stop after " + this.maxIter + ")"));
            return p.iterationNumber >= this.maxIter;
        }
    }

    public static interface StoppingCriterion {
        public boolean shouldStop(PageRank var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Norm {
        L1{

            public double compute(double[] v) {
                double s = 0.0;
                int i = v.length;
                while (i-- != 0) {
                    s += Math.abs(v[i]);
                }
                return s;
            }
        }
        ,
        L2{

            public double compute(double[] v) {
                double s = 0.0;
                int i = v.length;
                while (i-- != 0) {
                    double t = Math.abs(v[i]);
                    s += t * t;
                }
                return Math.sqrt(s);
            }
        }
        ,
        INFTY{

            public double compute(double[] v) {
                double s = 0.0;
                int i = v.length;
                while (i-- != 0) {
                    double t = Math.abs(v[i]);
                    if (!(t > s)) continue;
                    s = t;
                }
                return s;
            }
        };


        public abstract double compute(double[] var1);
    }
}

