/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.law.rank;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class GeneralHyperbolicRank {
    private static final Logger LOGGER = Util.getLogger(GeneralHyperbolicRank.class);
    public double[] rank = null;
    public double[] r;
    public double[] rprime;
    public ImmutableGraph graph;
    public int numNodes;
    public double[] preference;
    public double residual;
    public int iteration;
    public double beta;
    private ProgressLogger pl;

    public GeneralHyperbolicRank(ImmutableGraph graph, double[] preference, double beta, ProgressLogger pl) {
        this.graph = graph;
        this.numNodes = graph.numNodes();
        this.preference = preference;
        this.beta = beta;
        this.pl = pl;
        if (beta <= 1.0) {
            throw new IllegalArgumentException("Beta must be larger than 1");
        }
    }

    public void init() {
        if (this.rank == null) {
            this.rank = new double[this.numNodes];
            this.r = new double[this.numNodes];
            this.rprime = new double[this.numNodes];
        }
        NodeIterator it = this.graph.nodeIterator();
        this.residual = 0.0;
        if (this.pl != null) {
            this.pl.itemsName = "nodes";
            this.pl.expectedUpdates = this.numNodes;
            this.pl.start((CharSequence)"Initializing");
        }
        while (it.hasNext()) {
            if (this.pl != null) {
                this.pl.update();
            }
            int i = it.nextInt();
            this.rank[i] = this.preference == null ? 1.0 / (double)this.numNodes : this.preference[i];
            this.r[i] = this.rank[i];
            if (it.outdegree() != 0) continue;
            this.residual += this.r[i];
        }
        if (this.pl != null) {
            this.pl.done();
        }
        this.iteration = 0;
    }

    public void clear() {
    }

    public void step() {
        int j;
        ++this.iteration;
        Arrays.fill(this.rprime, 0.0);
        NodeIterator jt = this.graph.nodeIterator();
        if (this.pl != null) {
            this.pl.itemsName = "nodes";
            this.pl.expectedUpdates = this.numNodes;
            this.pl.start((CharSequence)"Step (1st phase)");
        }
        while (jt.hasNext()) {
            if (this.pl != null) {
                this.pl.update();
            }
            j = jt.nextInt();
            int d = jt.outdegree();
            IntIterator it = LazyIntIterators.eager((LazyIntIterator)jt.successors());
            while (it.hasNext()) {
                int n = it.nextInt();
                this.rprime[n] = this.rprime[n] + this.r[j] / (double)d;
            }
        }
        if (this.pl != null) {
            this.pl.done();
        }
        double resprime = 0.0;
        double multiplier = Math.pow((double)this.iteration / ((double)this.iteration + 1.0), this.beta);
        double summand = this.residual / (double)this.numNodes;
        jt = this.graph.nodeIterator();
        if (this.pl != null) {
            this.pl.itemsName = "nodes";
            this.pl.expectedUpdates = this.numNodes;
            this.pl.start((CharSequence)"Step (2nd phase)");
        }
        double l1norm = 0.0;
        while (jt.hasNext()) {
            if (this.pl != null) {
                this.pl.update();
            }
            j = jt.nextInt();
            this.r[j] = (this.rprime[j] + summand) * multiplier;
            int n = j;
            this.rank[n] = this.rank[n] + this.r[j];
            l1norm += Math.abs(this.r[j]);
            if (jt.outdegree() != 0) continue;
            resprime += this.r[j];
        }
        if (this.pl != null) {
            this.pl.stop((CharSequence)("Done: L1 norm of the last summand is " + l1norm));
        }
        this.residual = resprime;
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(GeneralHyperbolicRank.class.getName(), "Computes the general hyperbolic rank (uniform preference)", new Parameter[]{new FlaggedOption("beta", (StringParser)JSAP.DOUBLE_PARSER, "2", false, 'b', "beta", "The beta parameter"), new FlaggedOption("iter", (StringParser)JSAP.INTEGER_PARSER, "5", false, 'i', "iter", "The number of iterations"), new UnflaggedOption("graphFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The graph file"), new UnflaggedOption("rankFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The output file")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        double beta = jsapResult.getDouble("beta");
        int iterations = jsapResult.getInt("iter");
        ImmutableGraph graph = ImmutableGraph.load((CharSequence)jsapResult.getString("graphFile"));
        String rankFile = jsapResult.getString("rankFile");
        GeneralHyperbolicRank ghr = new GeneralHyperbolicRank(graph, null, beta, new ProgressLogger(LOGGER));
        ghr.init();
        for (int it = 0; it < iterations; ++it) {
            ghr.step();
        }
        BinIO.storeDoubles((double[])ghr.rank, (CharSequence)rankFile);
    }
}

